/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.settings.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.pentaho.reporting.designer.core.auth.GlobalAuthenticationStore;
import org.pentaho.reporting.designer.core.settings.SettingsMessages;
import org.pentaho.reporting.designer.core.util.IconLoader;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class ShowPasswordsDialog
extends CommonDialog {
    private PasswordTableModel tableModel;
    private JTable passwordTable;
    private GlobalAuthenticationStore globalAuthenticationStore;
    private RemovePasswordsAction removeAction;

    public ShowPasswordsDialog() throws HeadlessException {
        this.init();
    }

    public ShowPasswordsDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public ShowPasswordsDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    public void init() {
        this.setTitle(SettingsMessages.getInstance().getString("ShowPasswordsDialog.Title"));
        this.removeAction = new RemovePasswordsAction();
        this.tableModel = new PasswordTableModel();
        this.passwordTable = new JTable(this.tableModel);
        this.passwordTable.getSelectionModel().addListSelectionListener(this.removeAction);
        super.init();
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.ShowPasswords";
    }

    protected Component createContentPane() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        buttonPanel.add((Component)new BorderlessButton((Action)this.removeAction));
        JPanel headerPanel = new JPanel();
        headerPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        headerPanel.setLayout(new BorderLayout());
        headerPanel.add((Component)buttonPanel, "East");
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.setLayout(new BorderLayout());
        panel.add((Component)headerPanel, "North");
        panel.add((Component)new JScrollPane(this.passwordTable), "Center");
        return panel;
    }

    protected Action[] getExtraActions() {
        return new Action[]{new ShowPasswordsAction()};
    }

    public void showDialog(GlobalAuthenticationStore authenticationStore) {
        this.globalAuthenticationStore = authenticationStore;
        this.tableModel.setGlobalAuthenticationStore(authenticationStore);
        this.tableModel.setShowPasswords(false);
        this.performEdit();
    }

    protected boolean hasCancelButton() {
        return false;
    }

    private class RemovePasswordsAction
    extends AbstractAction
    implements ListSelectionListener {
        private RemovePasswordsAction() {
            this.putValue("SmallIcon", IconLoader.getInstance().getRemoveIcon());
            this.putValue("ShortDescription", SettingsMessages.getInstance().getString("ShowPasswordsDialog.RemovePassword"));
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int[] selectedRows = ShowPasswordsDialog.this.passwordTable.getSelectedRows();
            this.setEnabled(selectedRows.length > 0);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            if (ShowPasswordsDialog.this.globalAuthenticationStore == null) {
                return;
            }
            int[] selectedRows = ShowPasswordsDialog.this.passwordTable.getSelectedRows();
            String[] selectedURLs = new String[selectedRows.length];
            for (i = 0; i < selectedURLs.length; ++i) {
                selectedURLs[i] = (String)ShowPasswordsDialog.this.tableModel.getValueAt(selectedRows[i], 0);
            }
            for (i = 0; i < selectedURLs.length; ++i) {
                String selectedURL = selectedURLs[i];
                if (selectedURL == null) continue;
                ShowPasswordsDialog.this.globalAuthenticationStore.removeCredentials(selectedURL);
            }
            ShowPasswordsDialog.this.tableModel.fireTableDataChanged();
        }
    }

    private class ShowPasswordsAction
    extends AbstractAction {
        private ShowPasswordsAction() {
            this.putValue("Name", SettingsMessages.getInstance().getString("ShowPasswordsDialog.ShowPasswords"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowPasswordsDialog.this.tableModel.setShowPasswords(true);
        }
    }

    private static class PasswordTableModel
    extends AbstractTableModel {
        private GlobalAuthenticationStore globalAuthenticationStore;
        private boolean showPasswords;

        private PasswordTableModel() {
        }

        public GlobalAuthenticationStore getGlobalAuthenticationStore() {
            return this.globalAuthenticationStore;
        }

        public void setGlobalAuthenticationStore(GlobalAuthenticationStore globalAuthenticationStore) {
            this.globalAuthenticationStore = globalAuthenticationStore;
            this.fireTableDataChanged();
        }

        public boolean isShowPasswords() {
            return this.showPasswords;
        }

        public void setShowPasswords(boolean showPasswords) {
            this.showPasswords = showPasswords;
            this.fireTableStructureChanged();
        }

        @Override
        public int getRowCount() {
            if (this.globalAuthenticationStore == null) {
                return 0;
            }
            String[] strings = this.globalAuthenticationStore.getKnownURLs();
            return strings.length;
        }

        @Override
        public int getColumnCount() {
            if (this.showPasswords) {
                return 3;
            }
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.globalAuthenticationStore == null) {
                return null;
            }
            String[] strings = this.globalAuthenticationStore.getKnownURLs();
            if (rowIndex >= strings.length) {
                return null;
            }
            String url = strings[rowIndex];
            if (columnIndex == 0) {
                return url;
            }
            if (columnIndex == 1) {
                return this.globalAuthenticationStore.getUsername(url);
            }
            if (columnIndex == 2) {
                return this.globalAuthenticationStore.getPassword(url);
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return SettingsMessages.getInstance().getString("ShowPasswordsDialog.URL");
            }
            if (columnIndex == 1) {
                return SettingsMessages.getInstance().getString("ShowPasswordsDialog.Username");
            }
            if (columnIndex == 2) {
                return SettingsMessages.getInstance().getString("ShowPasswordsDialog.Password");
            }
            return super.getColumnName(columnIndex);
        }
    }
}

