/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.status;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.status.ExceptionStatusGadget;
import org.pentaho.reporting.designer.core.status.MemoryStatusGadget;
import org.pentaho.reporting.designer.core.status.MessagesStatusGadget;
import org.pentaho.reporting.designer.core.util.exceptions.UncaughtExceptionModelListener;

public class StatusBar
extends JPanel
implements UncaughtExceptionModelListener {
    private JLabel pagesLabel;
    private JLabel statusLabel;
    private ExceptionStatusGadget exceptionStatusGadget;
    private MemoryStatusGadget memoryStatusGadget;
    private MessagesStatusGadget messagesStatusGadget;

    public StatusBar(ReportDesignerContext designerContext) {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, SystemColor.controlLtHighlight));
        this.pagesLabel = new JLabel(" ");
        this.pagesLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.statusLabel = new JLabel(" ");
        this.statusLabel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.exceptionStatusGadget = new ExceptionStatusGadget();
        this.memoryStatusGadget = new MemoryStatusGadget();
        this.messagesStatusGadget = new MessagesStatusGadget(designerContext);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        this.add((Component)this.statusLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.ipadx = 120;
        gbc.fill = 1;
        this.add((Component)this.pagesLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.anchor = 13;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        this.add((Component)this.messagesStatusGadget, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 5;
        gbc.anchor = 13;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        this.add((Component)this.exceptionStatusGadget, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 6;
        gbc.anchor = 13;
        gbc.weightx = 0.0;
        gbc.fill = 3;
        this.add((Component)new JSeparator(1), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 7;
        gbc.anchor = 13;
        gbc.fill = 3;
        gbc.weightx = 0.0;
        this.add(this.memoryStatusGadget);
    }

    public void dispose() {
        this.memoryStatusGadget.dispose();
    }

    public void setPages(int page, int totalPage) {
        if (page == 0 || totalPage == 0) {
            this.pagesLabel.setText(" ");
        } else {
            this.pagesLabel.setText(page + " / " + totalPage);
        }
    }

    public void setGeneralInfoText(String text) {
        if (text == null || text.length() == 0) {
            this.statusLabel.setText(" ");
        } else {
            this.statusLabel.setText(text);
        }
    }

    @Override
    public void exceptionCaught(Throwable throwable) {
        this.exceptionStatusGadget.exceptionCaught(throwable);
    }

    @Override
    public void exceptionsCleared() {
        this.exceptionStatusGadget.exceptionsCleared();
    }

    @Override
    public void exceptionsViewed() {
        this.exceptionStatusGadget.exceptionsViewed();
    }
}

