/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.pentaho.reporting.designer.core.util.Unit;
import org.pentaho.reporting.designer.core.util.UtilMessages;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;

public class GuideLineDialog
extends CommonDialog {
    private JSpinner positionSpinner;
    private ComboBoxModel unitModel;
    private Unit unit;
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);

    public GuideLineDialog() throws HeadlessException {
        this.init();
    }

    public GuideLineDialog(Frame owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    public GuideLineDialog(Dialog owner) throws HeadlessException {
        super(owner);
        this.init();
    }

    private ComboBoxModel createUnitModel() {
        DefaultComboBoxModel<Unit> model = new DefaultComboBoxModel<Unit>(Unit.values());
        model.setSelectedItem((Object)Unit.POINTS);
        model.addListDataListener(new UnitChangeListener());
        return model;
    }

    protected String getDialogId() {
        return "ReportDesigner.Core.GuideLine";
    }

    protected ComboBoxModel getUnitModel() {
        return this.unitModel;
    }

    protected Component createContentPane() {
        this.unit = Unit.POINTS;
        this.setTitle(UtilMessages.getInstance().getString("GuideLineDialog.Position"));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.positionSpinner = new JSpinner(new SpinnerNumberModel(ZERO, ZERO, null, ONE));
        this.unitModel = this.createUnitModel();
        return this.createSelectionPane();
    }

    private JPanel createSelectionPane() {
        JPanel tablesPane = new JPanel();
        tablesPane.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)new JLabel(UtilMessages.getInstance().getString("GuideLineDialog.GridSize")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add((Component)this.positionSpinner, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        tablesPane.add((Component)new JLabel(UtilMessages.getInstance().getString("GuideLineDialog.GridUnit")), gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 5, 5, 5);
        tablesPane.add(new JComboBox(this.unitModel), gbc);
        return tablesPane;
    }

    public boolean showDialog() {
        return super.performEdit();
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setUnit(Unit newUnit) {
        if (newUnit == null) {
            throw new NullPointerException();
        }
        double gridSize = this.getPosition();
        if (newUnit != this.unitModel.getSelectedItem()) {
            this.unitModel.setSelectedItem((Object)newUnit);
        }
        this.unit = newUnit;
        this.setPosition(gridSize);
    }

    public void setPosition(double gridSize) {
        Unit unit = this.getUnit();
        this.positionSpinner.setValue(new Double(unit.convertFromPoints(gridSize)));
    }

    public double getPosition() {
        Object value = this.positionSpinner.getValue();
        if (value instanceof Number) {
            Number n = (Number)value;
            return this.getUnit().convertToPoints(n.doubleValue());
        }
        return 0.0;
    }

    private class UnitChangeListener
    implements ListDataListener {
        private UnitChangeListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            Unit unit1 = (Unit)((Object)GuideLineDialog.this.getUnitModel().getSelectedItem());
            if (unit1 == null) {
                throw new IllegalStateException("Unit cannot be set to null");
            }
            GuideLineDialog.this.setUnit(unit1);
        }
    }
}

