/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioTabbedPane
extends JComponent {
    public static final String SELECTED_INDEX_PROPERTY = "selectedIndex";
    private ArrayList components = new ArrayList();
    private ArrayList radioButtons = new ArrayList();
    private JPanel contentPanel;
    private JPanel selectorPanel;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private CardLayout cardLayout = new CardLayout();
    private int currentIndex;

    public RadioTabbedPane() {
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(this.cardLayout);
        this.selectorPanel = new JPanel();
        this.selectorPanel.setLayout(new FlowLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.contentPanel, "Center");
        this.add((Component)this.selectorPanel, "North");
    }

    public void addTab(String name, Component tab) {
        String cardName = String.valueOf(this.components.size());
        JRadioButton radioButton = new JRadioButton(name);
        radioButton.addActionListener(new SelectTabAction(this.components.size()));
        this.components.add(tab);
        this.buttonGroup.add(radioButton);
        this.radioButtons.add(radioButton);
        this.selectorPanel.add(radioButton);
        this.contentPanel.add(cardName, tab);
        this.cardLayout.show(this.contentPanel, cardName);
        radioButton.setSelected(true);
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index >= this.components.size()) {
            throw new IndexOutOfBoundsException();
        }
        JRadioButton o = (JRadioButton)this.radioButtons.get(index);
        o.setSelected(true);
        this.cardLayout.show(this.contentPanel, String.valueOf(index));
        int oldIndex = this.currentIndex;
        this.currentIndex = index;
        this.firePropertyChange(SELECTED_INDEX_PROPERTY, oldIndex, index);
    }

    public int getSelectedIndex() {
        return this.currentIndex;
    }

    private class SelectTabAction
    implements ActionListener {
        private int cardName;

        private SelectTabAction(int index) {
            this.cardName = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RadioTabbedPane.this.setSelectedIndex(this.cardName);
        }
    }
}

