/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.docking;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class Category {
    public static final String MINIMIZED_PROPERTY = "minimized";
    private PropertyChangeSupport propertyChangeSupport;
    private ImageIcon iconBig;
    private ImageIcon iconSmall;
    private String title;
    private JComponent mainComponent;
    private boolean minimized;

    public Category(ImageIcon iconBig, String title, JComponent mainComponent) {
        this(iconBig, iconBig, title, mainComponent, false);
    }

    public Category(ImageIcon iconBig, ImageIcon iconSmall, String title, JComponent mainComponent, boolean minimized) {
        this.minimized = minimized;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.iconBig = iconBig;
        this.iconSmall = iconSmall;
        this.title = title;
        this.mainComponent = mainComponent;
    }

    public boolean isMinimized() {
        return this.minimized;
    }

    public void setMinimized(boolean minimized) {
        boolean oldMinimized = this.minimized;
        this.minimized = minimized;
        this.propertyChangeSupport.firePropertyChange(MINIMIZED_PROPERTY, oldMinimized, minimized);
    }

    public ImageIcon getIconBig() {
        return this.iconBig;
    }

    public ImageIcon getIconSmall() {
        return this.iconSmall;
    }

    public String getTitle() {
        return this.title;
    }

    public JComponent getMainComponent() {
        return this.mainComponent;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

