/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.util.table;

import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.pentaho.reporting.designer.core.util.table.GroupedName;
import org.pentaho.reporting.designer.core.util.table.SortableTableModel;
import org.pentaho.reporting.designer.core.util.table.TableStyle;
import org.pentaho.reporting.engine.classic.core.metadata.MetaData;

public class GroupedNameCellRenderer
extends DefaultTableCellRenderer {
    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof GroupedName) {
            boolean preferred;
            boolean expert;
            boolean deprecated;
            GroupedName name = (GroupedName)value;
            String displayName = name.getName();
            MetaData metaData = name.getMetaData();
            if (metaData != null) {
                deprecated = metaData.isDeprecated();
                expert = metaData.isExpert();
                preferred = metaData.isPreferred();
            } else {
                deprecated = false;
                expert = false;
                preferred = false;
            }
            String prefix = "";
            if (deprecated) {
                prefix = "*";
            }
            int fontStyle = 0;
            if (expert) {
                fontStyle |= 2;
            }
            if (preferred) {
                fontStyle |= 1;
            }
            this.setFont(this.getFont().deriveFont(fontStyle));
            if (table.getModel() instanceof SortableTableModel) {
                SortableTableModel model = (SortableTableModel)table.getModel();
                TableStyle style = model.getTableStyle();
                if (TableStyle.GROUPED.equals((Object)style)) {
                    this.setText(prefix + displayName);
                } else {
                    this.setText(prefix + displayName + " (" + name.getGroupName() + ")");
                }
            } else {
                this.setText(prefix + displayName + " (" + name.getGroupName() + ")");
            }
        }
        return this;
    }
}

