/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.designer.core.widgets;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.pentaho.reporting.designer.core.ReportDesignerContext;
import org.pentaho.reporting.designer.core.actions.report.CloseReportAction;
import org.pentaho.reporting.designer.core.widgets.CloseTabIcon;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;

public class TabRenderer
extends JComponent
implements ActionListener {
    private String rawTabName;
    private JLabel label;
    private JButton closeButton;
    private ReportDesignerContext context;
    private JTabbedPane tabbedPane;

    public TabRenderer(Icon icon, String tabName, ReportDesignerContext context, JTabbedPane tabbedPane) {
        if (tabName == null) {
            throw new NullPointerException();
        }
        this.tabbedPane = tabbedPane;
        this.rawTabName = tabName;
        this.context = context;
        this.closeButton = new BorderlessButton();
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.closeButton.setPressedIcon(new CloseTabIcon(false, true));
        this.closeButton.setIcon(new CloseTabIcon(false, false));
        this.closeButton.setRolloverIcon(new CloseTabIcon(true, false));
        this.closeButton.setRolloverEnabled(true);
        this.closeButton.setContentAreaFilled(false);
        this.closeButton.setBorderPainted(false);
        this.closeButton.addActionListener(this);
        this.label = new JLabel(tabName, icon, 2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.closeButton, "East");
        this.add((Component)this.label, "Center");
    }

    private JTabbedPane getReportEditorPane() {
        return this.tabbedPane;
    }

    private ReportDesignerContext getContext() {
        return this.context;
    }

    private int findTab() {
        JTabbedPane tabbedPane = this.getReportEditorPane();
        int count = tabbedPane.getTabCount();
        for (int i = 0; i < count; ++i) {
            Component at = tabbedPane.getTabComponentAt(i);
            if (at != this) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int tab = this.findTab();
        if (tab == -1) {
            return;
        }
        CloseReportAction cra = new CloseReportAction(tab);
        cra.setReportDesignerContext(this.getContext());
        cra.actionPerformed(e);
    }

    public String getTitle() {
        return this.label.getText();
    }

    public void setTitle(String title) {
        this.label.setText(title);
    }

    public String getRawTabName() {
        return this.rawTabName;
    }

    public void setRawTabName(String rawTabName) {
        this.rawTabName = rawTabName;
    }

    public String recomputeTabName() {
        JTabbedPane editorPane = this.getReportEditorPane();
        int count = editorPane.getTabCount();
        int found = 0;
        for (int i = 0; i < count; ++i) {
            Component at = editorPane.getTabComponentAt(i);
            if (at == this) {
                if (found == 0) {
                    return this.rawTabName;
                }
                return this.rawTabName + "<" + found + ">";
            }
            if (at instanceof TabRenderer) {
                TabRenderer otherRenderer = (TabRenderer)at;
                if (!this.rawTabName.equals(otherRenderer.rawTabName)) continue;
                ++found;
                continue;
            }
            if (!this.rawTabName.equals(editorPane.getTitleAt(i))) continue;
            ++found;
        }
        return this.rawTabName;
    }
}

