/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.io.File;
import java.util.Properties;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs.util.Os;

public class SftpClientFactory {
    private static final String SSH_DIR_NAME = ".ssh";

    private SftpClientFactory() {
    }

    public static Session createConnection(String string, int n, char[] cArray, char[] cArray2, FileSystemOptions fileSystemOptions) throws FileSystemException {
        Session session;
        Comparable<File> comparable;
        JSch jSch = new JSch();
        File file = null;
        File file2 = SftpFileSystemConfigBuilder.getInstance().getKnownHosts(fileSystemOptions);
        File[] fileArray = SftpFileSystemConfigBuilder.getInstance().getIdentities(fileSystemOptions);
        if (file2 != null) {
            try {
                jSch.setKnownHosts(file2.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", file2.getAbsolutePath(), (Throwable)jSchException);
            }
        }
        if (file == null) {
            file = SftpClientFactory.findSshDir();
        }
        if ((file2 = new File(file, "known_hosts")).isFile() && file2.canRead()) {
            try {
                jSch.setKnownHosts(file2.getAbsolutePath());
            }
            catch (JSchException jSchException) {
                throw new FileSystemException("vfs.provider.sftp/known-hosts.error", file2.getAbsolutePath(), (Throwable)jSchException);
            }
        }
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                comparable = fileArray[i];
                try {
                    jSch.addIdentity(((File)comparable).getAbsolutePath());
                    continue;
                }
                catch (JSchException jSchException) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", comparable, (Throwable)jSchException);
                }
            }
        } else {
            File file3;
            if (file == null) {
                file = SftpClientFactory.findSshDir();
            }
            if ((file3 = new File(file, "id_rsa")).isFile() && file3.canRead()) {
                try {
                    jSch.addIdentity(file3.getAbsolutePath());
                }
                catch (JSchException jSchException) {
                    throw new FileSystemException("vfs.provider.sftp/load-private-key.error", file3, (Throwable)jSchException);
                }
            }
        }
        try {
            String string2;
            String string3;
            String string4;
            UserInfo userInfo;
            session = jSch.getSession(new String(cArray), string, n);
            if (cArray2 != null) {
                session.setPassword(new String(cArray2));
            }
            if ((comparable = SftpFileSystemConfigBuilder.getInstance().getTimeout(fileSystemOptions)) != null) {
                session.setTimeout(((Integer)comparable).intValue());
            }
            if ((userInfo = SftpFileSystemConfigBuilder.getInstance().getUserInfo(fileSystemOptions)) != null) {
                session.setUserInfo(userInfo);
            }
            Properties properties = new Properties();
            String string5 = SftpFileSystemConfigBuilder.getInstance().getStrictHostKeyChecking(fileSystemOptions);
            if (string5 != null) {
                properties.setProperty("StrictHostKeyChecking", string5);
            }
            if ((string4 = SftpFileSystemConfigBuilder.getInstance().getPreferredAuthentications(fileSystemOptions)) != null) {
                properties.setProperty("PreferredAuthentications", string4);
            }
            if ((string3 = SftpFileSystemConfigBuilder.getInstance().getCompression(fileSystemOptions)) != null) {
                properties.setProperty("compression.s2c", string3);
                properties.setProperty("compression.c2s", string3);
            }
            if ((string2 = SftpFileSystemConfigBuilder.getInstance().getProxyHost(fileSystemOptions)) != null) {
                int n2 = SftpFileSystemConfigBuilder.getInstance().getProxyPort(fileSystemOptions);
                SftpFileSystemConfigBuilder.ProxyType proxyType = SftpFileSystemConfigBuilder.getInstance().getProxyType(fileSystemOptions);
                ProxyHTTP proxyHTTP = null;
                if (SftpFileSystemConfigBuilder.PROXY_HTTP.equals(proxyType)) {
                    proxyHTTP = n2 != 0 ? new ProxyHTTP(string2, n2) : new ProxyHTTP(string2);
                } else if (SftpFileSystemConfigBuilder.PROXY_SOCKS5.equals(proxyType)) {
                    proxyHTTP = n2 != 0 ? new ProxySOCKS5(string2, n2) : new ProxySOCKS5(string2);
                }
                if (proxyHTTP != null) {
                    session.setProxy((Proxy)proxyHTTP);
                }
            }
            if (properties.size() > 0) {
                session.setConfig(properties);
            }
            session.setDaemonThread(true);
            session.connect();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.sftp/connect.error", new Object[]{string}, (Throwable)exception);
        }
        return session;
    }

    private static File findSshDir() {
        File file;
        String string = System.getProperty("vfs.sftp.sshdir");
        if (string != null && (file = new File(string)).exists()) {
            return file;
        }
        file = new File(System.getProperty("user.home"), SSH_DIR_NAME);
        if (file.exists()) {
            return file;
        }
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            String string2 = System.getProperty("user.name");
            file = new File("C:\\cygwin\\home\\" + string2 + "\\" + SSH_DIR_NAME);
            if (file.exists()) {
                return file;
            }
        }
        return new File("");
    }
}

