/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.zip.GZIPInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.bzip2.Bzip2FileObject;
import org.apache.commons.vfs.provider.tar.TarEntry;
import org.apache.commons.vfs.provider.tar.TarFileObject;
import org.apache.commons.vfs.provider.tar.TarFileProvider;
import org.apache.commons.vfs.provider.tar.TarInputStream;

public class TarFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log log = LogFactory.getLog(TarFileSystem.class);
    private final File file;
    private TarInputStream tarFile;

    protected TarFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(fileName, fileObject, fileSystemOptions);
        this.file = fileObject.getFileSystem().replicateFile(fileObject, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.tarFile = null;
            return;
        }
    }

    public void init() throws FileSystemException {
        super.init();
        try {
            TarEntry tarEntry;
            ArrayList<TarFileObject> arrayList = new ArrayList<TarFileObject>(100);
            while ((tarEntry = this.getTarFile().getNextEntry()) != null) {
                TarFileObject tarFileObject;
                FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(tarEntry.getName()));
                if (tarEntry.isDirectory() && this.getFileFromCache(fileName) != null) {
                    tarFileObject = (TarFileObject)this.getFileFromCache(fileName);
                    tarFileObject.setTarEntry(tarEntry);
                    continue;
                }
                tarFileObject = this.createTarFileObject(fileName, tarEntry);
                this.putFileToCache(tarFileObject);
                arrayList.add(tarFileObject);
                tarFileObject.holdObject(arrayList);
                TarFileObject tarFileObject2 = null;
                for (FileName fileName2 = fileName.getParent(); fileName2 != null; fileName2 = fileName2.getParent()) {
                    tarFileObject2 = (TarFileObject)this.getFileFromCache(fileName2);
                    if (tarFileObject2 == null) {
                        tarFileObject2 = this.createTarFileObject(fileName2, null);
                        this.putFileToCache(tarFileObject2);
                        arrayList.add(tarFileObject2);
                        tarFileObject2.holdObject(arrayList);
                    }
                    tarFileObject2.attachChild(tarFileObject.getName());
                    tarFileObject = tarFileObject2;
                }
            }
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    public InputStream getInputStream(TarEntry tarEntry) throws FileSystemException {
        this.resetTarFile();
        try {
            while (!this.tarFile.getNextEntry().equals(tarEntry)) {
            }
            return this.tarFile;
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
    }

    protected void resetTarFile() throws FileSystemException {
        if (this.file.exists()) {
            this.recreateTarFile();
        }
    }

    private void recreateTarFile() throws FileSystemException {
        TarInputStream tarInputStream;
        if (this.tarFile != null) {
            try {
                this.tarFile.close();
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider.tar/close-tar-file.error", this.file, (Throwable)iOException);
            }
            this.tarFile = null;
        }
        this.tarFile = tarInputStream = this.createTarFile(this.file);
    }

    protected TarInputStream getTarFile() throws FileSystemException {
        if (this.tarFile == null && this.file.exists()) {
            this.recreateTarFile();
        }
        return this.tarFile;
    }

    protected TarFileObject createTarFileObject(FileName fileName, TarEntry tarEntry) throws FileSystemException {
        return new TarFileObject(fileName, tarEntry, this, true);
    }

    protected TarInputStream createTarFile(File file) throws FileSystemException {
        try {
            if ("tgz".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(new GZIPInputStream(new FileInputStream(file)));
            }
            if ("tbz2".equalsIgnoreCase(this.getRootName().getScheme())) {
                return new TarInputStream(Bzip2FileObject.wrapInputStream(file.getAbsolutePath(), new FileInputStream(file)));
            }
            return new TarInputStream(new FileInputStream(file));
        }
        catch (IOException iOException) {
            throw new FileSystemException("vfs.provider.tar/open-tar-file.error", file, (Throwable)iOException);
        }
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.tarFile != null) {
                this.tarFile.close();
                this.tarFile = null;
            }
        }
        catch (IOException iOException) {
            VfsLog.warn(this.getLogger(), log, "vfs.provider.tar/close-tar-file.error :" + this.file, iOException);
        }
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(TarFileProvider.capabilities);
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new TarFileObject(fileName, null, this, false);
    }
}

