/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.dialog;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class EnterValueDialog
extends Dialog {
    private static Class<?> PKG = EnterValueDialog.class;
    private Display display;
    private Label wlValueType;
    private CCombo wValueType;
    private FormData fdlValueType;
    private FormData fdValueType;
    private Label wlInputString;
    private Text wInputString;
    private FormData fdlInputString;
    private FormData fdInputString;
    private Label wlFormat;
    private CCombo wFormat;
    private FormData fdlFormat;
    private FormData fdFormat;
    private Label wlLength;
    private Text wLength;
    private FormData fdlLength;
    private FormData fdLength;
    private Label wlPrecision;
    private Text wPrecision;
    private FormData fdlPrecision;
    private FormData fdPrecision;
    private Button wOK;
    private Button wCancel;
    private Button wTest;
    private Listener lsOK;
    private Listener lsCancel;
    private Listener lsTest;
    private Shell shell;
    private SelectionAdapter lsDef;
    private PropsUI props = PropsUI.getInstance();
    private ValueMetaAndData valueMetaAndData;
    private ValueMetaInterface valueMeta;
    private Object valueData;
    private boolean modalDialog;

    public EnterValueDialog(Shell parent, int style, ValueMetaInterface value, Object data) {
        super(parent, style);
        this.valueMeta = value;
        this.valueData = data;
    }

    public ValueMetaAndData open() {
        Shell parent = this.getParent();
        this.display = parent.getDisplay();
        this.shell = new Shell(parent, 0x870 | (this.modalDialog ? 0x10010000 : 0));
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlValueType = new Label((Composite)this.shell, 131072);
        this.wlValueType.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Type.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValueType);
        this.fdlValueType = new FormData();
        this.fdlValueType.left = new FormAttachment(0, 0);
        this.fdlValueType.right = new FormAttachment(middle, -margin);
        this.fdlValueType.top = new FormAttachment(0, margin);
        this.wlValueType.setLayoutData((Object)this.fdlValueType);
        this.wValueType = new CCombo((Composite)this.shell, 18444);
        this.wValueType.setItems(ValueMeta.getTypes());
        this.props.setLook((Control)this.wValueType);
        this.fdValueType = new FormData();
        this.fdValueType.left = new FormAttachment(middle, 0);
        this.fdValueType.top = new FormAttachment(0, margin);
        this.fdValueType.right = new FormAttachment(100, -margin);
        this.wValueType.setLayoutData((Object)this.fdValueType);
        this.wValueType.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                EnterValueDialog.this.setFormats();
            }
        });
        this.wlInputString = new Label((Composite)this.shell, 131072);
        this.wlInputString.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Value.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInputString);
        this.fdlInputString = new FormData();
        this.fdlInputString.left = new FormAttachment(0, 0);
        this.fdlInputString.right = new FormAttachment(middle, -margin);
        this.fdlInputString.top = new FormAttachment((Control)this.wValueType, margin);
        this.wlInputString.setLayoutData((Object)this.fdlInputString);
        this.wInputString = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInputString);
        this.fdInputString = new FormData();
        this.fdInputString.left = new FormAttachment(middle, 0);
        this.fdInputString.top = new FormAttachment((Control)this.wValueType, margin);
        this.fdInputString.right = new FormAttachment(100, -margin);
        this.wInputString.setLayoutData((Object)this.fdInputString);
        this.wlFormat = new Label((Composite)this.shell, 131072);
        this.wlFormat.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.ConversionFormat.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFormat);
        this.fdlFormat = new FormData();
        this.fdlFormat.left = new FormAttachment(0, 0);
        this.fdlFormat.right = new FormAttachment(middle, -margin);
        this.fdlFormat.top = new FormAttachment((Control)this.wInputString, margin);
        this.wlFormat.setLayoutData((Object)this.fdlFormat);
        this.wFormat = new CCombo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFormat);
        this.fdFormat = new FormData();
        this.fdFormat.left = new FormAttachment(middle, 0);
        this.fdFormat.right = new FormAttachment(100, -margin);
        this.fdFormat.top = new FormAttachment((Control)this.wInputString, margin);
        this.wFormat.setLayoutData((Object)this.fdFormat);
        this.wlLength = new Label((Composite)this.shell, 131072);
        this.wlLength.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Length.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLength);
        this.fdlLength = new FormData();
        this.fdlLength.left = new FormAttachment(0, 0);
        this.fdlLength.right = new FormAttachment(middle, -margin);
        this.fdlLength.top = new FormAttachment((Control)this.wFormat, margin);
        this.wlLength.setLayoutData((Object)this.fdlLength);
        this.wLength = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLength);
        this.fdLength = new FormData();
        this.fdLength.left = new FormAttachment(middle, 0);
        this.fdLength.right = new FormAttachment(100, -margin);
        this.fdLength.top = new FormAttachment((Control)this.wFormat, margin);
        this.wLength.setLayoutData((Object)this.fdLength);
        this.wlPrecision = new Label((Composite)this.shell, 131072);
        this.wlPrecision.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.Precision.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrecision);
        this.fdlPrecision = new FormData();
        this.fdlPrecision.left = new FormAttachment(0, 0);
        this.fdlPrecision.right = new FormAttachment(middle, -margin);
        this.fdlPrecision.top = new FormAttachment((Control)this.wLength, margin);
        this.wlPrecision.setLayoutData((Object)this.fdlPrecision);
        this.wPrecision = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrecision);
        this.fdPrecision = new FormData();
        this.fdPrecision.left = new FormAttachment(middle, 0);
        this.fdPrecision.right = new FormAttachment(100, -margin);
        this.fdPrecision.top = new FormAttachment((Control)this.wLength, margin);
        this.wPrecision.setLayoutData((Object)this.fdPrecision);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wTest = new Button((Composite)this.shell, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"System.Button.Test", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wTest, this.wCancel}, margin, (Control)this.wPrecision);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                EnterValueDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                EnterValueDialog.this.ok();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                EnterValueDialog.this.test();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                EnterValueDialog.this.ok();
            }
        };
        this.wInputString.addSelectionListener((SelectionListener)this.lsDef);
        this.wLength.addSelectionListener((SelectionListener)this.lsDef);
        this.wPrecision.addSelectionListener((SelectionListener)this.lsDef);
        this.wInputString.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                EnterValueDialog.this.setFormats();
            }
        });
        this.wValueType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                EnterValueDialog.this.setFormats();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                EnterValueDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.valueMetaAndData;
    }

    protected void setFormats() {
        int formatIndex = this.wFormat.getSelectionIndex();
        String formatString = formatIndex >= 0 ? this.wFormat.getItem(formatIndex) : "";
        int type = ValueMeta.getType((String)this.wValueType.getText());
        String string = this.wInputString.getText();
        if (type != 2 && (string.startsWith(" ") || string.endsWith(" "))) {
            string = Const.trim((String)string);
            this.wInputString.setText(string);
        }
        switch (type) {
            case 5: {
                int index;
                this.wFormat.setItems(Const.getNumberFormats());
                int n = index = !Const.isEmpty((String)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("#");
                if (!Const.isEmpty((String)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 1: {
                int index;
                this.wFormat.setItems(Const.getNumberFormats());
                int n = index = !Const.isEmpty((String)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("#.#");
                if (!Const.isEmpty((String)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 3: {
                int index;
                this.wFormat.setItems(Const.getDateFormats());
                int n = index = !Const.isEmpty((String)formatString) ? this.wFormat.indexOf(formatString) : this.wFormat.indexOf("yyyy/MM/dd HH:mm:ss");
                if (!Const.isEmpty((String)formatString) && index < 0) {
                    this.wFormat.add(formatString);
                    index = this.wFormat.indexOf(formatString);
                }
                this.wFormat.select(index);
                break;
            }
            case 6: {
                this.wFormat.setItems(new String[0]);
                break;
            }
            default: {
                this.wFormat.setItems(new String[0]);
            }
        }
    }

    public void dispose() {
        this.shell.dispose();
    }

    public void getData() {
        this.wValueType.setText(this.valueMeta.getTypeDesc());
        try {
            String value;
            if (this.valueData != null && (value = this.valueMeta.getString(this.valueData)) != null) {
                this.wInputString.setText(value);
            }
        }
        catch (KettleValueException e) {
            this.wInputString.setText(this.valueMeta.toString());
        }
        this.setFormats();
        int index = -1;
        if (!Const.isEmpty((String)this.valueMeta.getConversionMask()) && (index = this.wFormat.indexOf(this.valueMeta.getConversionMask())) < 0) {
            this.wFormat.add(this.valueMeta.getConversionMask());
            index = this.wFormat.indexOf(this.valueMeta.getConversionMask());
        }
        if (index >= 0) {
            this.wFormat.select(index);
        }
        this.wLength.setText(Integer.toString(this.valueMeta.getLength()));
        this.wPrecision.setText(Integer.toString(this.valueMeta.getPrecision()));
        this.setFormats();
        this.wInputString.setFocus();
        this.wInputString.selectAll();
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.valueMeta = null;
        this.dispose();
    }

    private ValueMetaAndData getValue(String valuename) throws KettleValueException {
        try {
            int valtype = ValueMeta.getType((String)this.wValueType.getText());
            ValueMetaAndData val = new ValueMetaAndData(valuename, (Object)this.wInputString.getText());
            ValueMetaInterface valueMeta = ValueMetaFactory.cloneValueMeta((ValueMetaInterface)val.getValueMeta(), (int)valtype);
            Object valueData = val.getValueData();
            int formatIndex = this.wFormat.getSelectionIndex();
            valueMeta.setConversionMask(formatIndex >= 0 ? this.wFormat.getItem(formatIndex) : this.wFormat.getText());
            valueMeta.setLength(Const.toInt((String)this.wLength.getText(), (int)-1));
            valueMeta.setPrecision(Const.toInt((String)this.wPrecision.getText(), (int)-1));
            val.setValueMeta(valueMeta);
            ValueMeta stringValueMeta = new ValueMeta(valuename, 2);
            stringValueMeta.setConversionMetadata(valueMeta);
            Object targetData = stringValueMeta.convertDataUsingConversionMetaData(valueData);
            val.setValueData(targetData);
            return val;
        }
        catch (Exception e) {
            throw new KettleValueException((Throwable)e);
        }
    }

    private void ok() {
        try {
            this.valueMetaAndData = this.getValue(this.valueMeta.getName());
            this.dispose();
        }
        catch (KettleValueException e) {
            new ErrorDialog(this.shell, "Error", "There was a conversion error: ", (Exception)((Object)e));
        }
    }

    public void test() {
        try {
            ValueMetaAndData v = this.getValue(this.valueMeta.getName());
            MessageBox mb = new MessageBox(this.shell, 34);
            StringBuffer result = new StringBuffer();
            result.append(Const.CR).append(Const.CR).append("    ").append(v.toString());
            result.append(Const.CR).append("    ").append(v.toStringMeta());
            mb.setMessage(BaseMessages.getString(PKG, (String)"EnterValueDialog.TestResult.Message", (String[])new String[]{result.toString()}));
            mb.setText(BaseMessages.getString(PKG, (String)"EnterValueDialog.TestResult.Title", (String[])new String[0]));
            mb.open();
        }
        catch (KettleValueException e) {
            new ErrorDialog(this.shell, "Error", "There was an error during data type conversion: ", (Exception)((Object)e));
        }
    }

    public boolean isModalDialog() {
        return this.modalDialog;
    }

    public void setModalDialog(boolean modalDialog) {
        this.modalDialog = modalDialog;
    }
}

