/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.pgpverify;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.pgpverify.JobEntryPGPVerify;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class JobEntryPGPVerifyDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntryPGPVerify.class;
    private static final String[] EXTENSIONS = new String[]{"*"};
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"JobPGPVerify.Filetype.All", (String[])new String[0])};
    private Label wlName;
    private Text wName;
    private FormData fdlName;
    private FormData fdName;
    private Label wlGPGLocation;
    private Button wbGPGLocation;
    private TextVar wGPGLocation;
    private FormData fdlGPGLocation;
    private FormData fdbGPGLocation;
    private FormData fdGPGLocation;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Label wluseDetachedSignature;
    private Button wuseDetachedSignature;
    private FormData fdluseDetachedSignature;
    private FormData fduseDetachedSignature;
    private Label wlDetachedFilename;
    private Button wbDetachedFilename;
    private TextVar wDetachedFilename;
    private FormData fdlDetachedFilename;
    private FormData fdbDetachedFilename;
    private FormData fdDetachedFilename;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntryPGPVerify jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Group wSettings;
    private FormData fdSettings;

    public JobEntryPGPVerifyDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntryPGPVerify)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobPGPVerify.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPGPVerifyDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlName = new Label((Composite)this.shell, 131072);
        this.wlName.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlName);
        this.fdlName = new FormData();
        this.fdlName.left = new FormAttachment(0, 0);
        this.fdlName.right = new FormAttachment(middle, -margin);
        this.fdlName.top = new FormAttachment(0, margin);
        this.wlName.setLayoutData((Object)this.fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.left = new FormAttachment(middle, 0);
        this.fdName.top = new FormAttachment(0, margin);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)this.fdName);
        this.wSettings = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSettings);
        this.wSettings.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.Settings.Group.Label", (String[])new String[0]));
        FormLayout SettingsgroupLayout = new FormLayout();
        SettingsgroupLayout.marginWidth = 10;
        SettingsgroupLayout.marginHeight = 10;
        this.wSettings.setLayout((Layout)SettingsgroupLayout);
        this.wlGPGLocation = new Label((Composite)this.wSettings, 131072);
        this.wlGPGLocation.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.GPGLocation.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGPGLocation);
        this.fdlGPGLocation = new FormData();
        this.fdlGPGLocation.left = new FormAttachment(0, 0);
        this.fdlGPGLocation.top = new FormAttachment((Control)this.wName, margin);
        this.fdlGPGLocation.right = new FormAttachment(middle, -margin);
        this.wlGPGLocation.setLayoutData((Object)this.fdlGPGLocation);
        this.wbGPGLocation = new Button((Composite)this.wSettings, 0x1000008);
        this.props.setLook((Control)this.wbGPGLocation);
        this.wbGPGLocation.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbGPGLocation = new FormData();
        this.fdbGPGLocation.right = new FormAttachment(100, 0);
        this.fdbGPGLocation.top = new FormAttachment((Control)this.wName, 0);
        this.wbGPGLocation.setLayoutData((Object)this.fdbGPGLocation);
        this.wGPGLocation = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettings, 18436);
        this.props.setLook((Control)this.wGPGLocation);
        this.wGPGLocation.addModifyListener(lsMod);
        this.fdGPGLocation = new FormData();
        this.fdGPGLocation.left = new FormAttachment(middle, 0);
        this.fdGPGLocation.top = new FormAttachment((Control)this.wName, margin);
        this.fdGPGLocation.right = new FormAttachment((Control)this.wbGPGLocation, -margin);
        this.wGPGLocation.setLayoutData(this.fdGPGLocation);
        this.wlFilename = new Label((Composite)this.wSettings, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wGPGLocation, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.wSettings, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wGPGLocation, 0);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettings, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.top = new FormAttachment((Control)this.wGPGLocation, margin);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wluseDetachedSignature = new Label((Composite)this.wSettings, 131072);
        this.wluseDetachedSignature.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.useDetachedSignature.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wluseDetachedSignature);
        this.fdluseDetachedSignature = new FormData();
        this.fdluseDetachedSignature.left = new FormAttachment(0, 0);
        this.fdluseDetachedSignature.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdluseDetachedSignature.right = new FormAttachment(middle, -margin);
        this.wluseDetachedSignature.setLayoutData((Object)this.fdluseDetachedSignature);
        this.wuseDetachedSignature = new Button((Composite)this.wSettings, 32);
        this.props.setLook((Control)this.wuseDetachedSignature);
        this.wuseDetachedSignature.setToolTipText(BaseMessages.getString(PKG, (String)"JobPGPVerify.useDetachedSignature.Tooltip", (String[])new String[0]));
        this.fduseDetachedSignature = new FormData();
        this.fduseDetachedSignature.left = new FormAttachment(middle, 0);
        this.fduseDetachedSignature.top = new FormAttachment((Control)this.wFilename, margin);
        this.fduseDetachedSignature.right = new FormAttachment(100, -margin);
        this.wuseDetachedSignature.setLayoutData((Object)this.fduseDetachedSignature);
        this.wuseDetachedSignature.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntryPGPVerifyDialog.this.enableDetachedSignature();
            }
        });
        this.wlDetachedFilename = new Label((Composite)this.wSettings, 131072);
        this.wlDetachedFilename.setText(BaseMessages.getString(PKG, (String)"JobPGPVerify.DetachedFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDetachedFilename);
        this.fdlDetachedFilename = new FormData();
        this.fdlDetachedFilename.left = new FormAttachment(0, 0);
        this.fdlDetachedFilename.top = new FormAttachment((Control)this.wuseDetachedSignature, margin);
        this.fdlDetachedFilename.right = new FormAttachment(middle, -margin);
        this.wlDetachedFilename.setLayoutData((Object)this.fdlDetachedFilename);
        this.wbDetachedFilename = new Button((Composite)this.wSettings, 0x1000008);
        this.props.setLook((Control)this.wbDetachedFilename);
        this.wbDetachedFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbDetachedFilename = new FormData();
        this.fdbDetachedFilename.right = new FormAttachment(100, 0);
        this.fdbDetachedFilename.top = new FormAttachment((Control)this.wuseDetachedSignature, 0);
        this.wbDetachedFilename.setLayoutData((Object)this.fdbDetachedFilename);
        this.wDetachedFilename = new TextVar((VariableSpace)this.jobMeta, (Composite)this.wSettings, 18436);
        this.props.setLook((Control)this.wDetachedFilename);
        this.wDetachedFilename.addModifyListener(lsMod);
        this.fdDetachedFilename = new FormData();
        this.fdDetachedFilename.left = new FormAttachment(middle, 0);
        this.fdDetachedFilename.top = new FormAttachment((Control)this.wuseDetachedSignature, margin);
        this.fdDetachedFilename.right = new FormAttachment((Control)this.wbDetachedFilename, -margin);
        this.wDetachedFilename.setLayoutData(this.fdDetachedFilename);
        this.wDetachedFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPGPVerifyDialog.this.wDetachedFilename.setToolTipText(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wDetachedFilename.getText()));
            }
        });
        this.wbDetachedFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FileObject DetachedFilename = null;
                    try {
                        String curFile = JobEntryPGPVerifyDialog.this.wDetachedFilename.getText();
                        DetachedFilename = curFile.trim().length() > 0 ? KettleVFS.getInstance().getFileSystemManager().resolveFile(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wDetachedFilename.getText())) : KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    catch (FileSystemException ex) {
                        DetachedFilename = KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(DetachedFilename.getParent(), DetachedFilename);
                    FileObject selected = vfsFileChooser.open(JobEntryPGPVerifyDialog.this.shell, null, EXTENSIONS, FILETYPES, 0);
                    JobEntryPGPVerifyDialog.this.wDetachedFilename.setText(selected != null ? selected.getURL().toString() : "");
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPGPVerifyDialog.this.wFilename.setToolTipText(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wFilename.getText()));
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FileObject fileName = null;
                    try {
                        String curFile = JobEntryPGPVerifyDialog.this.wFilename.getText();
                        fileName = curFile.trim().length() > 0 ? KettleVFS.getInstance().getFileSystemManager().resolveFile(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wFilename.getText())) : KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    catch (FileSystemException ex) {
                        fileName = KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(fileName.getParent(), fileName);
                    FileObject selected = vfsFileChooser.open(JobEntryPGPVerifyDialog.this.shell, null, EXTENSIONS, FILETYPES, 0);
                    JobEntryPGPVerifyDialog.this.wFilename.setText(selected != null ? selected.getURL().toString() : "");
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.wGPGLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntryPGPVerifyDialog.this.wGPGLocation.setToolTipText(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wGPGLocation.getText()));
            }
        });
        this.wbGPGLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FileObject fileName = null;
                    try {
                        String curFile = JobEntryPGPVerifyDialog.this.wGPGLocation.getText();
                        fileName = curFile.trim().length() > 0 ? KettleVFS.getInstance().getFileSystemManager().resolveFile(JobEntryPGPVerifyDialog.this.jobMeta.environmentSubstitute(JobEntryPGPVerifyDialog.this.wGPGLocation.getText())) : KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    catch (FileSystemException ex) {
                        fileName = KettleVFS.getInstance().getFileSystemManager().resolveFile(Const.getUserHomeDirectory());
                    }
                    VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(fileName.getParent(), fileName);
                    FileObject selected = vfsFileChooser.open(JobEntryPGPVerifyDialog.this.shell, null, EXTENSIONS, FILETYPES, 0);
                    JobEntryPGPVerifyDialog.this.wGPGLocation.setText(selected != null ? selected.getURL().toString() : "");
                }
                catch (FileSystemException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.fdSettings = new FormData();
        this.fdSettings.left = new FormAttachment(0, margin);
        this.fdSettings.top = new FormAttachment((Control)this.wName, margin);
        this.fdSettings.right = new FormAttachment(100, -margin);
        this.wSettings.setLayoutData((Object)this.fdSettings);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        FormData fd = new FormData();
        fd.right = new FormAttachment(50, -10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wOK.setLayoutData((Object)fd);
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        fd = new FormData();
        fd.left = new FormAttachment(50, 10);
        fd.bottom = new FormAttachment(100, 0);
        fd.width = 100;
        this.wCancel.setLayoutData((Object)fd);
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wSettings);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPGPVerifyDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntryPGPVerifyDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntryPGPVerifyDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wGPGLocation.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntryPGPVerifyDialog.this.cancel();
            }
        });
        this.getData();
        this.enableDetachedSignature();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobPGPVerifyDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        if (this.jobEntry.getGPGLocation() != null) {
            this.wGPGLocation.setText(this.jobEntry.getGPGLocation());
        }
        if (this.jobEntry.getFilename() != null) {
            this.wFilename.setText(this.jobEntry.getFilename());
        }
        if (this.jobEntry.getDetachedfilename() != null) {
            this.wDetachedFilename.setText(this.jobEntry.getDetachedfilename());
        }
        this.wuseDetachedSignature.setSelection(this.jobEntry.useDetachedfilename());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setGPGLocation(this.wGPGLocation.getText());
        this.jobEntry.setFilename(this.wFilename.getText());
        this.jobEntry.setDetachedfilename(this.wDetachedFilename.getText());
        this.jobEntry.setUseDetachedfilename(this.wuseDetachedSignature.getSelection());
        this.dispose();
    }

    private void enableDetachedSignature() {
        this.wlDetachedFilename.setEnabled(this.wuseDetachedSignature.getSelection());
        this.wDetachedFilename.setEnabled(this.wuseDetachedSignature.getSelection());
        this.wbDetachedFilename.setEnabled(this.wuseDetachedSignature.getSelection());
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

