/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;

public class TipsDialog
extends Dialog {
    private static Class<?> PKG = TipsDialog.class;
    private String title;
    private String message;
    private Label wlDesc;
    private Text wDesc;
    private FormData fdlDesc;
    private FormData fdDesc;
    private Label wlShowTips;
    private Button wShowTips;
    private FormData fdlShowTips;
    private FormData fdShowTips;
    private boolean showtips;
    private Shell shell;
    private Display display;
    private PropsUI props = PropsUI.getInstance();
    private String description;
    private Font font;
    private Shell parent;

    public TipsDialog(Shell parent) {
        super(parent, 0);
        this.title = BaseMessages.getString(PKG, (String)"TipsDialog.Dialog.Tips.Title", (String[])new String[0]);
        this.message = BaseMessages.getString(PKG, (String)"TipsDialog.Label.Tips", (String[])new String[0]);
        this.parent = parent;
        this.description = this.getTip();
    }

    public String open() {
        this.display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        this.showtips = this.props.showTips();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlDesc = new Label((Composite)this.shell, 0);
        this.wlDesc.setText(this.message);
        this.props.setLook((Control)this.wlDesc);
        this.wlDesc.setFont(this.font);
        this.fdlDesc = new FormData();
        this.fdlDesc.left = new FormAttachment(0, 0);
        this.fdlDesc.top = new FormAttachment(0, margin);
        this.wlDesc.setLayoutData((Object)this.fdlDesc);
        this.wDesc = new Text((Composite)this.shell, 16970);
        this.wDesc.setText(this.description);
        this.props.setLook((Control)this.wDesc);
        this.wDesc.setFont(this.font);
        this.fdDesc = new FormData();
        this.fdDesc.left = new FormAttachment(0, 0);
        this.fdDesc.top = new FormAttachment((Control)this.wlDesc, margin);
        this.fdDesc.right = new FormAttachment(100, 0);
        this.fdDesc.bottom = new FormAttachment(100, -75);
        this.wDesc.setLayoutData((Object)this.fdDesc);
        this.wlShowTips = new Label((Composite)this.shell, 131072);
        this.wlShowTips.setText(BaseMessages.getString(PKG, (String)"TipsDialog.OptionShowTips.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlShowTips);
        this.wlShowTips.setFont(this.font);
        this.fdlShowTips = new FormData();
        this.fdlShowTips.left = new FormAttachment(0, 0);
        this.fdlShowTips.top = new FormAttachment((Control)this.wDesc, margin * 2);
        this.fdlShowTips.right = new FormAttachment(middle, -margin);
        this.wlShowTips.setLayoutData((Object)this.fdlShowTips);
        this.wShowTips = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wShowTips);
        this.wShowTips.setFont(this.font);
        this.wShowTips.setSelection(this.showtips);
        this.fdShowTips = new FormData();
        this.fdShowTips.left = new FormAttachment(middle, 0);
        this.fdShowTips.top = new FormAttachment((Control)this.wDesc, margin * 2);
        this.fdShowTips.right = new FormAttachment(100, 0);
        this.wShowTips.setLayoutData((Object)this.fdShowTips);
        this.wShowTips.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TipsDialog.this.showtips = !TipsDialog.this.showtips;
            }
        });
        this.populateButtons(this.shell);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                TipsDialog.this.next();
            }
        });
        this.getData();
        WindowProperty winprop = this.props.getScreen(this.shell.getText());
        if (winprop != null) {
            winprop.setShell(this.shell);
        } else {
            Point p = this.getMax(this.wDesc.getText());
            this.shell.setSize(p.x + 100, p.y + 150);
        }
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        return this.description;
    }

    public void dispose() {
        this.props.setShowTips(this.showtips);
        this.shell.dispose();
    }

    public void getData() {
        if (this.description != null) {
            this.wDesc.setText(this.description);
        }
    }

    private void next() {
        this.wDesc.setText(this.getTip());
    }

    private String getTip() {
        String[] tips;
        String retval = "";
        int tipnr = this.props.getTipNr();
        if (tipnr <= (tips = Const.getTips()).length - 1) {
            retval = tips[tipnr];
        }
        if (++tipnr > tips.length - 1) {
            tipnr = 0;
        }
        this.props.setTipNr(tipnr);
        return retval;
    }

    private Point getMax(String str) {
        Image img = new Image((Device)this.display, 1, 1);
        GC gc = new GC((Drawable)img);
        Point p = gc.textExtent(str, 6);
        gc.dispose();
        img.dispose();
        return p;
    }

    private void ok() {
        this.dispose();
    }

    private void populateButtons(Shell parent) {
        int width = 0;
        int margin = 4;
        Button wOK = new Button((Composite)parent, 8);
        wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        wOK.pack(true);
        Rectangle rOK = wOK.getBounds();
        Button wNext = new Button((Composite)parent, 8);
        wNext.setText(BaseMessages.getString(PKG, (String)"TipsDialog.Button.Tips", (String[])new String[0]));
        wNext.pack(true);
        Rectangle rNext = wNext.getBounds();
        width = rOK.width > rNext.width ? rOK.width : rNext.width;
        FormData fdOK = new FormData();
        fdOK.left = new FormAttachment(50, -(width += margin));
        fdOK.right = new FormAttachment(50, -(margin / 2));
        fdOK.bottom = new FormAttachment(100, 0);
        wOK.setLayoutData((Object)fdOK);
        FormData fdNext = new FormData();
        fdNext.left = new FormAttachment(50, margin / 2);
        fdNext.right = new FormAttachment(50, width);
        fdNext.bottom = new FormAttachment(100, 0);
        wNext.setLayoutData((Object)fdNext);
        Listener lsNext = new Listener(){

            public void handleEvent(Event e) {
                TipsDialog.this.next();
            }
        };
        Listener lsOK = new Listener(){

            public void handleEvent(Event e) {
                TipsDialog.this.ok();
            }
        };
        wOK.addListener(13, lsOK);
        wNext.addListener(13, lsNext);
    }
}

