/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.partition;

import java.util.Collections;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepPartitioningMeta;
import org.pentaho.di.ui.spoon.PartitionSchemasProvider;

public class PartitionSettings {
    private final StepMeta stepMeta;
    private final TransMeta transMeta;
    private final PartitionSchemasProvider schemasProvider;
    private final String[] options;
    private final String[] codes;
    private final StepMeta before;

    public PartitionSettings(int exactSize, TransMeta transMeta, StepMeta stepMeta, PartitionSchemasProvider schemasProvider) {
        this.transMeta = transMeta;
        this.stepMeta = stepMeta;
        this.schemasProvider = schemasProvider;
        this.options = new String[exactSize];
        this.codes = new String[exactSize];
        this.before = (StepMeta)stepMeta.clone();
        System.arraycopy(StepPartitioningMeta.methodDescriptions, 0, this.options, 0, StepPartitioningMeta.methodDescriptions.length);
        System.arraycopy(StepPartitioningMeta.methodCodes, 0, this.codes, 0, StepPartitioningMeta.methodCodes.length);
    }

    public void fillOptionsAndCodesByPlugins(List<PluginInterface> plugins) {
        int pluginIndex = 0;
        for (PluginInterface plugin : plugins) {
            this.options[StepPartitioningMeta.methodDescriptions.length + pluginIndex] = plugin.getDescription();
            this.codes[StepPartitioningMeta.methodCodes.length + pluginIndex] = plugin.getIds()[0];
            ++pluginIndex;
        }
    }

    public int getDefaultSelectedMethodIndex() {
        for (int i = 0; i < this.codes.length; ++i) {
            if (!this.codes[i].equals(this.stepMeta.getStepPartitioningMeta().getMethod())) continue;
            return i;
        }
        return 0;
    }

    public int getDefaultSelectedSchemaIndex() {
        List<Object> schemaNames;
        try {
            schemaNames = this.schemasProvider.getPartitionSchemasNames(this.transMeta);
        }
        catch (KettleException e) {
            schemaNames = Collections.emptyList();
        }
        int defaultSelectedSchemaIndex = 0;
        if (this.stepMeta.getStepPartitioningMeta().getPartitionSchema() != null && !schemaNames.isEmpty()) {
            defaultSelectedSchemaIndex = Const.indexOfString((String)this.stepMeta.getStepPartitioningMeta().getPartitionSchema().getName(), schemaNames);
        }
        return defaultSelectedSchemaIndex != -1 ? defaultSelectedSchemaIndex : 0;
    }

    public String getMethodByMethodDescription(String methodDescription) {
        String method = StepPartitioningMeta.methodCodes[0];
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].equals(methodDescription)) continue;
            method = this.codes[i];
        }
        return method;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String[] getCodes() {
        return this.codes;
    }

    public List<String> getSchemaNames() {
        try {
            return this.schemasProvider.getPartitionSchemasNames(this.transMeta);
        }
        catch (KettleException e) {
            return Collections.emptyList();
        }
    }

    public String[] getSchemaNamesArray() {
        List<String> schemas = this.getSchemaNames();
        return schemas.toArray(new String[schemas.size()]);
    }

    public List<PartitionSchema> getSchemas() {
        try {
            return this.schemasProvider.getPartitionSchemas(this.transMeta);
        }
        catch (KettleException e) {
            return Collections.emptyList();
        }
    }

    public StepMeta getStepMeta() {
        return this.stepMeta;
    }

    public void updateMethodType(int methodType) {
        this.stepMeta.getStepPartitioningMeta().setMethodType(methodType);
    }

    public void updateMethod(String method) throws KettlePluginException {
        this.stepMeta.getStepPartitioningMeta().setMethod(method);
    }

    public void updateSchema(PartitionSchema schema) {
        if (schema != null && schema.getName() != null) {
            this.stepMeta.getStepPartitioningMeta().setPartitionSchema(schema);
        }
    }

    public void rollback(StepMeta before) throws KettlePluginException {
        this.updateMethod(before.getStepPartitioningMeta().getMethod());
        this.updateMethodType(before.getStepPartitioningMeta().getMethodType());
        this.updateSchema(before.getStepPartitioningMeta().getPartitionSchema());
    }

    public StepMeta getBefore() {
        return this.before;
    }

    public StepMeta getAfter() {
        return (StepMeta)this.stepMeta.clone();
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }
}

