/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.checksum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSumMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class CheckSumDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = CheckSumMeta.class;
    private CheckSumMeta input;
    private Label wlType;
    private CCombo wType;
    private FormData fdlType;
    private FormData fdType;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Label wlResult;
    private Text wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Label wlCompatibility;
    private Button wCompatibility;
    private FormData fdlCompatibility;
    private FormData fdCompatibility;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;
    private Label wlResultType;
    private CCombo wResultType;
    private FormData fdlResultType;
    private FormData fdResultType;

    public CheckSumDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (CheckSumMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CheckSumDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlType = new Label((Composite)this.shell, 131072);
        this.wlType.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlType);
        this.fdlType = new FormData();
        this.fdlType.left = new FormAttachment(0, 0);
        this.fdlType.right = new FormAttachment(middle, -margin);
        this.fdlType.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlType.setLayoutData((Object)this.fdlType);
        this.wType = new CCombo((Composite)this.shell, 2060);
        this.wType.add(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.CRC32", (String[])new String[0]));
        this.wType.add(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.ADLER32", (String[])new String[0]));
        this.wType.add(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.MD5", (String[])new String[0]));
        this.wType.add(BaseMessages.getString(PKG, (String)"CheckSumDialog.Type.SHA1", (String[])new String[0]));
        this.wType.select(0);
        this.props.setLook((Control)this.wType);
        this.fdType = new FormData();
        this.fdType.left = new FormAttachment(middle, 0);
        this.fdType.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdType.right = new FormAttachment(100, 0);
        this.wType.setLayoutData((Object)this.fdType);
        this.wType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckSumDialog.this.activeResultType();
            }
        });
        this.wlResultType = new Label((Composite)this.shell, 131072);
        this.wlResultType.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.ResultType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResultType);
        this.fdlResultType = new FormData();
        this.fdlResultType.left = new FormAttachment(0, 0);
        this.fdlResultType.right = new FormAttachment(middle, -margin);
        this.fdlResultType.top = new FormAttachment((Control)this.wType, 2 * margin);
        this.wlResultType.setLayoutData((Object)this.fdlResultType);
        this.wResultType = new CCombo((Composite)this.shell, 2060);
        this.wResultType.setItems(CheckSumMeta.resultTypeDesc);
        this.wResultType.select(0);
        this.props.setLook((Control)this.wResultType);
        this.fdResultType = new FormData();
        this.fdResultType.left = new FormAttachment(middle, 0);
        this.fdResultType.top = new FormAttachment((Control)this.wType, 2 * margin);
        this.fdResultType.right = new FormAttachment(100, 0);
        this.wResultType.setLayoutData((Object)this.fdResultType);
        this.wResultType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckSumDialog.this.input.setChanged();
                CheckSumDialog.this.activeHexa();
            }
        });
        this.wlResult = new Label((Composite)this.shell, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Result.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)this.wResultType, margin * 2);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)this.wResultType, margin * 2);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)this.fdResult);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        this.wlCompatibility = new Label((Composite)this.shell, 131072);
        this.wlCompatibility.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.CompatibilityMode.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCompatibility);
        this.fdlCompatibility = new FormData();
        this.fdlCompatibility.left = new FormAttachment(0, 0);
        this.fdlCompatibility.top = new FormAttachment((Control)this.wResult, margin);
        this.fdlCompatibility.right = new FormAttachment(middle, -margin);
        this.wlCompatibility.setLayoutData((Object)this.fdlCompatibility);
        this.wCompatibility = new Button((Composite)this.shell, 32);
        this.wCompatibility.setToolTipText(BaseMessages.getString(PKG, (String)"CheckSumDialog.CompatibilityMode.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompatibility);
        this.fdCompatibility = new FormData();
        this.fdCompatibility.left = new FormAttachment(middle, 0);
        this.fdCompatibility.top = new FormAttachment((Control)this.wResult, margin);
        this.fdCompatibility.right = new FormAttachment(100, 0);
        this.wCompatibility.setLayoutData((Object)this.fdCompatibility);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                CheckSumDialog.this.input.setChanged();
            }
        };
        this.wCompatibility.addSelectionListener((SelectionListener)lsSelR);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"CheckSumDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wCompatibility, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        boolean FieldsCols = true;
        int FieldsRows = this.input.getFieldName().length;
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"CheckSumDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = CheckSumDialog.this.transMeta.findStep(CheckSumDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = CheckSumDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            CheckSumDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        CheckSumDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        CheckSumDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CheckSumDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                CheckSumDialog.this.get();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CheckSumDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CheckSumDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CheckSumDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.activeHexa();
        this.activeResultType();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void activeResultType() {
        boolean active = this.wType.getSelectionIndex() == 2 || this.wType.getSelectionIndex() == 3;
        this.wlResultType.setEnabled(active);
        this.wResultType.setEnabled(active);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener insertListener = new TableItemInsertListener(){

                    @Override
                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, BaseMessages.getString((Class)PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, insertListener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wType.select(this.input.getTypeByDesc());
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        this.wResultType.setText(CheckSumMeta.getResultTypeDesc((int)this.input.getResultType()));
        this.wCompatibility.setSelection(this.input.isCompatibilityMode());
        Table table = this.wFields.table;
        if (this.input.getFieldName().length > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.input.getFieldName()[i]);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        if (this.wType.getSelectionIndex() < 0) {
            this.input.setCheckSumType(0);
        } else {
            this.input.setCheckSumType(this.wType.getSelectionIndex());
        }
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setResultType(CheckSumMeta.getResultTypeByDesc((String)this.wResultType.getText()));
        this.input.setCompatibilityMode(this.wCompatibility.getSelection());
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
        }
        this.dispose();
    }

    private void activeHexa() {
        boolean activate = CheckSumMeta.getResultTypeByDesc((String)this.wResultType.getText()) == 1;
        this.wlCompatibility.setEnabled(activate);
        this.wCompatibility.setEnabled(activate);
    }
}

