/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.olapinput;

import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.olapinput.OlapInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.olapinput.MDXValuesHighlight;
import org.pentaho.di.ui.trans.steps.olapinput.OlapInputAboutDialog;

public class OlapInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = OlapInputMeta.class;
    private Label wlUrl;
    private TextVar wUrl;
    private FormData fdlUrl;
    private FormData fdUrl;
    private Label wlCatalog;
    private TextVar wCatalog;
    private FormData fdlCatalog;
    private FormData fdCatalog;
    private Label wlUsername;
    private TextVar wUsername;
    private FormData fdlUsername;
    private FormData fdUsername;
    private Label wlPassword;
    private TextVar wPassword;
    private FormData fdlPassword;
    private FormData fdPassword;
    private Label wlMDX;
    private StyledTextComp wMDX;
    private FormData fdlMDX;
    private FormData fdMDX;
    private OlapInputMeta input;
    private MDXValuesHighlight lineStyler = new MDXValuesHighlight();
    private Label wlPosition;
    private FormData fdlPosition;
    private Label wlVariables;
    private Button wVariables;
    private FormData fdlVariables;
    private FormData fdVariables;
    private Button wAbout;
    private Link wAscLink;

    public OlapInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (OlapInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                OlapInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.OlapInput", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlUrl = new Label((Composite)this.shell, 131072);
        this.wlUrl.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Url", (String[])new String[0]));
        this.props.setLook((Control)this.wlUrl);
        this.fdlUrl = new FormData();
        this.fdlUrl.left = new FormAttachment(0, 0);
        this.fdlUrl.right = new FormAttachment(middle, -margin);
        this.fdlUrl.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlUrl.setLayoutData((Object)this.fdlUrl);
        this.wUrl = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wUrl);
        this.wUrl.addModifyListener(lsMod);
        this.fdUrl = new FormData();
        this.fdUrl.left = new FormAttachment(middle, 0);
        this.fdUrl.right = new FormAttachment(100, 0);
        this.fdUrl.top = new FormAttachment((Control)this.wStepname, margin);
        this.wUrl.setLayoutData(this.fdUrl);
        this.wlUsername = new Label((Composite)this.shell, 131072);
        this.wlUsername.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Username", (String[])new String[0]));
        this.props.setLook((Control)this.wlUsername);
        this.fdlUsername = new FormData();
        this.fdlUsername.left = new FormAttachment(0, 0);
        this.fdlUsername.right = new FormAttachment(middle, -margin);
        this.fdlUsername.top = new FormAttachment((Control)this.wUrl, margin);
        this.wlUsername.setLayoutData((Object)this.fdlUsername);
        this.wUsername = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wUsername);
        this.wUsername.addModifyListener(lsMod);
        this.fdUsername = new FormData();
        this.fdUsername.left = new FormAttachment(middle, 0);
        this.fdUsername.right = new FormAttachment(100, 0);
        this.fdUsername.top = new FormAttachment((Control)this.wUrl, margin);
        this.wUsername.setLayoutData(this.fdUsername);
        this.wlPassword = new Label((Composite)this.shell, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Password", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        this.fdlPassword = new FormData();
        this.fdlPassword.left = new FormAttachment(0, 0);
        this.fdlPassword.right = new FormAttachment(middle, -margin);
        this.fdlPassword.top = new FormAttachment((Control)this.wUsername, margin);
        this.wlPassword.setLayoutData((Object)this.fdlPassword);
        this.wPassword = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(lsMod);
        this.fdPassword = new FormData();
        this.fdPassword.left = new FormAttachment(middle, 0);
        this.fdPassword.right = new FormAttachment(100, 0);
        this.fdPassword.top = new FormAttachment((Control)this.wUsername, margin);
        this.wPassword.setLayoutData(this.fdPassword);
        this.wPassword.setEchoChar('*');
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wAbout = new Button((Composite)this.shell, 8);
        this.wAbout.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.About.Button", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wAbout, this.wCancel}, margin, null);
        this.wlCatalog = new Label((Composite)this.shell, 131072);
        this.wlCatalog.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Catalog", (String[])new String[0]));
        this.props.setLook((Control)this.wlCatalog);
        this.fdlCatalog = new FormData();
        this.fdlCatalog.left = new FormAttachment(0, 0);
        this.fdlCatalog.right = new FormAttachment(middle, -margin);
        this.fdlCatalog.bottom = new FormAttachment((Control)this.wOK, -8 * margin);
        this.wlCatalog.setLayoutData((Object)this.fdlCatalog);
        this.wCatalog = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCatalog);
        this.wCatalog.addModifyListener(lsMod);
        this.fdCatalog = new FormData();
        this.fdCatalog.left = new FormAttachment(middle, 0);
        this.fdCatalog.right = new FormAttachment(100, 0);
        this.fdCatalog.bottom = new FormAttachment((Control)this.wOK, -8 * margin);
        this.wCatalog.setLayoutData(this.fdCatalog);
        this.wlVariables = new Label((Composite)this.shell, 131072);
        this.wlVariables.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.ReplaceVariables", (String[])new String[0]));
        this.props.setLook((Control)this.wlVariables);
        this.fdlVariables = new FormData();
        this.fdlVariables.left = new FormAttachment(0, 0);
        this.fdlVariables.right = new FormAttachment(middle, -margin);
        this.fdlVariables.bottom = new FormAttachment((Control)this.wCatalog, -margin);
        this.wlVariables.setLayoutData((Object)this.fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wVariables);
        this.wVariables.setToolTipText(BaseMessages.getString(PKG, (String)"OlapInputDialog.ReplaceVariables.Tooltip", (String[])new String[0]));
        this.fdVariables = new FormData();
        this.fdVariables.left = new FormAttachment(middle, 0);
        this.fdVariables.right = new FormAttachment(100, 0);
        this.fdVariables.bottom = new FormAttachment((Control)this.wCatalog, -margin);
        this.wVariables.setLayoutData((Object)this.fdVariables);
        this.wVariables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                OlapInputDialog.this.setSQLToolTip();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.right = new FormAttachment(50, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wVariables, -2 * margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.wAscLink = new Link((Composite)this.shell, 0);
        FormData fdAscLink = new FormData();
        fdAscLink.left = new FormAttachment(0, 5);
        fdAscLink.right = new FormAttachment(100, 0);
        fdAscLink.bottom = new FormAttachment((Control)this.wlPosition, -2 * margin);
        this.wAscLink.setLayoutData((Object)fdAscLink);
        this.wAscLink.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Provided.Info", (String[])new String[0]));
        this.wlMDX = new Label((Composite)this.shell, 0);
        this.wlMDX.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.SQL", (String[])new String[0]));
        this.props.setLook((Control)this.wlMDX);
        this.fdlMDX = new FormData();
        this.fdlMDX.left = new FormAttachment(0, 0);
        this.fdlMDX.top = new FormAttachment((Control)this.wPassword, 2 * margin);
        this.wlMDX.setLayoutData((Object)this.fdlMDX);
        this.wMDX = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wMDX, 1);
        this.wMDX.addModifyListener(lsMod);
        this.fdMDX = new FormData();
        this.fdMDX.left = new FormAttachment(0, 0);
        this.fdMDX.top = new FormAttachment((Control)this.wlMDX, margin);
        this.fdMDX.right = new FormAttachment(100, -2 * margin);
        this.fdMDX.bottom = new FormAttachment((Control)this.wAscLink, -margin);
        this.wMDX.setLayoutData(this.fdMDX);
        Listener lsAbout = new Listener(){

            public void handleEvent(Event e) {
                new OlapInputAboutDialog(OlapInputDialog.this.shell).open();
            }
        };
        this.wAbout.addListener(13, lsAbout);
        this.wAscLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Program.launch((String)event.text);
            }
        });
        this.wMDX.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                OlapInputDialog.this.setSQLToolTip();
                OlapInputDialog.this.setPosition();
            }
        });
        this.wMDX.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                OlapInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                OlapInputDialog.this.setPosition();
            }
        });
        this.wMDX.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                OlapInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                OlapInputDialog.this.setPosition();
            }
        });
        this.wMDX.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                OlapInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                OlapInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                OlapInputDialog.this.setPosition();
            }
        });
        this.lineStyler = new MDXValuesHighlight();
        this.wMDX.addLineStyleListener(this.lineStyler);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                OlapInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                OlapInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                OlapInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                OlapInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wCatalog.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                OlapInputDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setPosition() {
        String scr = this.wMDX.getText();
        int linenr = this.wMDX.getLineAtOffset(this.wMDX.getCaretOffset()) + 1;
        int posnr = this.wMDX.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"OlapInputDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    protected void setSQLToolTip() {
        if (this.wVariables.getSelection()) {
            this.wMDX.setToolTipText(this.transMeta.environmentSubstitute(this.wMDX.getText()));
        }
    }

    public void getData() {
        this.wUrl.setText(Const.NVL((String)this.input.getOlap4jUrl(), (String)""));
        this.wUsername.setText(Const.NVL((String)this.input.getUsername(), (String)""));
        this.wPassword.setText(Const.NVL((String)this.input.getPassword(), (String)""));
        this.wMDX.setText(Const.NVL((String)this.input.getMdx(), (String)""));
        this.wCatalog.setText(Const.NVL((String)this.input.getCatalog(), (String)""));
        this.wVariables.setSelection(this.input.isVariableReplacementActive());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(OlapInputMeta meta) {
        meta.setOlap4jUrl(this.wUrl.getText());
        meta.setUsername(this.wUsername.getText());
        meta.setPassword(this.wPassword.getText());
        meta.setMdx(this.wMDX.getText());
        meta.setCatalog(this.wCatalog.getText());
        meta.setVariableReplacementActive(this.wVariables.getSelection());
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void preview() {
        OlapInputMeta oneMeta = new OlapInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"OlapInputDialog.EnterPreviewSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"OlapDialog.NumberOfRowsToPreview", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

