/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;

public class SwingGUIResource {
    private static LogChannelInterface log = new LogChannel((Object)"SwingGUIResource");
    private static SwingGUIResource instance;
    private Map<String, BufferedImage> stepImages = this.loadStepImages();
    private Map<String, BufferedImage> entryImages = this.loadEntryImages();

    private SwingGUIResource() throws KettleException {
    }

    public static SwingGUIResource getInstance() throws KettleException {
        if (instance == null) {
            instance = new SwingGUIResource();
        }
        return instance;
    }

    private Map<String, BufferedImage> loadStepImages() throws KettleException {
        HashMap<String, BufferedImage> map = new HashMap<String, BufferedImage>();
        for (PluginInterface plugin : PluginRegistry.getInstance().getPlugins(StepPluginType.class)) {
            try {
                BufferedImage image = this.getImageIcon(plugin);
                for (String id : plugin.getIds()) {
                    map.put(id, image);
                }
            }
            catch (Exception e) {
                log.logError("Unable to load step icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0], (Throwable)e);
                try {
                    this.getImageIcon(plugin);
                }
                catch (Exception ex) {}
            }
        }
        return map;
    }

    private Map<String, BufferedImage> loadEntryImages() throws KettleException {
        HashMap<String, BufferedImage> map = new HashMap<String, BufferedImage>();
        for (PluginInterface plugin : PluginRegistry.getInstance().getPlugins(JobEntryPluginType.class)) {
            try {
                if ("SPECIAL".equals(plugin.getIds()[0])) continue;
                String imageFile = plugin.getImageFile();
                if (imageFile == null) {
                    throw new KettleException("No image file (icon) specified for plugin: " + plugin);
                }
                BufferedImage image = this.getImageIcon(plugin);
                if (image == null) {
                    throw new KettleException("Unable to find image file: " + plugin.getImageFile() + " for plugin: " + plugin);
                }
                if (image.getHeight(null) < 0 && ((image = this.getImageIcon(plugin)) == null || image.getHeight(null) < 0)) {
                    throw new KettleException("Unable to load image file: " + plugin.getImageFile() + " for plugin: " + plugin);
                }
                map.put(plugin.getIds()[0], image);
            }
            catch (Exception e) {
                log.logError("Unable to load job entry icon image for plugin: " + plugin.getName() + " (id=" + plugin.getIds()[0], (Throwable)e);
            }
        }
        return map;
    }

    private BufferedImage getImageIcon(PluginInterface plugin) throws KettleException {
        try {
            PluginRegistry registry = PluginRegistry.getInstance();
            String filename = plugin.getImageFile();
            ClassLoader classLoader = registry.getClassLoader(plugin);
            InputStream inputStream = classLoader.getResourceAsStream(filename);
            if (inputStream == null) {
                inputStream = classLoader.getResourceAsStream("/" + classLoader);
            }
            if (inputStream == null) {
                inputStream = registry.getClass().getResourceAsStream(plugin.getImageFile());
            }
            if (inputStream == null) {
                inputStream = registry.getClass().getResourceAsStream("/" + plugin.getImageFile());
            }
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(plugin.getImageFile());
                }
                catch (FileNotFoundException e) {
                    // empty catch block
                }
            }
            if (inputStream == null) {
                throw new KettleException("Unable to find file: " + plugin.getImageFile() + " for plugin: " + plugin);
            }
            BufferedImage image = ImageIO.read(inputStream);
            inputStream.close();
            WaitingImageObserver wia = new WaitingImageObserver((Image)image);
            wia.waitImageLoaded();
            return image;
        }
        catch (Throwable e) {
            throw new KettleException("Unable to load image from file : '" + plugin.getImageFile() + "' for plugin: " + plugin, e);
        }
    }

    public Map<String, BufferedImage> getEntryImages() {
        return this.entryImages;
    }

    public Map<String, BufferedImage> getStepImages() {
        return this.stepImages;
    }
}

