/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.lifecycle;

import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.lifecycle.KettleLifecycleListener;
import org.pentaho.di.core.lifecycle.LifecycleException;
import org.pentaho.di.core.lifecycle.LifecycleSupport;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.KettleLifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.PluginTypeListener;
import org.pentaho.di.i18n.BaseMessages;

public class KettleLifecycleSupport {
    private static Class<?> PKG = Const.class;
    private Set<KettleLifecycleListener> kettleLifecycleListeners = LifecycleSupport.loadPlugins(KettleLifecyclePluginType.class, KettleLifecycleListener.class);

    public KettleLifecycleSupport() {
        final PluginRegistry registry = PluginRegistry.getInstance();
        registry.addPluginListener(KettleLifecyclePluginType.class, new PluginTypeListener(){

            public void pluginAdded(Object serviceObject) {
                KettleLifecycleListener listener = null;
                try {
                    listener = (KettleLifecycleListener)registry.loadClass((PluginInterface)serviceObject);
                }
                catch (KettlePluginException e) {
                    e.printStackTrace();
                    return;
                }
                KettleLifecycleSupport.this.kettleLifecycleListeners.add(listener);
                if (KettleEnvironment.isInitialized()) {
                    try {
                        listener.onEnvironmentInit();
                    }
                    catch (LifecycleException ex) {
                        String message = BaseMessages.getString((Class)PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener});
                        LogChannel.GENERAL.logError(message, (Throwable)ex);
                    }
                }
            }

            public void pluginRemoved(Object serviceObject) {
                KettleLifecycleSupport.this.kettleLifecycleListeners.remove(serviceObject);
            }

            public void pluginChanged(Object serviceObject) {
            }
        });
    }

    public void onEnvironmentInit() throws KettleException {
        for (KettleLifecycleListener listener : this.kettleLifecycleListeners) {
            try {
                listener.onEnvironmentInit();
            }
            catch (LifecycleException ex) {
                String message = BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener});
                if (ex.isSevere()) {
                    throw new KettleException(message, (Throwable)ex);
                }
                LogChannel.GENERAL.logError(message, (Throwable)ex);
            }
            catch (Throwable t) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener}), t);
            }
        }
    }

    public void onEnvironmentShutdown() {
        for (KettleLifecycleListener listener : this.kettleLifecycleListeners) {
            try {
                listener.onEnvironmentShutdown();
            }
            catch (Throwable t) {
                LogChannel.GENERAL.logError(BaseMessages.getString(PKG, (String)"LifecycleSupport.ErrorInvokingKettleLifecycleListener", (Object[])new Object[]{listener}), t);
            }
        }
    }
}

