/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.pentaho.di.core.BlockingRowSet;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowSet;
import org.pentaho.di.core.exception.KettleEOFException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.www.SocketRepository;
import org.w3c.dom.Node;

public class RemoteStep
implements Cloneable,
XMLInterface,
Comparable<RemoteStep> {
    public static final String XML_TAG = "remotestep";
    private static final long TIMEOUT_IN_SECONDS = 30L;
    private String targetSlaveServerName;
    private String hostname;
    private String remoteHostname;
    private String port;
    private ServerSocket serverSocket;
    private Socket socket;
    private DataOutputStream outputStream;
    public AtomicBoolean stopped = new AtomicBoolean(false);
    private BaseStep baseStep;
    private DataInputStream inputStream;
    private String sourceStep;
    private int sourceStepCopyNr;
    private String targetStep;
    private int targetStepCopyNr;
    private int bufferSize;
    private boolean compressingStreams;
    private GZIPOutputStream gzipOutputStream;
    private String sourceSlaveServerName;
    private GZIPInputStream gzipInputStream;
    private BufferedInputStream bufferedInputStream;
    protected BufferedOutputStream bufferedOutputStream;
    protected RowMetaInterface rowMeta;

    public RemoteStep(String hostname, String remoteHostname, String port, String sourceStep, int sourceStepCopyNr, String targetStep, int targetStepCopyNr, String sourceSlaveServerName, String targetSlaveServerName, int bufferSize, boolean compressingStreams, RowMetaInterface rowMeta) {
        this.hostname = hostname;
        this.remoteHostname = remoteHostname;
        this.port = port;
        this.sourceStep = sourceStep;
        this.sourceStepCopyNr = sourceStepCopyNr;
        this.targetStep = targetStep;
        this.targetStepCopyNr = targetStepCopyNr;
        this.bufferSize = bufferSize;
        this.compressingStreams = compressingStreams;
        this.sourceSlaveServerName = sourceSlaveServerName;
        this.targetSlaveServerName = targetSlaveServerName;
        this.rowMeta = rowMeta;
        if (sourceStep.equals(targetStep) && sourceStepCopyNr == targetStepCopyNr) {
            throw new RuntimeException("The source and target step/copy can't be the same for a remote step definition.");
        }
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer();
        xml.append(XMLHandler.openTag((String)XML_TAG));
        xml.append(XMLHandler.addTagValue((String)"hostname", (String)this.hostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"remote_hostname", (String)this.remoteHostname, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"port", (String)this.port, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"buffer_size", (int)this.bufferSize, (boolean)false));
        xml.append(XMLHandler.addTagValue((String)"compressed_streams", (boolean)this.compressingStreams, (boolean)false));
        xml.append(XMLHandler.addTagValue((String)"source_step_name", (String)this.sourceStep, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"source_step_copy", (int)this.sourceStepCopyNr, (boolean)false));
        xml.append(XMLHandler.addTagValue((String)"target_step_name", (String)this.targetStep, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"target_step_copy", (int)this.targetStepCopyNr, (boolean)false));
        xml.append(XMLHandler.addTagValue((String)"source_slave_server_name", (String)this.sourceSlaveServerName, (boolean)false, (String[])new String[0]));
        xml.append(XMLHandler.addTagValue((String)"target_slave_server_name", (String)this.targetSlaveServerName, (boolean)false, (String[])new String[0]));
        if (this.rowMeta != null) {
            try {
                xml.append(this.rowMeta.getMetaXML());
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected error encountered, probably encoding/decoding base64 data", e);
            }
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public RemoteStep(Node node) throws KettleException {
        this.hostname = XMLHandler.getTagValue((Node)node, (String)"hostname");
        this.remoteHostname = XMLHandler.getTagValue((Node)node, (String)"remote_hostname");
        this.port = XMLHandler.getTagValue((Node)node, (String)"port");
        this.bufferSize = Integer.parseInt(XMLHandler.getTagValue((Node)node, (String)"buffer_size"));
        this.compressingStreams = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)node, (String)"compressed_streams"));
        this.sourceStep = XMLHandler.getTagValue((Node)node, (String)"source_step_name");
        this.sourceStepCopyNr = Integer.parseInt(XMLHandler.getTagValue((Node)node, (String)"source_step_copy"));
        this.targetStep = XMLHandler.getTagValue((Node)node, (String)"target_step_name");
        this.targetStepCopyNr = Integer.parseInt(XMLHandler.getTagValue((Node)node, (String)"target_step_copy"));
        this.sourceSlaveServerName = XMLHandler.getTagValue((Node)node, (String)"source_slave_server_name");
        this.targetSlaveServerName = XMLHandler.getTagValue((Node)node, (String)"target_slave_server_name");
        Node rowMetaNode = XMLHandler.getSubNode((Node)node, (String)"row-meta");
        this.rowMeta = rowMetaNode == null ? new RowMeta() : new RowMeta(rowMetaNode);
    }

    public String toString() {
        return this.hostname + ":" + this.port + " (" + this.sourceSlaveServerName + "/" + this.sourceStep + "." + this.sourceStepCopyNr + " --> " + this.targetSlaveServerName + "/" + this.targetStep + "." + this.targetStepCopyNr + ")";
    }

    public boolean equals(Object obj) {
        return this.toString().equalsIgnoreCase(obj.toString());
    }

    @Override
    public int compareTo(RemoteStep remoteStep) {
        return this.toString().compareTo(remoteStep.toString());
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public synchronized void openServerSocket(BaseStep baseStep) throws IOException {
        this.baseStep = baseStep;
        int portNumber = Integer.parseInt(baseStep.environmentSubstitute(this.port));
        SocketRepository socketRepository = baseStep.getSocketRepository();
        this.serverSocket = socketRepository.openServerSocket(portNumber, baseStep.getTransMeta().getName() + " - " + baseStep.toString());
        baseStep.getServerSockets().add(this.serverSocket);
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    public synchronized BlockingRowSet openWriterSocket() throws IOException {
        final BlockingRowSet rowSet = new BlockingRowSet(this.baseStep.getTransMeta().getSizeRowset());
        rowSet.setThreadNameFromToCopy(this.sourceStep, this.sourceStepCopyNr, this.targetStep, this.targetStepCopyNr);
        rowSet.setRemoteSlaveServerName(this.targetSlaveServerName);
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RemoteStep.this.socket = RemoteStep.this.serverSocket.accept();
                    if (RemoteStep.this.compressingStreams) {
                        RemoteStep.this.gzipOutputStream = new GZIPOutputStream(RemoteStep.this.socket.getOutputStream(), 50000);
                        RemoteStep.this.bufferedOutputStream = new BufferedOutputStream(RemoteStep.this.gzipOutputStream, RemoteStep.this.bufferSize);
                    } else {
                        RemoteStep.this.bufferedOutputStream = new BufferedOutputStream(RemoteStep.this.socket.getOutputStream(), RemoteStep.this.bufferSize);
                    }
                    RemoteStep.this.outputStream = new DataOutputStream(RemoteStep.this.bufferedOutputStream);
                    RemoteStep.this.baseStep.logBasic("Server socket accepted for port [" + RemoteStep.this.port + "], reading from server " + RemoteStep.this.targetSlaveServerName);
                    Object[] rowData = RemoteStep.this.baseStep.getRowFrom((RowSet)rowSet);
                    if (rowData != null) {
                        rowSet.getRowMeta().writeMeta(RemoteStep.this.outputStream);
                    }
                    while (rowData != null && !RemoteStep.this.baseStep.isStopped()) {
                        RemoteStep.this.baseStep.decrementLinesRead();
                        RemoteStep.this.baseStep.decrementLinesWritten();
                        rowSet.getRowMeta().writeData(RemoteStep.this.outputStream, rowData);
                        RemoteStep.this.baseStep.incrementLinesOutput();
                        if (((RemoteStep)RemoteStep.this).baseStep.log.isDebug()) {
                            RemoteStep.this.baseStep.logDebug("Sent row to port " + RemoteStep.this.port + " : " + rowSet.getRowMeta().getString(rowData));
                        }
                        rowData = RemoteStep.this.baseStep.getRowFrom((RowSet)rowSet);
                    }
                    if (RemoteStep.this.compressingStreams) {
                        RemoteStep.this.outputStream.flush();
                        RemoteStep.this.gzipOutputStream.finish();
                    } else {
                        RemoteStep.this.outputStream.flush();
                    }
                }
                catch (Exception e) {
                    RemoteStep.this.baseStep.logError("Error writing to remote step", e);
                    RemoteStep.this.baseStep.setErrors(1L);
                    RemoteStep.this.baseStep.stopAll();
                }
                finally {
                    try {
                        if (RemoteStep.this.socket != null) {
                            RemoteStep.this.socket.shutdownOutput();
                        }
                    }
                    catch (Exception e) {
                        RemoteStep.this.baseStep.logError("Error shutting down output channel on the server socket of remote step", e);
                        RemoteStep.this.baseStep.setErrors(1L);
                        RemoteStep.this.baseStep.stopAll();
                    }
                    try {
                        if (RemoteStep.this.outputStream != null) {
                            RemoteStep.this.outputStream.flush();
                            RemoteStep.this.outputStream.close();
                            RemoteStep.this.bufferedOutputStream.close();
                            if (RemoteStep.this.gzipOutputStream != null) {
                                RemoteStep.this.gzipOutputStream.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        RemoteStep.this.baseStep.logError("Error shutting down output streams on the server socket of remote step", e);
                        RemoteStep.this.baseStep.setErrors(1L);
                        RemoteStep.this.baseStep.stopAll();
                    }
                    RemoteStep.this.outputStream = null;
                    RemoteStep.this.bufferedOutputStream = null;
                    RemoteStep.this.gzipOutputStream = null;
                }
            }
        };
        new Thread(runnable).start();
        return rowSet;
    }

    public void cleanup() {
        if (this.socket != null && this.socket.isConnected() && !this.socket.isClosed()) {
            try {
                if (this.socket != null && !this.socket.isOutputShutdown()) {
                    this.socket.shutdownOutput();
                }
                if (this.socket != null && !this.socket.isInputShutdown()) {
                    this.socket.shutdownInput();
                }
                if (this.socket != null && !this.socket.isClosed()) {
                    this.socket.close();
                }
                if (this.bufferedInputStream != null) {
                    this.bufferedInputStream.close();
                    this.bufferedInputStream = null;
                }
                if (this.gzipInputStream != null) {
                    this.gzipInputStream.close();
                    this.gzipInputStream = null;
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                if (this.gzipOutputStream != null) {
                    this.gzipOutputStream.close();
                    this.gzipOutputStream = null;
                }
                if (this.bufferedOutputStream != null) {
                    this.bufferedOutputStream.close();
                    this.bufferedOutputStream = null;
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
            }
            catch (Exception e) {
                this.baseStep.logError("Error closing socket", e);
            }
        }
    }

    private Object[] getRowOfData(RowMetaInterface rowMeta) throws KettleFileException {
        Object[] rowData = null;
        while (!this.baseStep.isStopped() && rowData == null) {
            try {
                rowData = rowMeta.readData(this.inputStream);
            }
            catch (SocketTimeoutException e) {
                rowData = null;
            }
        }
        return rowData;
    }

    public synchronized BlockingRowSet openReaderSocket(final BaseStep baseStep) throws IOException, KettleException {
        this.baseStep = baseStep;
        final BlockingRowSet rowSet = new BlockingRowSet(baseStep.getTransMeta().getSizeRowset());
        rowSet.setThreadNameFromToCopy(this.sourceStep, this.sourceStepCopyNr, this.targetStep, this.targetStepCopyNr);
        rowSet.setRemoteSlaveServerName(this.targetSlaveServerName);
        final int portNumber = Integer.parseInt(baseStep.environmentSubstitute(this.port));
        final String realHostname = baseStep.environmentSubstitute(this.hostname);
        long startTime = System.currentTimeMillis();
        boolean connected = false;
        KettleException lastException = null;
        while (!connected && 30L > (System.currentTimeMillis() - startTime) / 1000L && !baseStep.isStopped()) {
            try {
                this.socket = new Socket();
                this.socket.setReuseAddress(true);
                baseStep.logDetailed("Step variable MASTER_HOST : [" + baseStep.getVariable("MASTER_HOST") + "]");
                baseStep.logDetailed("Opening client (reader) socket to server [" + Const.NVL((String)realHostname, (String)"") + ":" + this.port + "]");
                this.socket.connect(new InetSocketAddress(realHostname, portNumber), 5000);
                connected = true;
                if (this.compressingStreams) {
                    this.gzipInputStream = new GZIPInputStream(this.socket.getInputStream());
                    this.bufferedInputStream = new BufferedInputStream(this.gzipInputStream, this.bufferSize);
                } else {
                    this.bufferedInputStream = new BufferedInputStream(this.socket.getInputStream(), this.bufferSize);
                }
                this.inputStream = new DataInputStream(this.bufferedInputStream);
                lastException = null;
            }
            catch (Exception e) {
                lastException = new KettleException("Unable to open socket to server " + realHostname + " port " + portNumber, (Throwable)e);
            }
            if (lastException == null) continue;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                if (this.socket != null) {
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.socket.close();
                    baseStep.logDetailed("Closed connection to server socket to read rows from remote step on server " + realHostname + " port " + portNumber + " - Local port=" + this.socket.getLocalPort());
                }
                throw new KettleException("Interrupted while trying to connect to server socket: " + e.toString());
            }
        }
        if (lastException != null) {
            baseStep.logError("Error initialising step: " + lastException.toString());
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
                baseStep.logDetailed("Closed connection to server socket to read rows from remote step on server " + realHostname + " port " + portNumber + " - Local port=" + this.socket.getLocalPort());
            }
            throw lastException;
        }
        if (this.inputStream == null) {
            throw new KettleException("Unable to connect to the SocketWriter in the 30s timeout period.");
        }
        baseStep.logDetailed("Opened connection to server socket to read rows from remote step on server " + realHostname + " port " + portNumber + " - Local port=" + this.socket.getLocalPort());
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    RowMeta rowMeta = null;
                    while (!baseStep.isStopped() && rowMeta == null) {
                        try {
                            rowMeta = new RowMeta(RemoteStep.this.inputStream);
                        }
                        catch (SocketTimeoutException e) {
                            rowMeta = null;
                        }
                    }
                    if (rowMeta == null) {
                        throw new KettleEOFException();
                    }
                    Object[] rowData = RemoteStep.this.getRowOfData(rowMeta);
                    while (rowData != null && !baseStep.isStopped()) {
                        baseStep.incrementLinesInput();
                        baseStep.decrementLinesRead();
                        if (baseStep.log.isDebug()) {
                            baseStep.logDebug("Received row from remote step: " + rowMeta.getString(rowData));
                        }
                        baseStep.putRowTo((RowMetaInterface)rowMeta, rowData, (RowSet)rowSet);
                        baseStep.decrementLinesWritten();
                        rowData = RemoteStep.this.getRowOfData((RowMetaInterface)rowMeta);
                    }
                }
                catch (KettleEOFException e) {
                    if (baseStep.log.isDebug()) {
                        baseStep.logDebug("Finished reading from remote step on server " + RemoteStep.this.hostname + " port " + portNumber);
                    }
                }
                catch (Exception e) {
                    baseStep.logError("Error reading from client socket to remote step", e);
                    baseStep.setErrors(1L);
                    baseStep.stopAll();
                }
                finally {
                    if (RemoteStep.this.socket != null && !RemoteStep.this.socket.isClosed() && !RemoteStep.this.socket.isInputShutdown()) {
                        try {
                            RemoteStep.this.socket.shutdownInput();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error shutting down input channel on client socket connection to remote step", e);
                        }
                    }
                    if (RemoteStep.this.socket != null && !RemoteStep.this.socket.isClosed() && !RemoteStep.this.socket.isOutputShutdown()) {
                        try {
                            RemoteStep.this.socket.shutdownOutput();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error shutting down output channel on client socket connection to remote step", e);
                        }
                    }
                    if (RemoteStep.this.socket != null && !RemoteStep.this.socket.isClosed()) {
                        try {
                            RemoteStep.this.socket.close();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error shutting down client socket connection to remote step", e);
                        }
                    }
                    if (RemoteStep.this.inputStream != null) {
                        try {
                            RemoteStep.this.inputStream.close();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error closing input stream on socket connection to remote step", e);
                        }
                        RemoteStep.this.inputStream = null;
                    }
                    if (RemoteStep.this.bufferedInputStream != null) {
                        try {
                            RemoteStep.this.bufferedInputStream.close();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error closing input stream on socket connection to remote step", e);
                        }
                    }
                    RemoteStep.this.bufferedInputStream = null;
                    if (RemoteStep.this.gzipInputStream != null) {
                        try {
                            RemoteStep.this.gzipInputStream.close();
                        }
                        catch (Exception e) {
                            baseStep.logError("Error closing input stream on socket connection to remote step", e);
                        }
                    }
                    RemoteStep.this.gzipInputStream = null;
                    baseStep.logDetailed("Closed connection to server socket to read rows from remote step on server " + realHostname + " port " + portNumber + " - Local port=" + RemoteStep.this.socket.getLocalPort());
                }
                rowSet.setDone();
            }
        };
        new Thread(runnable).start();
        return rowSet;
    }

    public String getSourceStep() {
        return this.sourceStep;
    }

    public void setSourceStep(String sourceStep) {
        this.sourceStep = sourceStep;
    }

    public String getTargetStep() {
        return this.targetStep;
    }

    public void setTargetStep(String targetStep) {
        this.targetStep = targetStep;
    }

    public String getTargetSlaveServerName() {
        return this.targetSlaveServerName;
    }

    public void setTargetSlaveServerName(String targetSlaveServerName) {
        this.targetSlaveServerName = targetSlaveServerName;
    }

    public int getSourceStepCopyNr() {
        return this.sourceStepCopyNr;
    }

    public void setSourceStepCopyNr(int sourceStepCopyNr) {
        this.sourceStepCopyNr = sourceStepCopyNr;
    }

    public int getTargetStepCopyNr() {
        return this.targetStepCopyNr;
    }

    public void setTargetStepCopyNr(int targetStepCopyNr) {
        this.targetStepCopyNr = targetStepCopyNr;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isCompressingStreams() {
        return this.compressingStreams;
    }

    public void setCompressingStreams(boolean compressingStreams) {
        this.compressingStreams = compressingStreams;
    }

    public String getRemoteHostname() {
        return this.remoteHostname;
    }

    public void setRemoteHostname(String remoteHostname) {
        this.remoteHostname = remoteHostname;
    }

    public String getSourceSlaveServerName() {
        return this.sourceSlaveServerName;
    }

    public void setSourceSlaveServerName(String sourceSlaveServerName) {
        this.sourceSlaveServerName = sourceSlaveServerName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.socket != null) {
                this.socket.shutdownInput();
                this.socket.shutdownOutput();
                this.socket.close();
            }
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            super.finalize();
        }
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }
}

