/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model.datatype;

import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import java.nio.ByteBuffer;

class IntegerType
extends AbstractColumnType {
    private int data;

    IntegerType() {
    }

    public String getDataAsString() {
        return Integer.toString(this.data);
    }

    public void getData(ByteBuffer byteBuffer) {
        byteBuffer.putInt(this.data);
    }

    public void setData(ByteBuffer byteBuffer) throws AbstractColumnType.InvalidDataException {
        this.data = byteBuffer.getInt();
    }

    public void setData(String string) {
        this.data = Integer.valueOf(string);
    }

    protected void zeroOutData() {
        this.data = 0;
    }

    public void setData(Object value, ValueConverter meta) throws ValueConverterException {
        if (value == null) {
            this.setIsNull(true);
        } else {
            Long val = meta.getInteger(value);
            if (val == null) {
                this.setIsNull(true);
            } else {
                this.setIsNull(false);
                if (val >= 0x80000000L || val < Integer.MIN_VALUE) {
                    throw new ValueConverterException("Value " + val + " out of range for INT");
                }
                this.data = val.intValue();
            }
        }
    }

    public final boolean isNeedsEnclosures() {
        return false;
    }
}

