/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.layout.AbstractRenderer;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageBreakPositionList;
import org.pentaho.reporting.engine.classic.core.layout.output.ContentProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.IterativeOutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.LayoutPagebreakHandler;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.process.ApplyAutoCommitPageHeaderStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CleanFlowBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.CountBoxesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FillFlowPagesStep;
import org.pentaho.reporting.engine.classic.core.layout.process.FlowPaginationStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.PaginationResult;
import org.pentaho.reporting.engine.classic.core.states.PerformanceMonitorContext;

public class FlowRenderer
extends AbstractRenderer {
    private static Log logger = LogFactory.getLog(FlowRenderer.class);
    private FlowPaginationStep paginationStep = new FlowPaginationStep();
    private FillFlowPagesStep fillPhysicalPagesStep = new FillFlowPagesStep();
    private CleanFlowBoxesStep cleanFlowBoxesStep = new CleanFlowBoxesStep();
    private ApplyAutoCommitPageHeaderStep applyAutoCommitPageHeaderStep = new ApplyAutoCommitPageHeaderStep();
    private int flowCount;
    private boolean pageStartPending;
    private int floodPrevention;
    private CountBoxesStep countBoxesStep = new CountBoxesStep();

    public FlowRenderer(OutputProcessor outputProcessor) {
        super(outputProcessor);
        this.initialize();
    }

    @Override
    protected boolean isPageFinished() {
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (pageBreak.isOverflow() || !pageBox.isOpen()) {
            this.setLastStateKey(pageBreak.getLastVisibleState());
            return true;
        }
        return false;
    }

    @Override
    public void startReport(ReportDefinition report, ProcessingContext processingContext, PerformanceMonitorContext performanceMonitorContext) {
        this.flowCount = 0;
        super.startReport(report, processingContext, performanceMonitorContext);
    }

    @Override
    protected void debugPrint(LogicalPageBox pageBox) {
    }

    @Override
    public void processIncrementalUpdate(boolean performOutput) throws ContentProcessingException {
        if (!this.isDirty()) {
            logger.debug((Object)"Not dirty, no update needed.");
            return;
        }
        this.clearDirty();
        ++this.floodPrevention;
        if (this.floodPrevention < 5) {
            return;
        }
        this.floodPrevention = 0;
        OutputProcessor outputProcessor = this.getOutputProcessor();
        if (!(outputProcessor instanceof IterativeOutputProcessor) || !outputProcessor.getMetaData().isFeatureSupported(OutputProcessorFeature.ITERATIVE_RENDERING)) {
            logger.debug((Object)"No incremental system.");
            return;
        }
        LogicalPageBox pageBox = this.getPageBox();
        pageBox.setPageEnd(pageBox.getHeight());
        if (pageBox.isOpen()) {
            IterativeOutputProcessor io = (IterativeOutputProcessor)outputProcessor;
            if (this.applyAutoCommitPageHeaderStep.compute(pageBox)) {
                io.processIterativeContent(pageBox, performOutput);
                this.countBoxesStep.process(pageBox);
                this.cleanFlowBoxesStep.compute(pageBox);
                logger.debug((Object)("Computing Incremental update: offset=" + pageBox.getPageOffset() + ", horizon=" + pageBox.getProcessedTableOffset() + ", pageEnd=" + pageBox.getPageEnd()));
            }
        }
    }

    @Override
    protected boolean performPagination(LayoutPagebreakHandler layoutPagebreakHandler, boolean performOutput) throws ContentProcessingException {
        boolean repeat;
        OutputProcessor outputProcessor = this.getOutputProcessor();
        LogicalPageBox pageBox = this.getPageBox();
        PaginationResult pageBreak = this.paginationStep.performPagebreak(pageBox);
        if (!pageBreak.isOverflow() && pageBox.isOpen()) {
            return false;
        }
        this.setLastStateKey(pageBreak.getLastVisibleState());
        this.setPagebreaks(this.getPagebreaks() + 1);
        pageBox.setAllVerticalBreaks(pageBreak.getAllBreaks());
        ++this.flowCount;
        this.debugPrint(pageBox);
        long nextOffset = pageBox.computePageEnd();
        pageBox.setPageEnd(nextOffset);
        long pageOffset = pageBox.getPageOffset();
        if (performOutput) {
            if (outputProcessor.isNeedAlignedPage()) {
                LogicalPageBox box = this.fillPhysicalPagesStep.compute(pageBox, pageOffset, nextOffset);
                logger.debug((Object)("Processing contents for Page " + this.flowCount + " Page-Offset: " + pageOffset + " -> " + nextOffset));
                outputProcessor.processContent(box);
            } else {
                logger.debug((Object)("Processing fast contents for Page " + this.flowCount + " Page-Offset: " + pageOffset + " -> " + nextOffset));
                outputProcessor.processContent(pageBox);
            }
        } else {
            logger.debug((Object)("Recomputing contents for Page " + this.flowCount + " Page-Offset: " + pageOffset + " -> " + nextOffset));
            outputProcessor.processRecomputedContent(pageBox);
        }
        boolean bl = repeat = pageBox.isOpen() || pageBreak.isOverflow();
        if (repeat) {
            this.countBoxesStep.process(pageBox);
            this.cleanFlowBoxesStep.compute(pageBox);
            pageBox.setPageOffset(nextOffset);
            pageBox.resetCacheState(true);
            if (pageBreak.isNextPageContainsContent()) {
                if (layoutPagebreakHandler != null) {
                    layoutPagebreakHandler.pageStarted();
                }
                return true;
            }
            this.pageStartPending = true;
            return false;
        }
        outputProcessor.processingFinished();
        pageBox.setPageOffset(nextOffset);
        return false;
    }

    @Override
    public int getPageCount() {
        return this.flowCount;
    }

    @Override
    public boolean isCurrentPageEmpty() {
        LogicalPageBox logicalPageBox = this.getPageBox();
        PageBreakPositionList breakPositionList = logicalPageBox.getAllVerticalBreaks();
        long masterBreak = breakPositionList.getLastMasterBreak();
        boolean nextPageContainsContent = logicalPageBox.getHeight() > masterBreak;
        return !nextPageContainsContent;
    }

    @Override
    public boolean clearPendingPageStart(LayoutPagebreakHandler layoutPagebreakHandler) {
        if (!this.pageStartPending) {
            return false;
        }
        if (layoutPagebreakHandler != null) {
            layoutPagebreakHandler.pageStarted();
        }
        this.pageStartPending = false;
        return true;
    }

    @Override
    public boolean isPageStartPending() {
        return this.pageStartPending;
    }

    @Override
    protected void initializeRendererOnStartReport(ProcessingContext processingContext) {
        super.initializeRendererOnStartReport(processingContext);
        this.paginationStep.initializePerformanceMonitoring(this.getPerformanceMonitorContext());
        this.fillPhysicalPagesStep.initializePerformanceMonitoring(this.getPerformanceMonitorContext());
    }

    @Override
    protected void close() {
        super.close();
        this.paginationStep.close();
        this.fillPhysicalPagesStep.close();
    }
}

