/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.plaintext;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.AbstractExportDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.JStatusBar;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.action.AbstractFileSelectionAction;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.EncodingSelector;
import org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.PlainTextExportGUIModule;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.PlainTextPageableModule;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.Epson24PinPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.Epson9PinPrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.driver.IBMCompatiblePrinterDriver;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecification;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.helper.PrinterSpecificationManager;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.DefaultConfiguration;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.fonts.encoding.EncodingRegistry;
import org.pentaho.reporting.libraries.xmlns.common.ParserUtil;

public class PlainTextExportDialog
extends AbstractExportDialog {
    private Messages messages;
    private static final String TXT_FILE_EXTENSION = ".txt";
    public static final int TYPE_PLAIN_OUTPUT = 0;
    public static final int TYPE_EPSON9_OUTPUT = 1;
    public static final int TYPE_IBM_OUTPUT = 2;
    public static final int TYPE_EPSON24_OUTPUT = 3;
    private static final String[] PRINTER_NAMES = new String[]{"plain-text-exportdialog.printer.plain", "plain-text-exportdialog.printer.epson9", "plain-text-exportdialog.printer.ibm", "plain-text-exportdialog.printer.epson24"};
    public static final Float LPI_6 = new Float(6.0f);
    public static final Float LPI_10 = new Float(10.0f);
    public static final Float CPI_10 = new Float(10.0f);
    public static final Float CPI_12 = new Float(12.0f);
    public static final Float CPI_15 = new Float(15.0f);
    public static final Float CPI_17 = new Float(17.14f);
    public static final Float CPI_20 = new Float(20.0f);
    private EncodingSelector encodingSelector;
    private JRadioButton rbPlainPrinterCommandSet;
    private JRadioButton rbEpson9PrinterCommandSet;
    private JRadioButton rbEpson24PrinterCommandSet;
    private JRadioButton rbIBMPrinterCommandSet;
    private JTextField txFilename;
    private JComboBox cbLinesPerInch;
    private JComboBox cbCharsPerInch;
    private JComboBox cbEpson9PrinterType;
    private JComboBox cbEpson24PrinterType;
    private KeyedComboBoxModel epson9Printers;
    private KeyedComboBoxModel epson24Printers;
    private JStatusBar statusBar;
    private static final String EXPORT_TYPE_CONFIG_KEY = "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.ExportType";

    public PlainTextExportDialog() {
        this.init();
    }

    public PlainTextExportDialog(Frame owner) {
        super(owner);
        this.init();
    }

    public PlainTextExportDialog(Dialog owner) {
        super(owner);
        this.init();
    }

    private void init() {
        this.setTitle(this.getResources().getString("plain-text-exportdialog.dialogtitle"));
        this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages", ObjectUtilities.getClassLoader(PlainTextExportGUIModule.class));
        this.epson9Printers = this.loadEpson9Printers();
        this.epson24Printers = this.loadEpson24Printers();
        this.cbEpson9PrinterType = new JComboBox(this.epson9Printers);
        this.cbEpson9PrinterType.addActionListener(new SelectEpsonModelAction());
        this.cbEpson24PrinterType = new JComboBox(this.epson24Printers);
        this.cbEpson24PrinterType.addActionListener(new SelectEpsonModelAction());
        this.statusBar = new JStatusBar();
        Float[] lpiModel = new Float[]{LPI_6, LPI_10};
        Float[] cpiModel = new Float[]{CPI_10, CPI_12, CPI_15, CPI_17, CPI_20};
        this.cbLinesPerInch = new JComboBox<Float>(new DefaultComboBoxModel<Float>(lpiModel));
        this.cbCharsPerInch = new JComboBox<Float>(new DefaultComboBoxModel<Float>(cpiModel));
        String plainPrinterName = this.getResources().getString(PRINTER_NAMES[0]);
        String epson9PrinterName = this.getResources().getString(PRINTER_NAMES[1]);
        String epson24PrinterName = this.getResources().getString(PRINTER_NAMES[3]);
        String ibmPrinterName = this.getResources().getString(PRINTER_NAMES[2]);
        this.rbPlainPrinterCommandSet = new JRadioButton(new ActionSelectPrinter(plainPrinterName, 0));
        this.rbEpson9PrinterCommandSet = new JRadioButton(new ActionSelectPrinter(epson9PrinterName, 1));
        this.rbEpson24PrinterCommandSet = new JRadioButton(new ActionSelectPrinter(epson24PrinterName, 3));
        this.rbIBMPrinterCommandSet = new JRadioButton(new ActionSelectPrinter(ibmPrinterName, 2));
        this.txFilename = new JTextField();
        this.encodingSelector = new EncodingSelector();
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rbPlainPrinterCommandSet);
        bg.add(this.rbIBMPrinterCommandSet);
        bg.add(this.rbEpson9PrinterCommandSet);
        bg.add(this.rbEpson24PrinterCommandSet);
        this.getFormValidator().registerTextField(this.txFilename);
        this.getFormValidator().registerButton(this.rbEpson24PrinterCommandSet);
        this.getFormValidator().registerButton(this.rbEpson9PrinterCommandSet);
        this.getFormValidator().registerButton(this.rbIBMPrinterCommandSet);
        this.getFormValidator().registerButton(this.rbPlainPrinterCommandSet);
        JComponent exportPane = this.createExportPane();
        Configuration config = ClassicEngineBoot.getInstance().getGlobalConfig();
        boolean advancedSettingsTabAvail = "true".equals(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.AdvancedSettingsAvailable"));
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add(this.getResources().getString("plain-text-exportdialog.export-settings"), exportPane);
        tabbedPane.add(this.getResources().getString("plain-text-exportdialog.parameters"), this.getParametersPanel());
        if (advancedSettingsTabAvail) {
            tabbedPane.add(this.getResources().getString("plain-text-exportdialog.advanced-settings"), this.createAdvancedPane());
        }
        this.setContentPane(this.createContentPane(tabbedPane));
        this.clear();
    }

    private KeyedComboBoxModel loadEpson24Printers() {
        KeyedComboBoxModel epsonPrinters = new KeyedComboBoxModel();
        PrinterSpecificationManager spec24Manager = Epson24PinPrinterDriver.loadSpecificationManager();
        Object[] printer24Names = spec24Manager.getPrinterNames();
        Arrays.sort(printer24Names);
        for (int i = 0; i < printer24Names.length; ++i) {
            PrinterSpecification pspec = spec24Manager.getPrinter((String)printer24Names[i]);
            epsonPrinters.add((Object)pspec, (Object)pspec.getDisplayName());
        }
        return epsonPrinters;
    }

    private KeyedComboBoxModel loadEpson9Printers() {
        KeyedComboBoxModel epsonPrinters = new KeyedComboBoxModel();
        PrinterSpecificationManager spec9Manager = Epson9PinPrinterDriver.loadSpecificationManager();
        Object[] printer9Names = spec9Manager.getPrinterNames();
        Arrays.sort(printer9Names);
        for (int i = 0; i < printer9Names.length; ++i) {
            PrinterSpecification pspec = spec9Manager.getPrinter((String)printer9Names[i]);
            epsonPrinters.add((Object)pspec, (Object)pspec.getDisplayName());
        }
        return epsonPrinters;
    }

    @Override
    public JStatusBar getStatusBar() {
        return this.statusBar;
    }

    private JComponent createExportPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblFileName = new JLabel(this.getResources().getString("plain-text-exportdialog.filename"));
        JButton btnSelect = new JButton(new ActionSelectFile(this.getResources()));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)lblFileName, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 120;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(3, 1, 1, 1);
        contentPane.add((Component)this.txFilename, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 3;
        gbc.gridy = 0;
        contentPane.add((Component)btnSelect, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    private JComponent createAdvancedPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        JLabel lblPrinterSelect = new JLabel(this.getResources().getString("plain-text-exportdialog.printer"));
        JLabel lblEncoding = new JLabel(this.getResources().getString("plain-text-exportdialog.encoding"));
        JLabel lblCharsPerInch = new JLabel(this.getResources().getString("plain-text-exportdialog.chars-per-inch"));
        JLabel lblLinesPerInch = new JLabel(this.getResources().getString("plain-text-exportdialog.lines-per-inch"));
        JLabel lblFontSettings = new JLabel(this.getResources().getString("plain-text-exportdialog.font-settings"));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblEncoding, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.encodingSelector, gbc);
        gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblPrinterSelect, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbPlainPrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbIBMPrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbEpson9PrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 3;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)this.cbEpson9PrinterType, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.rbEpson24PrinterCommandSet, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 3;
        gbc.gridy = 4;
        gbc.gridwidth = 1;
        gbc.insets = new Insets(1, 1, 1, 1);
        gbc.fill = 2;
        contentPane.add((Component)this.cbEpson24PrinterType, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblFontSettings, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblCharsPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbCharsPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)lblLinesPerInch, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 0.0;
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 1, 1, 1);
        contentPane.add((Component)this.cbLinesPerInch, gbc);
        JPanel advancedOptionsPane = new JPanel();
        advancedOptionsPane.setLayout(new BorderLayout());
        advancedOptionsPane.add((Component)contentPane, "North");
        return advancedOptionsPane;
    }

    protected void updateEpson9Encoding() {
        PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getSelectedKey();
        if (spec == null) {
            this.encodingSelector.setEncodings(PrinterSpecificationManager.getGenericPrinter(), this.getGuiContext().getLocale());
        } else {
            this.encodingSelector.setEncodings(spec, this.getGuiContext().getLocale());
        }
    }

    protected void updateEpson24Encoding() {
        PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getSelectedKey();
        if (spec == null) {
            this.encodingSelector.setEncodings(PrinterSpecificationManager.getGenericPrinter(), this.getGuiContext().getLocale());
        } else {
            this.encodingSelector.setEncodings(spec, this.getGuiContext().getLocale());
        }
    }

    public void setSelectedPrinter(int type) {
        Locale locale = this.getGuiContext().getLocale();
        String oldEncoding = this.getEncoding();
        if (type == 1) {
            this.rbEpson9PrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(true);
            this.cbEpson24PrinterType.setEnabled(false);
            this.updateEpson9Encoding();
        } else if (type == 3) {
            this.rbEpson24PrinterCommandSet.setSelected(true);
            this.cbEpson24PrinterType.setEnabled(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.updateEpson24Encoding();
        } else if (type == 2) {
            this.rbIBMPrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.cbEpson24PrinterType.setEnabled(false);
            this.encodingSelector.setEncodings(new IBMCompatiblePrinterDriver.GenericIBMPrinterSpecification(), locale);
        } else if (type == 0) {
            this.rbPlainPrinterCommandSet.setSelected(true);
            this.cbEpson9PrinterType.setEnabled(false);
            this.cbEpson24PrinterType.setEnabled(false);
            this.encodingSelector.setEncodings(new EncodingSelector.GenericPrinterSpecification(), locale);
        } else {
            throw new IllegalArgumentException();
        }
        if (oldEncoding != null) {
            this.setEncoding(oldEncoding);
        }
    }

    public int getSelectedPrinter() {
        if (this.rbPlainPrinterCommandSet.isSelected()) {
            return 0;
        }
        if (this.rbEpson9PrinterCommandSet.isSelected()) {
            return 1;
        }
        if (this.rbEpson24PrinterCommandSet.isSelected()) {
            return 3;
        }
        return 2;
    }

    public String getFilename() {
        return this.txFilename.getText();
    }

    public void setFilename(String filename) {
        this.txFilename.setText(filename);
    }

    @Override
    public void clear() {
        this.txFilename.setText("");
        this.setSelectedPrinter(0);
        this.cbEpson9PrinterType.setEnabled(false);
        this.cbEpson9PrinterType.setSelectedItem(Epson9PinPrinterDriver.getDefaultPrinter());
        this.cbEpson24PrinterType.setEnabled(false);
        this.cbEpson24PrinterType.setSelectedItem(Epson24PinPrinterDriver.getDefaultPrinter());
        this.cbCharsPerInch.setSelectedItem(CPI_10);
        this.cbLinesPerInch.setSelectedItem(LPI_6);
        this.setEncoding(EncodingRegistry.getPlatformDefaultEncoding());
    }

    public float getLinesPerInch() {
        Float i = (Float)this.cbLinesPerInch.getSelectedItem();
        if (i == null) {
            return LPI_6.floatValue();
        }
        return i.floatValue();
    }

    public void setLinesPerInch(float lpi) {
        Float lpiObj = new Float(lpi);
        ComboBoxModel model = this.cbLinesPerInch.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!lpiObj.equals(model.getElementAt(i))) continue;
            this.cbLinesPerInch.setSelectedIndex(i);
            return;
        }
        throw new IllegalArgumentException(this.messages.getErrorString("PlainTextExportDialog.ERROR_0001_NO_SUCH_LPI", new String[]{String.valueOf(lpi)}));
    }

    public float getCharsPerInch() {
        Float i = (Float)this.cbCharsPerInch.getSelectedItem();
        if (i == null) {
            return CPI_10.floatValue();
        }
        return i.floatValue();
    }

    public void setCharsPerInch(float cpi) {
        Float cpiObj = new Float(cpi);
        ComboBoxModel model = this.cbCharsPerInch.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!cpiObj.equals(model.getElementAt(i))) continue;
            this.cbCharsPerInch.setSelectedIndex(i);
            return;
        }
        throw new IllegalArgumentException(this.messages.getErrorString("PlainTextExportDialog.ERROR_0002_NO_SUCH_CPI", new String[]{String.valueOf(cpi)}));
    }

    public String getEncoding() {
        return this.encodingSelector.getSelectedEncoding();
    }

    public void setEncoding(String encoding) {
        if (encoding == null) {
            throw new NullPointerException(this.getResources().getString("PlainTextExportDialog.ERROR_0003_NULL_ENCODING"));
        }
        this.encodingSelector.setSelectedEncoding(encoding);
    }

    @Override
    protected void setDialogContents(Configuration config) {
        this.setEncoding(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.Encoding", PlainTextPageableModule.ENCODING_DEFAULT));
        this.setSelected9PinPrinterModel(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.9PinPrinterType", this.getSelected9PinPrinterModel()));
        this.setSelected24PinPrinterModel(config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.24PinPrinterType", this.getSelected24PinPrinterModel()));
        String mode = config.getConfigProperty(EXPORT_TYPE_CONFIG_KEY);
        if ("9pin".equals(mode)) {
            this.setSelectedPrinter(1);
        } else if ("24pin".equals(mode)) {
            this.setSelectedPrinter(3);
        } else if ("ibm".equals(mode)) {
            this.setSelectedPrinter(2);
        } else {
            this.setSelectedPrinter(0);
        }
        try {
            String lpi = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch");
            this.setLinesPerInch(ParserUtil.parseFloat((String)lpi, (float)6.0f));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            String cpi = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch");
            this.setCharsPerInch(ParserUtil.parseFloat((String)cpi, (float)10.0f));
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        String defaultFileName = config.getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.FileName");
        if (defaultFileName != null) {
            this.setFilename(this.resolvePath(defaultFileName).getAbsolutePath());
        }
    }

    @Override
    protected Configuration grabDialogContents(boolean full) {
        DefaultConfiguration config = new DefaultConfiguration();
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.Encoding", this.getEncoding());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.CharsPerInch", String.valueOf(this.getCharsPerInch()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.LinesPerInch", String.valueOf(this.getLinesPerInch()));
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.9PinPrinterType", this.getSelected9PinPrinterModel());
        config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.plaintext.epson.24PinPrinterType", this.getSelected24PinPrinterModel());
        if (full) {
            switch (this.getSelectedPrinter()) {
                case 3: {
                    config.setConfigProperty(EXPORT_TYPE_CONFIG_KEY, "24pin");
                    break;
                }
                case 1: {
                    config.setConfigProperty(EXPORT_TYPE_CONFIG_KEY, "9pin");
                    break;
                }
                case 2: {
                    config.setConfigProperty(EXPORT_TYPE_CONFIG_KEY, "ibm");
                    break;
                }
                case 0: {
                    config.setConfigProperty(EXPORT_TYPE_CONFIG_KEY, "plain");
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            config.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.FileName", this.getFilename());
        }
        return config;
    }

    @Override
    protected String getConfigurationSuffix() {
        return "_plaintextexport";
    }

    @Override
    protected String getResourceBaseName() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.messages.messages";
    }

    @Override
    public boolean performValidate() {
        this.getStatusBar().clear();
        String filename = this.getFilename();
        if (filename.trim().length() == 0) {
            this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("plain-text-exportdialog.targetIsEmpty"));
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            if (!f.isFile()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("plain-text-exportdialog.targetIsNoFile"));
                return false;
            }
            if (!f.canWrite()) {
                this.getStatusBar().setStatus(StatusType.ERROR, this.getResources().getString("plain-text-exportdialog.targetIsNotWritable"));
                return false;
            }
            String message = MessageFormat.format(this.getResources().getString("plain-text-exportdialog.targetOverwriteWarning"), filename);
            this.getStatusBar().setStatus(StatusType.WARNING, message);
        }
        return true;
    }

    @Override
    protected boolean performConfirm() {
        String filename = this.getFilename();
        File f = new File(filename);
        if (f.exists()) {
            String key1 = "plain-text-exportdialog.targetOverwriteConfirmation";
            String key2 = "plain-text-exportdialog.targetOverwriteTitle";
            if (JOptionPane.showConfirmDialog(this, MessageFormat.format(this.getResources().getString("plain-text-exportdialog.targetOverwriteConfirmation"), this.getFilename()), this.getResources().getString("plain-text-exportdialog.targetOverwriteTitle"), 0, 3) == 1) {
                return false;
            }
        }
        return true;
    }

    public String getSelected9PinPrinterModel() {
        return (String)this.cbEpson9PrinterType.getSelectedItem();
    }

    public String getSelected24PinPrinterModel() {
        return (String)this.cbEpson24PrinterType.getSelectedItem();
    }

    public void setSelected9PinPrinterModel(String selectedPrinterModel) {
        int size = this.epson9Printers.getSize();
        for (int i = 0; i < size; ++i) {
            PrinterSpecification spec = (PrinterSpecification)this.epson9Printers.getKeyAt(i);
            if (!spec.getDisplayName().equals(selectedPrinterModel)) continue;
            this.epson9Printers.setSelectedKey((Object)spec);
            return;
        }
        this.epson9Printers.setSelectedKey(null);
    }

    public void setSelected24PinPrinterModel(String selectedPrinterModel) {
        int size = this.epson24Printers.getSize();
        for (int i = 0; i < size; ++i) {
            PrinterSpecification spec = (PrinterSpecification)this.epson24Printers.getKeyAt(i);
            if (!spec.getDisplayName().equals(selectedPrinterModel)) continue;
            this.epson24Printers.setSelectedKey((Object)spec);
            return;
        }
        this.epson24Printers.setSelectedKey(null);
    }

    @Override
    protected String getConfigurationPrefix() {
        return "org.pentaho.reporting.engine.classic.core.modules.gui.plaintext.";
    }

    private class SelectEpsonModelAction
    extends AbstractAction {
        protected SelectEpsonModelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PlainTextExportDialog.this.getSelectedPrinter() == 1) {
                PlainTextExportDialog.this.updateEpson9Encoding();
            } else if (PlainTextExportDialog.this.getSelectedPrinter() == 3) {
                PlainTextExportDialog.this.updateEpson24Encoding();
            }
        }
    }

    private class ActionSelectPrinter
    extends AbstractAction {
        private int printer;

        protected ActionSelectPrinter(String printerName, int printer) {
            this.putValue("Name", printerName);
            this.printer = printer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlainTextExportDialog.this.setSelectedPrinter(this.printer);
        }
    }

    private class ActionSelectFile
    extends AbstractFileSelectionAction {
        private final ResourceBundle resources;

        protected ActionSelectFile(ResourceBundle resources) {
            super(PlainTextExportDialog.this);
            this.resources = resources;
            this.putValue("Name", resources.getString("plain-text-exportdialog.selectFile"));
        }

        @Override
        protected String getFileDescription() {
            return this.resources.getString("plain-text-exportdialog.fileDescription");
        }

        @Override
        protected String getFileExtension() {
            return PlainTextExportDialog.TXT_FILE_EXTENSION;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File selectedFile = this.performSelectFile(new File(PlainTextExportDialog.this.getFilename()), 1, true);
            if (selectedFile != null) {
                PlainTextExportDialog.this.setFilename(selectedFile.getPath());
            }
        }
    }
}

