/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.validator;

import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.function.PageFunction;
import org.pentaho.reporting.engine.classic.core.function.RowBandingFunction;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;
import org.pentaho.reporting.engine.classic.core.wizard.RelationalAutoGeneratorPreProcessor;

public class ReportStructureValidator
extends AbstractStructureVisitor {
    private boolean valid;
    private HashSet<String> preProcessorWhiteList = new HashSet();

    public ReportStructureValidator() {
        this.preProcessorWhiteList.add("org.pentaho.reporting.engine.classic.wizard.WizardProcessor");
        this.preProcessorWhiteList.add(RelationalAutoGeneratorPreProcessor.class.getName());
    }

    public boolean isValidForFastProcessing(MasterReport report) {
        this.valid = true;
        this.inspect(report);
        return this.valid;
    }

    @Override
    protected void traverseSection(Section section) {
        this.traverseSectionWithSubReports(section);
    }

    private boolean isInlineSubReport(SubReport reportDefinition) {
        Section parentSection = reportDefinition.getParentSection();
        if (!(parentSection instanceof RootLevelBand)) {
            return true;
        }
        RootLevelBand rlb = (RootLevelBand)((Object)parentSection);
        for (SubReport s : rlb.getSubReports()) {
            if (s != reportDefinition) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void inspectElement(ReportElement element) {
        this.traverseStyleExpressions(element);
        if (element.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "rich-text-type") != null) {
            this.valid = false;
            return;
        }
        if (element.getAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "rich-text-type") != null) {
            this.valid = false;
            return;
        }
        if (element instanceof AbstractReportDefinition) {
            SubReport sr;
            AbstractReportDefinition report = (AbstractReportDefinition)element;
            for (ReportPreProcessor reportPreProcessor : report.getPreProcessors()) {
                if (this.preProcessorWhiteList.contains(reportPreProcessor.getClass().getName())) continue;
                this.valid = false;
                return;
            }
            if (report instanceof SubReport && this.isInlineSubReport(sr = (SubReport)report)) {
                this.valid = false;
                return;
            }
        } else if (element instanceof CrosstabGroup) {
            this.valid = false;
        }
    }

    @Override
    protected void inspectExpression(AbstractReportDefinition report, Expression expression) {
        super.inspectExpression(report, expression);
        if (expression instanceof RowBandingFunction) {
            this.valid = false;
            return;
        }
        if (expression instanceof LayoutProcessorFunction) {
            this.valid = false;
        }
        if (expression instanceof PageEventListener && !(expression instanceof PageFunction)) {
            this.valid = false;
        }
    }
}

