/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers;

import org.pentaho.reporting.engine.classic.core.elementfactory.ResourceMessageElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.common.PropertyStringReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.simple.readhandlers.AbstractTextElementReadHandler;
import org.pentaho.reporting.libraries.xmlns.parser.RootXmlReadHandler;
import org.xml.sax.SAXException;

public class ResourceMessageReadHandler
extends AbstractTextElementReadHandler {
    private PropertyStringReadHandler stringReadHandler;
    private ResourceMessageElementFactory elementFactory = new ResourceMessageElementFactory();

    public ResourceMessageReadHandler() {
        this.stringReadHandler = new PropertyStringReadHandler();
    }

    @Override
    protected TextElementFactory getTextElementFactory() {
        return this.elementFactory;
    }

    public void init(RootXmlReadHandler rootHandler, String uri, String tagName) throws SAXException {
        super.init(rootHandler, uri, tagName);
        this.stringReadHandler.init(rootHandler, uri, tagName);
    }

    @Override
    protected void startParsing(PropertyAttributes atts) throws SAXException {
        super.startParsing(atts);
        this.elementFactory.setFormatKey(atts.getValue(this.getUri(), "resource-key"));
        this.elementFactory.setResourceBase(atts.getValue(this.getUri(), "resource-base"));
        this.elementFactory.setNullString(atts.getValue(this.getUri(), "nullstring"));
        this.stringReadHandler.startParsing(atts);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.stringReadHandler.characters(ch, start, length);
    }

    @Override
    protected void doneParsing() throws SAXException {
        this.stringReadHandler.doneParsing();
        String key = this.stringReadHandler.getResult();
        if (key.trim().length() > 0) {
            this.elementFactory.setFormatKey(key);
        }
        super.doneParsing();
    }
}

