/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.crosstab;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.states.crosstab.CrosstabKeyComparator;

public class DimensionNode
implements Comparable<DimensionNode> {
    private Object[] data;
    private HashSet<DimensionNode> previousNodes;
    private HashSet<DimensionNode> nextNodes;
    private int distanceFromRoot;
    private int rowCount;
    private boolean valid;

    public DimensionNode(Object[] data, int rowCount) {
        this.rowCount = rowCount;
        this.data = (Object[])data.clone();
        this.previousNodes = new HashSet();
        this.nextNodes = new HashSet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionNode that = (DimensionNode)o;
        return Arrays.equals(this.data, that.data);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean addParent(DimensionNode node) {
        node.checkLoop(this);
        if (this.previousNodes.add(node)) {
            node.nextNodes.add(this);
            this.invalidate();
            return true;
        }
        return false;
    }

    private void removeParent(DimensionNode previousNode) {
        this.previousNodes.remove(previousNode);
        previousNode.nextNodes.remove(this);
    }

    private void checkLoop(DimensionNode node) {
        if (node.equals(this)) {
            throw new InvalidReportStateException("Looping nodes. This data-model cannot be normalized.");
        }
        for (DimensionNode previousNode : this.previousNodes) {
            previousNode.checkLoop(node);
        }
    }

    private void invalidate() {
        if (!this.valid) {
            return;
        }
        this.valid = false;
        for (DimensionNode dimensionNode : this.nextNodes) {
            dimensionNode.invalidate();
        }
    }

    public void rebalance() {
        if (this.valid) {
            return;
        }
        if (this.previousNodes.isEmpty()) {
            this.distanceFromRoot = 0;
            this.valid = true;
            return;
        }
        int maxDepth = 0;
        for (DimensionNode previousNode : this.previousNodes) {
            int depth = previousNode.getDistanceFromRoot();
            if (depth <= maxDepth) continue;
            maxDepth = depth;
        }
        ArrayList<DimensionNode> nodesForRemoval = new ArrayList<DimensionNode>();
        for (DimensionNode previousNode : this.previousNodes) {
            int depth = previousNode.getDistanceFromRoot();
            if (depth >= maxDepth) continue;
            nodesForRemoval.add(previousNode);
        }
        for (int i = 0; i < nodesForRemoval.size(); ++i) {
            this.removeParent((DimensionNode)nodesForRemoval.get(i));
        }
        this.distanceFromRoot = maxDepth + 1;
        this.valid = true;
    }

    private int getDistanceFromRoot() {
        if (!this.valid) {
            this.rebalance();
        }
        return this.distanceFromRoot;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DimensionNode");
        sb.append("{data=").append(Arrays.asList(this.data).toString());
        sb.append(", nextNodes=").append(this.nextNodes);
        sb.append(", rowCount=").append(this.rowCount);
        sb.append('}');
        return sb.toString();
    }

    public String printFormatted() {
        return this.printFormatted(0);
    }

    private String printFormatted(int indent) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            b.append("    ");
        }
        b.append("[");
        b.append(Arrays.asList(this.data).toString());
        b.append("] distance=");
        b.append(this.getDistanceFromRoot());
        b.append(" sort-order=");
        b.append(this.rowCount);
        for (DimensionNode nextNode : this.nextNodes) {
            b.append("\n");
            b.append(nextNode.printFormatted(indent + 1));
        }
        return b.toString();
    }

    public Object[] getData() {
        return this.data;
    }

    @Override
    public int compareTo(DimensionNode o) {
        int otherDistance;
        int distance = this.getDistanceFromRoot();
        if (distance < (otherDistance = o.getDistanceFromRoot())) {
            return -1;
        }
        if (distance > otherDistance) {
            return 1;
        }
        int dataComparison = CrosstabKeyComparator.INSTANCE.compare(this.data, o.data);
        if (dataComparison != 0) {
            return dataComparison;
        }
        if (this.rowCount < o.rowCount) {
            return -1;
        }
        if (o.rowCount < this.rowCount) {
            return 1;
        }
        return 0;
    }
}

