/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;

public class ClusterShardHealth
implements Streamable {
    private int shardId;
    ClusterHealthStatus status = ClusterHealthStatus.RED;
    int activeShards = 0;
    int relocatingShards = 0;
    int initializingShards = 0;
    int unassignedShards = 0;
    boolean primaryActive = false;

    private ClusterShardHealth() {
    }

    ClusterShardHealth(int shardId) {
        this.shardId = shardId;
    }

    public int id() {
        return this.shardId;
    }

    public int getId() {
        return this.id();
    }

    public ClusterHealthStatus status() {
        return this.status;
    }

    public ClusterHealthStatus getStatus() {
        return this.status();
    }

    public int relocatingShards() {
        return this.relocatingShards;
    }

    public int getRelocatingShards() {
        return this.relocatingShards();
    }

    public int activeShards() {
        return this.activeShards;
    }

    public int getActiveShards() {
        return this.activeShards();
    }

    public boolean primaryActive() {
        return this.primaryActive;
    }

    public boolean isPrimaryActive() {
        return this.primaryActive();
    }

    public int initializingShards() {
        return this.initializingShards;
    }

    public int getInitializingShards() {
        return this.initializingShards();
    }

    public int unassignedShards() {
        return this.unassignedShards;
    }

    public int getUnassignedShards() {
        return this.unassignedShards();
    }

    static ClusterShardHealth readClusterShardHealth(StreamInput in) throws IOException {
        ClusterShardHealth ret = new ClusterShardHealth();
        ret.readFrom(in);
        return ret;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = in.readVInt();
        this.status = ClusterHealthStatus.fromValue(in.readByte());
        this.activeShards = in.readVInt();
        this.relocatingShards = in.readVInt();
        this.initializingShards = in.readVInt();
        this.unassignedShards = in.readVInt();
        this.primaryActive = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.shardId);
        out.writeByte(this.status.value());
        out.writeVInt(this.activeShards);
        out.writeVInt(this.relocatingShards);
        out.writeVInt(this.initializingShards);
        out.writeVInt(this.unassignedShards);
        out.writeBoolean(this.primaryActive);
    }
}

