/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.handler.codec.http;

import java.util.Queue;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.channel.Channel;
import org.elasticsearch.common.netty.channel.ChannelDownstreamHandler;
import org.elasticsearch.common.netty.channel.ChannelEvent;
import org.elasticsearch.common.netty.channel.ChannelHandlerContext;
import org.elasticsearch.common.netty.channel.ChannelUpstreamHandler;
import org.elasticsearch.common.netty.handler.codec.http.HttpMessage;
import org.elasticsearch.common.netty.handler.codec.http.HttpMessageDecoder;
import org.elasticsearch.common.netty.handler.codec.http.HttpMethod;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequest;
import org.elasticsearch.common.netty.handler.codec.http.HttpRequestEncoder;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponse;
import org.elasticsearch.common.netty.handler.codec.http.HttpResponseDecoder;
import org.elasticsearch.common.netty.util.internal.LinkedTransferQueue;

public class HttpClientCodec
implements ChannelUpstreamHandler,
ChannelDownstreamHandler {
    final Queue<HttpMethod> queue = new LinkedTransferQueue<HttpMethod>();
    volatile boolean done;
    private final HttpRequestEncoder encoder = new Encoder();
    private final HttpResponseDecoder decoder;

    public HttpClientCodec() {
        this(4096, 8192, 8192);
    }

    public HttpClientCodec(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
        this.decoder = new Decoder(maxInitialLineLength, maxHeaderSize, maxChunkSize);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.decoder.handleUpstream(ctx, e);
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        this.encoder.handleDownstream(ctx, e);
    }

    private final class Decoder
    extends HttpResponseDecoder {
        Decoder(int maxInitialLineLength, int maxHeaderSize, int maxChunkSize) {
            super(maxInitialLineLength, maxHeaderSize, maxChunkSize);
        }

        protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, HttpMessageDecoder.State state) throws Exception {
            if (HttpClientCodec.this.done) {
                return buffer.readBytes(this.actualReadableBytes());
            }
            return super.decode(ctx, channel, buffer, state);
        }

        protected boolean isContentAlwaysEmpty(HttpMessage msg) {
            int statusCode = ((HttpResponse)msg).getStatus().getCode();
            if (statusCode == 100) {
                return true;
            }
            HttpMethod method = HttpClientCodec.this.queue.poll();
            char firstChar = method.getName().charAt(0);
            switch (firstChar) {
                case 'H': {
                    if (!HttpMethod.HEAD.equals(method)) break;
                    return !msg.isChunked();
                }
                case 'C': {
                    if (statusCode != 200 || !HttpMethod.CONNECT.equals(method)) break;
                    HttpClientCodec.this.done = true;
                    HttpClientCodec.this.queue.clear();
                    return true;
                }
            }
            return super.isContentAlwaysEmpty(msg);
        }
    }

    private final class Encoder
    extends HttpRequestEncoder {
        Encoder() {
        }

        protected Object encode(ChannelHandlerContext ctx, Channel channel, Object msg) throws Exception {
            if (msg instanceof HttpRequest && !HttpClientCodec.this.done) {
                HttpClientCodec.this.queue.offer(((HttpRequest)msg).getMethod());
            }
            return super.encode(ctx, channel, msg);
        }
    }
}

