/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.filter.support;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.OpenBitSet;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.lab.LongsLAB;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.docset.OpenBitDocSet;
import org.elasticsearch.common.lucene.docset.SlicedOpenBitSet;

public class FilterCacheValue<T> {
    private final T value;
    private final LongsLAB longsLAB;

    public FilterCacheValue(T value, LongsLAB longsLAB) {
        this.value = value;
        this.longsLAB = longsLAB;
    }

    public T value() {
        return this.value;
    }

    public LongsLAB longsLAB() {
        return this.longsLAB;
    }

    public static DocSet cacheable(IndexReader reader, @Nullable LongsLAB longsLAB, DocIdSet set) throws IOException {
        if (set == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (set == DocIdSet.EMPTY_DOCIDSET) {
            return DocSet.EMPTY_DOC_SET;
        }
        DocIdSetIterator it = set.iterator();
        if (it == null) {
            return DocSet.EMPTY_DOC_SET;
        }
        int doc = it.nextDoc();
        if (doc == Integer.MAX_VALUE) {
            return DocSet.EMPTY_DOC_SET;
        }
        if (longsLAB == null) {
            return DocSets.cacheable(reader, set);
        }
        int numOfWords = OpenBitSet.bits2words((long)reader.maxDoc());
        LongsLAB.Allocation allocation = longsLAB.allocateLongs(numOfWords);
        if (allocation == null) {
            return DocSets.cacheable(reader, set);
        }
        if (set instanceof OpenBitSet) {
            return new SlicedOpenBitSet(allocation.getData(), allocation.getOffset(), (OpenBitSet)set);
        }
        if (set instanceof OpenBitDocSet) {
            return new SlicedOpenBitSet(allocation.getData(), allocation.getOffset(), ((OpenBitDocSet)set).set());
        }
        SlicedOpenBitSet slicedSet = new SlicedOpenBitSet(allocation.getData(), numOfWords, allocation.getOffset());
        slicedSet.fastSet(doc);
        while ((doc = it.nextDoc()) != Integer.MAX_VALUE) {
            slicedSet.fastSet(doc);
        }
        return slicedSet;
    }
}

