/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.xcontent;

import java.io.Reader;
import org.apache.lucene.analysis.NumericTokenStream;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.xcontent.AbstractFieldMapper;
import org.elasticsearch.index.mapper.xcontent.IncludeInAllMapper;
import org.elasticsearch.index.mapper.xcontent.MergeContext;
import org.elasticsearch.index.mapper.xcontent.XContentMapper;
import org.elasticsearch.index.query.xcontent.QueryParseContext;

public abstract class NumberFieldMapper<T extends Number>
extends AbstractFieldMapper<T>
implements IncludeInAllMapper {
    protected int precisionStep;
    protected String fuzzyFactor;
    protected double dFuzzyFactor;
    protected Boolean includeInAll;
    private ThreadLocal<NumericTokenStream> tokenStream = new ThreadLocal<NumericTokenStream>(){

        @Override
        protected NumericTokenStream initialValue() {
            return new NumericTokenStream(NumberFieldMapper.this.precisionStep);
        }
    };

    protected NumberFieldMapper(FieldMapper.Names names, int precisionStep, @Nullable String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer) {
        super(names, index, store, Field.TermVector.NO, boost, omitNorms, omitTermFreqAndPositions, indexAnalyzer, searchAnalyzer);
        this.precisionStep = precisionStep <= 0 || precisionStep >= this.maxPrecisionStep() ? Integer.MAX_VALUE : precisionStep;
        this.fuzzyFactor = fuzzyFactor;
        this.dFuzzyFactor = this.parseFuzzyFactor(fuzzyFactor);
    }

    protected double parseFuzzyFactor(String fuzzyFactor) {
        if (fuzzyFactor == null) {
            return 1.0;
        }
        return Double.parseDouble(fuzzyFactor);
    }

    @Override
    public void includeInAll(Boolean includeInAll) {
        if (includeInAll != null) {
            this.includeInAll = includeInAll;
        }
    }

    @Override
    public void includeInAllIfNotSet(Boolean includeInAll) {
        if (includeInAll != null && this.includeInAll == null) {
            this.includeInAll = includeInAll;
        }
    }

    protected abstract int maxPrecisionStep();

    public int precisionStep() {
        return this.precisionStep;
    }

    @Override
    public boolean useFieldQueryWithQueryString() {
        return true;
    }

    @Override
    public Query fieldQuery(String value, QueryParseContext context) {
        return this.rangeQuery(value, value, true, true);
    }

    @Override
    public abstract Query fuzzyQuery(String var1, String var2, int var3, int var4);

    @Override
    public abstract Query fuzzyQuery(String var1, double var2, int var4, int var5);

    @Override
    public Filter fieldFilter(String value) {
        return this.rangeFilter(value, value, true, true);
    }

    @Override
    public abstract Query rangeQuery(String var1, String var2, boolean var3, boolean var4);

    @Override
    public abstract Filter rangeFilter(String var1, String var2, boolean var3, boolean var4);

    public abstract Filter rangeFilter(FieldDataCache var1, String var2, String var3, boolean var4, boolean var5);

    @Override
    public Object valueForSearch(Fieldable field) {
        return this.value(field);
    }

    @Override
    public String valueAsString(Fieldable field) {
        Number num = (Number)this.value(field);
        return num == null ? null : num.toString();
    }

    @Override
    public void merge(XContentMapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.precisionStep = ((NumberFieldMapper)mergeWith).precisionStep;
            this.includeInAll = ((NumberFieldMapper)mergeWith).includeInAll;
            this.fuzzyFactor = ((NumberFieldMapper)mergeWith).fuzzyFactor;
            this.dFuzzyFactor = this.parseFuzzyFactor(this.fuzzyFactor);
        }
    }

    @Override
    public void close() {
        this.tokenStream.remove();
    }

    @Override
    public abstract FieldDataType fieldDataType();

    protected NumericTokenStream popCachedStream() {
        return this.tokenStream.get();
    }

    public static abstract class CustomNumericField
    extends AbstractField {
        protected final NumberFieldMapper mapper;

        public CustomNumericField(NumberFieldMapper mapper, byte[] value) {
            this.mapper = mapper;
            this.name = mapper.names().indexName();
            this.fieldsData = value;
            this.isIndexed = mapper.indexed();
            this.isTokenized = mapper.indexed();
            this.omitTermFreqAndPositions = true;
            this.omitNorms = mapper.omitNorms();
            if (value != null) {
                this.isStored = true;
                this.isBinary = true;
                this.binaryLength = value.length;
                this.binaryOffset = 0;
            }
            this.setStoreTermVector(Field.TermVector.NO);
        }

        public String stringValue() {
            return null;
        }

        public Reader readerValue() {
            return null;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends NumberFieldMapper>
    extends AbstractFieldMapper.Builder<T, Y> {
        protected int precisionStep = 4;
        protected String fuzzyFactor = Defaults.FUZZY_FACTOR;

        public Builder(String name) {
            super(name);
            this.index = Defaults.INDEX;
            this.omitNorms = true;
            this.omitTermFreqAndPositions = true;
        }

        @Override
        public T store(Field.Store store) {
            return (T)((Builder)super.store(store));
        }

        @Override
        public T boost(float boost) {
            return (T)((Builder)super.boost(boost));
        }

        @Override
        public T indexName(String indexName) {
            return (T)((Builder)super.indexName(indexName));
        }

        @Override
        public T includeInAll(Boolean includeInAll) {
            return (T)((Builder)super.includeInAll(includeInAll));
        }

        public T precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return (T)((Builder)this.builder);
        }

        public T fuzzyFactor(String fuzzyFactor) {
            this.fuzzyFactor = fuzzyFactor;
            return (T)((Builder)this.builder);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final int PRECISION_STEP = 4;
        public static final Field.Index INDEX = Field.Index.NOT_ANALYZED;
        public static final boolean OMIT_NORMS = true;
        public static final boolean OMIT_TERM_FREQ_AND_POSITIONS = true;
        public static final String FUZZY_FACTOR = null;
    }
}

