/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.network.NetworkInfo;
import org.elasticsearch.monitor.network.NetworkProbe;
import org.elasticsearch.monitor.network.NetworkStats;

public class NetworkService
extends AbstractComponent {
    private final NetworkProbe probe;
    private final NetworkInfo info;
    private final TimeValue refreshInterval;
    private NetworkStats cachedStats;

    @Inject
    public NetworkService(Settings settings, NetworkProbe probe) {
        super(settings);
        this.probe = probe;
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", TimeValue.timeValueSeconds(5L));
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, this.refreshInterval);
        this.info = probe.networkInfo();
        this.info.refreshInterval = this.refreshInterval.millis();
        this.cachedStats = probe.networkStats();
        if (this.logger.isDebugEnabled()) {
            StringBuilder netDebug = new StringBuilder("net_info");
            try {
                Enumeration<NetworkInterface> enum_ = NetworkInterface.getNetworkInterfaces();
                String hostName = InetAddress.getLocalHost().getHostName();
                netDebug.append("\nhost [").append(hostName).append("]\n");
                while (enum_.hasMoreElements()) {
                    NetworkInterface net = enum_.nextElement();
                    netDebug.append(net.getName()).append('\t').append("display_name [").append(net.getDisplayName()).append("]\n");
                    Enumeration<InetAddress> addresses = net.getInetAddresses();
                    netDebug.append("\t\taddress ");
                    while (addresses.hasMoreElements()) {
                        netDebug.append("[").append(addresses.nextElement()).append("] ");
                    }
                    netDebug.append('\n');
                    netDebug.append("\t\tmtu [").append(net.getMTU()).append("] multicast [").append(net.supportsMulticast()).append("] ptp [").append(net.isPointToPoint()).append("] loopback [").append(net.isLoopback()).append("] up [").append(net.isUp()).append("] virtual [").append(net.isVirtual()).append("]").append('\n');
                }
            }
            catch (Exception ex) {
                netDebug.append("Failed to get Network Interface Info [" + ex.getMessage() + "]");
            }
            this.logger.debug(netDebug.toString(), new Object[0]);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("ifconfig\n\n" + this.ifconfig(), new Object[0]);
        }
    }

    public NetworkInfo info() {
        return this.info;
    }

    public synchronized NetworkStats stats() {
        if (System.currentTimeMillis() - this.cachedStats.timestamp() > this.refreshInterval.millis()) {
            this.cachedStats = this.probe.networkStats();
        }
        return this.cachedStats;
    }

    public String ifconfig() {
        return this.probe.ifconfig();
    }
}

