/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.os;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.os.OsInfo;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;
import org.elasticsearch.monitor.sigar.SigarService;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;

public class SigarOsProbe
extends AbstractComponent
implements OsProbe {
    private final SigarService sigarService;

    @Inject
    public SigarOsProbe(Settings settings, SigarService sigarService) {
        super(settings);
        this.sigarService = sigarService;
    }

    @Override
    public OsInfo osInfo() {
        Sigar sigar = this.sigarService.sigar();
        OsInfo info = new OsInfo();
        try {
            CpuInfo[] infos = sigar.getCpuInfoList();
            info.cpu = new OsInfo.Cpu();
            info.cpu.vendor = infos[0].getVendor();
            info.cpu.model = infos[0].getModel();
            info.cpu.mhz = infos[0].getMhz();
            info.cpu.totalCores = infos[0].getTotalCores();
            info.cpu.totalSockets = infos[0].getTotalSockets();
            info.cpu.coresPerSocket = infos[0].getCoresPerSocket();
            if (infos[0].getCacheSize() != -1L) {
                info.cpu.cacheSize = infos[0].getCacheSize();
            }
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            Mem mem = sigar.getMem();
            info.mem = new OsInfo.Mem();
            info.mem.total = mem.getTotal();
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            Swap swap = sigar.getSwap();
            info.swap = new OsInfo.Swap();
            info.swap.total = swap.getTotal();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return info;
    }

    @Override
    public OsStats osStats() {
        Sigar sigar = this.sigarService.sigar();
        OsStats stats = new OsStats();
        stats.timestamp = System.currentTimeMillis();
        try {
            stats.loadAverage = sigar.getLoadAverage();
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            stats.uptime = (long)sigar.getUptime().getUptime();
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            CpuPerc cpuPerc = sigar.getCpuPerc();
            stats.cpu = new OsStats.Cpu();
            stats.cpu.sys = (short)(cpuPerc.getSys() * 100.0);
            stats.cpu.user = (short)(cpuPerc.getUser() * 100.0);
            stats.cpu.idle = (short)(cpuPerc.getIdle() * 100.0);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            Mem mem = sigar.getMem();
            stats.mem = new OsStats.Mem();
            stats.mem.free = mem.getFree();
            stats.mem.freePercent = (short)mem.getFreePercent();
            stats.mem.used = mem.getUsed();
            stats.mem.usedPercent = (short)mem.getUsedPercent();
            stats.mem.actualFree = mem.getActualFree();
            stats.mem.actualUsed = mem.getActualUsed();
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            Swap swap = sigar.getSwap();
            stats.swap = new OsStats.Swap();
            stats.swap.free = swap.getFree();
            stats.swap.used = swap.getUsed();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return stats;
    }
}

