/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.search.Scroll;

public class InternalScrollSearchRequest
implements Streamable {
    private long id;
    private Scroll scroll;

    public InternalScrollSearchRequest() {
    }

    public InternalScrollSearchRequest(long id) {
        this.id = id;
    }

    public long id() {
        return this.id;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalScrollSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.id = in.readLong();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.id);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
    }
}

