/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Bytes;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.search.Scroll;

public class InternalSearchRequest
implements Streamable {
    private String index;
    private int shardId;
    private int numberOfShards;
    private SearchType searchType;
    private Scroll scroll;
    private TimeValue timeout;
    private String[] types = Strings.EMPTY_ARRAY;
    private byte[] source;
    private int sourceOffset;
    private int sourceLength;
    private byte[] extraSource;
    private int extraSourceOffset;
    private int extraSourceLength;

    public InternalSearchRequest() {
    }

    public InternalSearchRequest(ShardRouting shardRouting, int numberOfShards, SearchType searchType) {
        this(shardRouting.index(), shardRouting.id(), numberOfShards, searchType);
    }

    public InternalSearchRequest(String index, int shardId, int numberOfShards, SearchType searchType) {
        this.index = index;
        this.shardId = shardId;
        this.numberOfShards = numberOfShards;
        this.searchType = searchType;
    }

    public String index() {
        return this.index;
    }

    public int shardId() {
        return this.shardId;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    public int numberOfShards() {
        return this.numberOfShards;
    }

    public byte[] source() {
        return this.source;
    }

    public int sourceOffset() {
        return this.sourceOffset;
    }

    public int sourceLength() {
        return this.sourceLength;
    }

    public byte[] extraSource() {
        return this.extraSource;
    }

    public int extraSourceOffset() {
        return this.extraSourceOffset;
    }

    public int extraSourceLength() {
        return this.extraSourceLength;
    }

    public InternalSearchRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public InternalSearchRequest source(byte[] source, int offset, int length) {
        this.source = source;
        this.sourceOffset = offset;
        this.sourceLength = length;
        return this;
    }

    public InternalSearchRequest extraSource(byte[] extraSource, int offset, int length) {
        this.extraSource = extraSource;
        this.extraSourceOffset = offset;
        this.extraSourceLength = length;
        return this;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public InternalSearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public InternalSearchRequest timeout(TimeValue timeout) {
        this.timeout = timeout;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public void types(String[] types) {
        this.types = types;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.index = in.readUTF();
        this.shardId = in.readVInt();
        this.searchType = SearchType.fromId(in.readByte());
        this.numberOfShards = in.readVInt();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        if (in.readBoolean()) {
            this.timeout = TimeValue.readTimeValue(in);
        }
        this.sourceOffset = 0;
        this.sourceLength = in.readVInt();
        if (this.sourceLength == 0) {
            this.source = Bytes.EMPTY_ARRAY;
        } else {
            this.source = new byte[this.sourceLength];
            in.readFully(this.source);
        }
        this.extraSourceOffset = 0;
        this.extraSourceLength = in.readVInt();
        if (this.extraSourceLength == 0) {
            this.extraSource = Bytes.EMPTY_ARRAY;
        } else {
            this.extraSource = new byte[this.extraSourceLength];
            in.readFully(this.extraSource);
        }
        int typesSize = in.readVInt();
        if (typesSize > 0) {
            this.types = new String[typesSize];
            for (int i = 0; i < typesSize; ++i) {
                this.types[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeUTF(this.index);
        out.writeVInt(this.shardId);
        out.writeByte(this.searchType.id());
        out.writeVInt(this.numberOfShards);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        if (this.timeout == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.timeout.writeTo(out);
        }
        if (this.source == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.sourceLength);
            out.writeBytes(this.source, this.sourceOffset, this.sourceLength);
        }
        if (this.extraSource == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.extraSourceLength);
            out.writeBytes(this.extraSource, this.extraSourceOffset, this.extraSourceLength);
        }
        out.writeVInt(this.types.length);
        for (String type : this.types) {
            out.writeUTF(type);
        }
    }
}

