/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurenative;

import com.microsoft.windowsazure.storage.core.Utility;
import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.BufferedFSInputStream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azure.AzureException;
import org.apache.hadoop.fs.azurenative.AzureFileSystemInstrumentation;
import org.apache.hadoop.fs.azurenative.AzureFileSystemMetricsSystem;
import org.apache.hadoop.fs.azurenative.AzureNativeFileSystemStore;
import org.apache.hadoop.fs.azurenative.BlobMaterialization;
import org.apache.hadoop.fs.azurenative.FileMetadata;
import org.apache.hadoop.fs.azurenative.NativeFileSystemStore;
import org.apache.hadoop.fs.azurenative.PartialListing;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.fs.permission.PermissionStatus;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.Progressable;

public class NativeAzureFileSystem
extends FileSystem {
    public static final Log LOG = LogFactory.getLog(NativeAzureFileSystem.class);
    static final String AZURE_BLOCK_SIZE_PROPERTY_NAME = "fs.azure.block.size";
    static final String AZURE_TEMP_EXPIRY_PROPERTY_NAME = "fs.azure.fsck.temp.expiry.seconds";
    private static final int AZURE_TEMP_EXPIRY_DEFAULT = 3600;
    static final String PATH_DELIMITER = "/";
    static final String AZURE_TEMP_FOLDER = "_$azuretmpfolder$";
    private static final int AZURE_LIST_ALL = -1;
    private static final int AZURE_UNBOUNDED_DEPTH = -1;
    private static final long MAX_AZURE_BLOCK_SIZE = 0x20000000L;
    private static final String AZURE_DEFAULT_GROUP_PROPERTY_NAME = "fs.azure.permissions.supergroup";
    static final String AZURE_DEFAULT_GROUP_DEFAULT = "supergroup";
    static final String AZURE_BLOCK_LOCATION_HOST_PROPERTY_NAME = "fs.azure.block.location.impersonatedhost";
    private static final String AZURE_BLOCK_LOCATION_HOST_DEFAULT = "localhost";
    private URI uri;
    private NativeFileSystemStore store;
    private AzureNativeFileSystemStore actualStore;
    private Path workingDir;
    private long blockSize = 0x20000000L;
    private AzureFileSystemInstrumentation instrumentation;
    private static boolean suppressRetryPolicy = false;
    private static AtomicInteger metricsSourceNameCounter = new AtomicInteger();

    @Override
    public String getScheme() {
        return "wasb";
    }

    public NativeAzureFileSystem() {
    }

    public NativeAzureFileSystem(NativeFileSystemStore store) {
        this.store = store;
    }

    static void suppressRetryPolicy() {
        suppressRetryPolicy = true;
    }

    static void resumeRetryPolicy() {
        suppressRetryPolicy = false;
    }

    static String newMetricsSourceName() {
        int number = metricsSourceNameCounter.incrementAndGet();
        String baseName = "AzureFileSystemMetrics";
        if (number == 1) {
            return "AzureFileSystemMetrics";
        }
        return "AzureFileSystemMetrics" + number;
    }

    private static boolean isWasbScheme(String scheme) {
        return scheme != null && (scheme.equalsIgnoreCase("asv") || scheme.equalsIgnoreCase("asvs") || scheme.equalsIgnoreCase("wasb") || scheme.equalsIgnoreCase("wasbs"));
    }

    private static URI reconstructAuthorityIfNeeded(URI uri, Configuration conf) {
        URI defaultUri;
        if (null == uri.getAuthority() && (defaultUri = FileSystem.getDefaultUri(conf)) != null && NativeAzureFileSystem.isWasbScheme(defaultUri.getScheme())) {
            try {
                return new URI(uri.getScheme(), defaultUri.getAuthority(), uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            catch (URISyntaxException e) {
                throw new Error("Bad URI construction", e);
            }
        }
        return uri;
    }

    @Override
    protected void checkPath(Path path) {
        super.checkPath(new Path(NativeAzureFileSystem.reconstructAuthorityIfNeeded(path.toUri(), this.getConf())));
    }

    @Override
    public void initialize(URI uri, Configuration conf) throws IOException, IllegalArgumentException {
        if (null == (uri = NativeAzureFileSystem.reconstructAuthorityIfNeeded(uri, conf)).getAuthority()) {
            String errMsg = String.format("Cannot initialize WASB file system, URI authority not recognized.", new Object[0]);
            throw new IllegalArgumentException(errMsg);
        }
        super.initialize(uri, conf);
        if (this.store == null) {
            this.store = this.createDefaultStore(conf);
        }
        AzureFileSystemMetricsSystem.fileSystemStarted();
        String sourceName = NativeAzureFileSystem.newMetricsSourceName();
        String sourceDesc = "Azure Storage Volume File System metrics";
        this.instrumentation = DefaultMetricsSystem.instance().register(sourceName, sourceDesc, new AzureFileSystemInstrumentation(conf));
        AzureFileSystemMetricsSystem.registerSource(sourceName, sourceDesc, this.instrumentation);
        this.store.initialize(uri, conf, this.instrumentation);
        this.setConf(conf);
        this.uri = URI.create(uri.getScheme() + "://" + uri.getAuthority());
        this.workingDir = new Path("/user", UserGroupInformation.getCurrentUser().getShortUserName()).makeQualified(this.getUri(), this.getWorkingDirectory());
        this.blockSize = conf.getLong(AZURE_BLOCK_SIZE_PROPERTY_NAME, 0x20000000L);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"NativeAzureFileSystem. Initializing.");
            LOG.debug((Object)("  blockSize  = " + conf.getLong(AZURE_BLOCK_SIZE_PROPERTY_NAME, 0x20000000L)));
        }
    }

    private NativeFileSystemStore createDefaultStore(Configuration conf) {
        this.actualStore = new AzureNativeFileSystemStore();
        if (suppressRetryPolicy) {
            this.actualStore.suppressRetryPolicy();
        }
        return this.actualStore;
    }

    private String pathToKey(Path path) {
        URI tmpUri = path.toUri();
        String pathUri = tmpUri.getPath();
        Path newPath = path;
        if ("".equals(pathUri)) {
            newPath = new Path(tmpUri.toString() + PATH_DELIMITER);
        }
        if (!newPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + path);
        }
        String key = null;
        key = newPath.toUri().getPath();
        if (key.length() == 1) {
            return key;
        }
        return key.substring(1);
    }

    private static Path keyToPath(String key) {
        if (key.equals(PATH_DELIMITER)) {
            return new Path(PATH_DELIMITER);
        }
        return new Path(PATH_DELIMITER + key);
    }

    private Path makeAbsolute(Path path) {
        if (path.isAbsolute()) {
            return path;
        }
        return new Path(this.workingDir, path);
    }

    AzureNativeFileSystemStore getStore() {
        return this.actualStore;
    }

    public AzureFileSystemInstrumentation getInstrumentation() {
        return this.instrumentation;
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path parentFolder;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating file: " + f.toString()));
        }
        if (this.containsColon(f)) {
            throw new IOException("Cannot create file " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        FileMetadata existingMetadata = this.store.retrieveMetadata(key);
        if (existingMetadata != null) {
            if (existingMetadata.isDir()) {
                throw new IOException("Cannot create file " + f + "; already exists as a directory.");
            }
            if (!overwrite) {
                throw new IOException("File already exists:" + f);
            }
        }
        if ((parentFolder = absolutePath.getParent()) != null && parentFolder.getParent() != null) {
            String parentKey = this.pathToKey(parentFolder);
            FileMetadata parentMetadata = this.store.retrieveMetadata(parentKey);
            if (parentMetadata != null && parentMetadata.isDir() && parentMetadata.getBlobMaterialization() == BlobMaterialization.Explicit) {
                this.store.updateFolderLastModifiedTime(parentKey);
            } else {
                this.mkdirs(parentFolder, permission);
            }
        }
        String keyEncoded = NativeAzureFileSystem.encodeKey(key);
        FsPermission masked = this.applyUMask(permission, UMaskApplyMode.NewFile);
        PermissionStatus permissionStatus = this.createPermissionStatus(masked);
        this.store.storeEmptyLinkFile(key, keyEncoded, permissionStatus);
        NativeAzureFsOutputStream bufOutStream = new NativeAzureFsOutputStream(this.store.storefile(keyEncoded, permissionStatus), key, keyEncoded);
        FSDataOutputStream fsOut = new FSDataOutputStream(bufOutStream, this.statistics);
        this.instrumentation.fileCreated();
        return fsOut;
    }

    @Override
    @Deprecated
    public boolean delete(Path path) throws IOException {
        return this.delete(path, true);
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        Path absolutePath;
        String key;
        FileMetadata metaFile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting file: " + f.toString()));
        }
        if (null == (metaFile = this.store.retrieveMetadata(key = this.pathToKey(absolutePath = this.makeAbsolute(f))))) {
            return false;
        }
        if (!metaFile.isDir()) {
            Path parentPath = absolutePath.getParent();
            if (parentPath.getParent() != null) {
                String parentKey = this.pathToKey(parentPath);
                FileMetadata parentMetadata = this.store.retrieveMetadata(parentKey);
                if (!parentMetadata.isDir()) {
                    throw new AzureException("File " + f + " has a parent directory " + parentPath + " which is also a file. Can't resolve.");
                }
                if (parentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found an implicit parent directory while trying to delete the file " + f + ". Creating the directory blob for" + " it in " + parentKey + "."));
                    }
                    this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
                } else {
                    this.store.updateFolderLastModifiedTime(parentKey);
                }
            }
            this.store.delete(key);
            this.instrumentation.fileDeleted();
        } else {
            String parentKey;
            FileMetadata parentMetadata;
            Path parentPath = absolutePath.getParent();
            if (parentPath.getParent() != null && (parentMetadata = this.store.retrieveMetadata(parentKey = this.pathToKey(parentPath))).getBlobMaterialization() == BlobMaterialization.Implicit) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found an implicit parent directory while trying to delete the directory " + f + ". Creating the directory blob for" + " it in " + parentKey + "."));
                }
                this.store.storeEmptyFolder(parentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            String priorLastKey = null;
            PartialListing listing = this.store.listAll(key, -1, 1, priorLastKey);
            FileMetadata[] contents = listing.getFiles();
            if (!recursive && contents.length > 0) {
                throw new IOException("Non-recursive delete of non-empty directory " + f.toString());
            }
            for (FileMetadata p : contents) {
                String suffix = p.getKey().substring(p.getKey().lastIndexOf(PATH_DELIMITER));
                if (!p.isDir()) {
                    this.store.delete(key + suffix);
                    this.instrumentation.fileDeleted();
                    continue;
                }
                if (this.delete(new Path(f.toString() + suffix), true)) continue;
                return false;
            }
            this.store.delete(key);
            Path parent = absolutePath.getParent();
            if (parent != null && parent.getParent() != null) {
                String parentKey2 = this.pathToKey(parent);
                this.store.updateFolderLastModifiedTime(parentKey2);
            }
            this.instrumentation.directoryDeleted();
        }
        return true;
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        Path absolutePath;
        String key;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Getting the file status for " + f.toString()));
        }
        if ((key = this.pathToKey(absolutePath = this.makeAbsolute(f))).length() == 0) {
            return this.newDirectory(null, absolutePath);
        }
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            if (meta.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Path " + f.toString() + "is a folder."));
                }
                return this.newDirectory(meta, absolutePath);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found the path: " + f.toString() + " as a file."));
            }
            return this.newFile(meta, absolutePath);
        }
        throw new FileNotFoundException(absolutePath + ": No such file or directory.");
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Listing status for " + f.toString()));
        }
        Path absolutePath = this.makeAbsolute(f);
        String key = this.pathToKey(absolutePath);
        TreeSet<FileStatus> status = new TreeSet<FileStatus>();
        FileMetadata meta = this.store.retrieveMetadata(key);
        if (meta != null) {
            if (!meta.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Found path as a file");
                }
                return new FileStatus[]{this.newFile(meta, absolutePath)};
            }
            String partialKey = null;
            PartialListing listing = this.store.list(key, -1, 1, partialKey);
            for (FileMetadata fileMetadata : listing.getFiles()) {
                Path subpath = NativeAzureFileSystem.keyToPath(fileMetadata.getKey());
                if (fileMetadata.isDir()) {
                    if (fileMetadata.getKey().equals(AZURE_TEMP_FOLDER)) continue;
                    status.add(this.newDirectory(fileMetadata, subpath));
                    continue;
                }
                status.add(this.newFile(fileMetadata, subpath));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Found path as a directory with " + status.size() + " files in it."));
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Did not find any metadata for path: " + key));
            }
            throw new FileNotFoundException("File" + f + " does not exist.");
        }
        return status.toArray(new FileStatus[0]);
    }

    private FileStatus newFile(FileMetadata meta, Path path) {
        return new FileStatus(meta.getLength(), false, 1, this.blockSize, meta.getLastModified(), 0L, meta.getPermissionStatus().getPermission(), meta.getPermissionStatus().getUserName(), meta.getPermissionStatus().getGroupName(), path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FileStatus newDirectory(FileMetadata meta, Path path) {
        return new FileStatus(0L, true, 1, this.blockSize, meta == null ? 0L : meta.getLastModified(), 0L, meta == null ? FsPermission.getDefault() : meta.getPermissionStatus().getPermission(), meta == null ? "" : meta.getPermissionStatus().getUserName(), meta == null ? "" : meta.getPermissionStatus().getGroupName(), path.makeQualified(this.getUri(), this.getWorkingDirectory()));
    }

    private FsPermission applyUMask(FsPermission permission, UMaskApplyMode applyMode) {
        FsPermission newPermission = new FsPermission(permission);
        if (applyMode == UMaskApplyMode.NewFile || applyMode == UMaskApplyMode.NewDirectory) {
            newPermission = newPermission.applyUMask(FsPermission.getUMask(this.getConf()));
        }
        return newPermission;
    }

    private PermissionStatus createPermissionStatus(FsPermission permission) throws IOException {
        return new PermissionStatus(UserGroupInformation.getCurrentUser().getShortUserName(), this.getConf().get(AZURE_DEFAULT_GROUP_PROPERTY_NAME, AZURE_DEFAULT_GROUP_DEFAULT), permission);
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Creating directory: " + f.toString()));
        }
        if (this.containsColon(f)) {
            throw new IOException("Cannot create directory " + f + " through WASB that has colons in the name");
        }
        Path absolutePath = this.makeAbsolute(f);
        PermissionStatus permissionStatus = this.createPermissionStatus(this.applyUMask(permission, UMaskApplyMode.NewDirectory));
        ArrayList<String> keysToCreateAsFolder = new ArrayList<String>();
        ArrayList<String> keysToUpdateAsFolder = new ArrayList<String>();
        boolean childCreated = false;
        Path current = absolutePath;
        Path parent = current.getParent();
        while (parent != null) {
            String currentKey = this.pathToKey(current);
            FileMetadata currentMetadata = this.store.retrieveMetadata(currentKey);
            if (currentMetadata != null && !currentMetadata.isDir()) {
                throw new IOException("Cannot create directory " + f + " because " + current + " is an existing file.");
            }
            if (currentMetadata == null || currentMetadata.isDir() && currentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                keysToCreateAsFolder.add(currentKey);
                childCreated = true;
            } else {
                if (childCreated) {
                    keysToUpdateAsFolder.add(currentKey);
                }
                childCreated = false;
            }
            current = parent;
            parent = current.getParent();
        }
        for (String currentKey : keysToCreateAsFolder) {
            this.store.storeEmptyFolder(currentKey, permissionStatus);
        }
        Calendar lastModifiedCalendar = Calendar.getInstance(Utility.LOCALE_US);
        lastModifiedCalendar.setTimeZone(Utility.UTC_ZONE);
        Date lastModified = lastModifiedCalendar.getTime();
        for (String key : keysToUpdateAsFolder) {
            this.store.updateFolderLastModifiedTime(key, lastModified);
        }
        this.instrumentation.directoryCreated();
        return true;
    }

    @Override
    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path absolutePath;
        String key;
        FileMetadata meta;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening file: " + f.toString()));
        }
        if ((meta = this.store.retrieveMetadata(key = this.pathToKey(absolutePath = this.makeAbsolute(f)))) == null) {
            throw new FileNotFoundException(f.toString());
        }
        if (meta.isDir()) {
            throw new FileNotFoundException(f.toString() + " is a directory not a file.");
        }
        return new FSDataInputStream(new BufferedFSInputStream(new NativeAzureFsInputStream(this.store.retrieve(key), key), bufferSize));
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        Path destParent;
        FileMetadata srcMetadata;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Moving " + src + " to " + dst));
        }
        if (this.containsColon(dst)) {
            throw new IOException("Cannot rename to file " + dst + " through WASB that has colons in the name");
        }
        String srcKey = this.pathToKey(this.makeAbsolute(src));
        if (srcKey.length() == 0) {
            return false;
        }
        Path absoluteDst = this.makeAbsolute(dst);
        String dstKey = this.pathToKey(absoluteDst);
        FileMetadata dstMetadata = this.store.retrieveMetadata(dstKey);
        if (dstMetadata != null && dstMetadata.isDir()) {
            dstKey = this.pathToKey(this.makeAbsolute(new Path(dst, src.getName())));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Destination " + dst + " is a directory, adjusted the destination to be " + dstKey));
            }
        } else {
            if (dstMetadata != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Destination " + dst + " is an already existing file, failing the rename."));
                }
                return false;
            }
            FileMetadata parentOfDestMetadata = this.store.retrieveMetadata(this.pathToKey(absoluteDst.getParent()));
            if (parentOfDestMetadata == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Parent of the destination " + dst + " doesn't exist, failing the rename."));
                }
                return false;
            }
            if (!parentOfDestMetadata.isDir()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Parent of the destination " + dst + " is a file, failing the rename."));
                }
                return false;
            }
        }
        if ((srcMetadata = this.store.retrieveMetadata(srcKey)) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Source " + src + " doesn't exist, failing the rename."));
            }
            return false;
        }
        if (!srcMetadata.isDir()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Source " + src + " found as a file, renaming."));
            }
            this.store.rename(srcKey, dstKey);
        } else {
            PartialListing listing;
            String priorLastKey = null;
            do {
                listing = this.store.listAll(srcKey, -1, -1, priorLastKey);
                for (FileMetadata file : listing.getFiles()) {
                    if (file.getBlobMaterialization() != BlobMaterialization.Explicit) continue;
                    String srcName = file.getKey();
                    String suffix = srcName.substring(srcKey.length());
                    String dstName = dstKey + suffix;
                    this.store.rename(srcName, dstName);
                }
            } while ((priorLastKey = listing.getPriorLastKey()) != null);
            if (srcMetadata.getBlobMaterialization() == BlobMaterialization.Explicit) {
                this.store.rename(srcKey, dstKey);
            }
        }
        Path srcParent = this.makeAbsolute(NativeAzureFileSystem.keyToPath(srcKey)).getParent();
        if (srcParent != null && srcParent.getParent() != null) {
            String srcParentKey = this.pathToKey(srcParent);
            FileMetadata srcParentMetadata = this.store.retrieveMetadata(srcParentKey);
            if (srcParentMetadata.isDir() && srcParentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                this.store.storeEmptyFolder(srcParentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            this.store.updateFolderLastModifiedTime(srcParentKey);
        }
        if ((destParent = this.makeAbsolute(NativeAzureFileSystem.keyToPath(dstKey)).getParent()) != null && destParent.getParent() != null) {
            String dstParentKey = this.pathToKey(destParent);
            FileMetadata dstParentMetadata = this.store.retrieveMetadata(dstParentKey);
            if (dstParentMetadata.isDir() && dstParentMetadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
                this.store.storeEmptyFolder(dstParentKey, this.createPermissionStatus(FsPermission.getDefault()));
            }
            this.store.updateFolderLastModifiedTime(dstParentKey);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Renamed " + src + " to " + dst + " successfully."));
        }
        return true;
    }

    @Override
    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        if (file == null) {
            return null;
        }
        if (start < 0L || len < 0L) {
            throw new IllegalArgumentException("Invalid start or len parameter");
        }
        if (file.getLen() < start) {
            return new BlockLocation[0];
        }
        String blobLocationHost = this.getConf().get(AZURE_BLOCK_LOCATION_HOST_PROPERTY_NAME, AZURE_BLOCK_LOCATION_HOST_DEFAULT);
        String[] name = new String[]{blobLocationHost};
        String[] host = new String[]{blobLocationHost};
        long blockSize = file.getBlockSize();
        if (blockSize <= 0L) {
            throw new IllegalArgumentException("The block size for the given file is not a positive number: " + blockSize);
        }
        int numberOfLocations = (int)(len / blockSize) + (len % blockSize == 0L ? 0 : 1);
        BlockLocation[] locations = new BlockLocation[numberOfLocations];
        for (int i = 0; i < locations.length; ++i) {
            long currentOffset = start + (long)i * blockSize;
            long currentLength = Math.min(blockSize, start + len - currentOffset);
            locations[i] = new BlockLocation(name, host, currentOffset, currentLength);
        }
        return locations;
    }

    @Override
    public void setWorkingDirectory(Path newDir) {
        this.workingDir = this.makeAbsolute(newDir);
    }

    @Override
    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    @Override
    public void setPermission(Path p, FsPermission permission) throws IOException {
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = this.store.retrieveMetadata(key);
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        permission = this.applyUMask(permission, metadata.isDir() ? UMaskApplyMode.ChangeExistingDirectory : UMaskApplyMode.ChangeExistingFile);
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, this.createPermissionStatus(permission));
        } else if (!metadata.getPermissionStatus().getPermission().equals(permission)) {
            this.store.changePermissionStatus(key, new PermissionStatus(metadata.getPermissionStatus().getUserName(), metadata.getPermissionStatus().getGroupName(), permission));
        }
    }

    @Override
    public void setOwner(Path p, String username, String groupname) throws IOException {
        Path absolutePath = this.makeAbsolute(p);
        String key = this.pathToKey(absolutePath);
        FileMetadata metadata = this.store.retrieveMetadata(key);
        if (metadata == null) {
            throw new FileNotFoundException("File doesn't exist: " + p);
        }
        PermissionStatus newPermissionStatus = new PermissionStatus(username == null ? metadata.getPermissionStatus().getUserName() : username, groupname == null ? metadata.getPermissionStatus().getGroupName() : groupname, metadata.getPermissionStatus().getPermission());
        if (metadata.getBlobMaterialization() == BlobMaterialization.Implicit) {
            this.store.storeEmptyFolder(key, newPermissionStatus);
        } else {
            this.store.changePermissionStatus(key, newPermissionStatus);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.store.close();
        long startTime = System.currentTimeMillis();
        AzureFileSystemMetricsSystem.fileSystemClosed();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Submitting metrics when file system closed took " + (System.currentTimeMillis() - startTime) + " ms."));
        }
    }

    private boolean containsColon(Path p) {
        return p.toUri().getPath().toString().contains(":");
    }

    private void handleFilesWithDanglingTempData(Path root, DanglingFileHandler handler) throws IOException {
        PartialListing listing;
        long cutoffForDangling = new Date().getTime() - (long)(this.getConf().getInt(AZURE_TEMP_EXPIRY_PROPERTY_NAME, 3600) * 1000);
        String priorLastKey = null;
        do {
            listing = this.store.listAll(this.pathToKey(root), -1, -1, priorLastKey);
            for (FileMetadata file : listing.getFiles()) {
                FileMetadata linkMetadata;
                String link;
                if (file.isDir() || (link = this.store.getLinkInFileMetadata(file.getKey())) == null || (linkMetadata = this.store.retrieveMetadata(link)) == null || linkMetadata.getLastModified() < cutoffForDangling) continue;
                handler.handleFile(file, linkMetadata);
            }
        } while ((priorLastKey = listing.getPriorLastKey()) != null);
    }

    public void recoverFilesWithDanglingTempData(Path root, Path destination) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recovering files with dangling temp data in " + root));
        }
        this.handleFilesWithDanglingTempData(root, new DanglingFileRecoverer(destination));
    }

    public void deleteFilesWithDanglingTempData(Path root) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Deleting files with dangling temp data in " + root));
        }
        this.handleFilesWithDanglingTempData(root, new DanglingFileDeleter());
    }

    private static String encodeKey(String aKey) {
        String fileName = aKey.substring(aKey.lastIndexOf(PATH_DELIMITER) + 1, aKey.length());
        String filePrefix = "_$azuretmpfolder$/" + UUID.randomUUID().toString();
        String randomizedKey = filePrefix + fileName;
        return randomizedKey;
    }

    private class DanglingFileRecoverer
    extends DanglingFileHandler {
        private final Path destination;

        DanglingFileRecoverer(Path destination) {
            this.destination = destination;
        }

        @Override
        void handleFile(FileMetadata file, FileMetadata tempFile) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Recovering " + file.getKey()));
            }
            String finalDestinationKey = NativeAzureFileSystem.this.pathToKey(new Path(this.destination, file.getKey()));
            NativeAzureFileSystem.this.store.rename(tempFile.getKey(), finalDestinationKey);
            if (!finalDestinationKey.equals(file.getKey())) {
                NativeAzureFileSystem.this.store.delete(file.getKey());
            }
        }
    }

    private class DanglingFileDeleter
    extends DanglingFileHandler {
        private DanglingFileDeleter() {
        }

        @Override
        void handleFile(FileMetadata file, FileMetadata tempFile) throws IOException {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting dangling file " + file.getKey()));
            }
            NativeAzureFileSystem.this.store.delete(file.getKey());
            NativeAzureFileSystem.this.store.delete(tempFile.getKey());
        }
    }

    private abstract class DanglingFileHandler {
        private DanglingFileHandler() {
        }

        abstract void handleFile(FileMetadata var1, FileMetadata var2) throws IOException;
    }

    private static enum UMaskApplyMode {
        NewFile,
        NewDirectory,
        ChangeExistingFile,
        ChangeExistingDirectory;

    }

    private class NativeAzureFsOutputStream
    extends OutputStream {
        private String key;
        private String keyEncoded;
        private OutputStream out;

        public NativeAzureFsOutputStream(OutputStream out, String aKey, String anEncodedKey) throws IOException {
            if (null == out) {
                throw new IllegalArgumentException("Illegal argument: the output stream is null.");
            }
            if (null == aKey || 0 == aKey.length()) {
                throw new IllegalArgumentException("Illegal argument the key string is null or empty");
            }
            if (null == anEncodedKey || 0 == anEncodedKey.length()) {
                throw new IllegalArgumentException("Illegal argument the encoded key string is null or empty");
            }
            this.out = out;
            this.setKey(aKey);
            this.setEncodedKey(anEncodedKey);
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.out != null) {
                this.out.close();
                this.restoreKey();
                this.out = null;
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getEncodedKey() {
            return this.keyEncoded;
        }

        public void setEncodedKey(String anEncodedKey) {
            this.keyEncoded = anEncodedKey;
        }

        private void restoreKey() throws IOException {
            NativeAzureFileSystem.this.store.rename(this.getEncodedKey(), this.getKey());
        }
    }

    private class NativeAzureFsInputStream
    extends FSInputStream {
        private InputStream in;
        private final String key;
        private long pos = 0L;

        public NativeAzureFsInputStream(DataInputStream in, String key) {
            this.in = in;
            this.key = key;
        }

        @Override
        public synchronized int read() throws IOException {
            int result = 0;
            result = this.in.read();
            if (result != -1) {
                ++this.pos;
                if (NativeAzureFileSystem.this.statistics != null) {
                    NativeAzureFileSystem.this.statistics.incrementBytesRead(1L);
                }
            }
            return result;
        }

        @Override
        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int result = 0;
            result = this.in.read(b, off, len);
            if (result > 0) {
                this.pos += (long)result;
            }
            if (null != NativeAzureFileSystem.this.statistics) {
                NativeAzureFileSystem.this.statistics.incrementBytesRead(result);
            }
            return result;
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public synchronized void seek(long pos) throws IOException {
            this.in.close();
            this.in = NativeAzureFileSystem.this.store.retrieve(this.key, pos);
            this.pos = pos;
        }

        @Override
        public synchronized long getPos() throws IOException {
            return this.pos;
        }

        @Override
        public boolean seekToNewSource(long targetPos) throws IOException {
            return false;
        }
    }

    public static class Secure
    extends NativeAzureFileSystem {
        @Override
        public String getScheme() {
            return "wasbs";
        }
    }
}

