/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.streaming;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.impl.streaming.ExecutableManager;
import org.apache.pig.impl.streaming.StreamingCommand;

public class HadoopExecutableManager
extends ExecutableManager {
    private static final NumberFormat NUMBER_FORMAT = NumberFormat.getInstance();
    Configuration job;
    String scriptOutputDir;
    String scriptLogDir;
    String taskId;
    FSDataOutputStream errorStream;

    static String getOutputName(int partition) {
        return "part-" + NUMBER_FORMAT.format(partition);
    }

    public void configure(POStream stream) throws IOException, ExecException {
        super.configure(stream);
        File executable = new File(this.command.getExecutable());
        if (!executable.isAbsolute()) {
            try {
                FileUtil.chmod((String)executable.toString(), (String)"a+x");
            }
            catch (InterruptedException ie) {
                int errCode = 6013;
                String msg = "Unable to chmod " + executable + " . Thread interrupted.";
                throw new ExecException(msg, errCode, 16, ie);
            }
        }
        this.job = PigMapReduce.sJobConfInternal.get();
        this.scriptOutputDir = this.job.get("pig.streaming.task.output.dir");
        this.scriptLogDir = this.job.get("pig.streaming.log.dir", "_logs");
        this.taskId = this.job.get("mapred.task.id");
    }

    protected void exec() throws IOException {
        if (this.writeErrorToHDFS(this.command.getLogFilesLimit(), this.taskId)) {
            try {
                Path errorFile = new Path(new Path(this.scriptLogDir, this.command.getLogDir()), this.taskId);
                this.errorStream = errorFile.getFileSystem(this.job).create(errorFile);
            }
            catch (IOException ie) {
                System.err.println("Failed to create stderr file of task: " + this.taskId + " in HDFS at " + this.scriptLogDir + " with " + ie);
                this.errorStream = null;
            }
        }
        this.writeDebugHeader();
        super.exec();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            super.close();
            Path scriptOutputDir = new Path(this.scriptOutputDir);
            FileSystem fs = scriptOutputDir.getFileSystem(this.job);
            List<StreamingCommand.HandleSpec> outputSpecs = this.command.getHandleSpecs(StreamingCommand.Handle.OUTPUT);
            if (outputSpecs != null) {
                for (int i = 1; i < outputSpecs.size(); ++i) {
                    String fileName = outputSpecs.get(i).getName();
                    try {
                        int partition = this.job.getInt("mapred.task.partition", -1);
                        fs.copyFromLocalFile(false, true, new Path(fileName), new Path(new Path(scriptOutputDir, fileName), HadoopExecutableManager.getOutputName(partition)));
                        continue;
                    }
                    catch (IOException ioe) {
                        int errCode = 6014;
                        String msg = "Failed to save secondary output '" + fileName + "' of task: " + this.taskId;
                        throw new ExecException(msg, errCode, 16, ioe);
                    }
                }
            }
        }
        finally {
            this.writeDebugFooter();
            if (this.errorStream != null) {
                this.errorStream.close();
            }
        }
    }

    private boolean writeErrorToHDFS(int limit, String taskId) {
        if (this.command.getPersistStderr()) {
            int tipId = TaskAttemptID.forName((String)taskId).getTaskID().getId();
            return tipId < this.command.getLogFilesLimit();
        }
        return false;
    }

    protected void processError(String error) {
        super.processError(error);
        try {
            if (this.errorStream != null) {
                this.errorStream.writeBytes(error);
            }
        }
        catch (IOException ioe) {
            super.processError("Failed to save error logs to HDFS with: " + ioe);
        }
    }

    private void writeDebugHeader() {
        this.processError("===== Task Information Header =====");
        this.processError("\nCommand: " + this.command);
        this.processError("\nStart time: " + new Date(System.currentTimeMillis()));
        if (this.job.getBoolean("mapred.task.is.map", false)) {
            this.processError("\nInput-split file: " + this.job.get("map.input.file"));
            this.processError("\nInput-split start-offset: " + this.job.getLong("map.input.start", -1L));
            this.processError("\nInput-split length: " + this.job.getLong("map.input.length", -1L));
        }
        this.processError("\n=====          * * *          =====\n");
    }

    private void writeDebugFooter() {
        StreamingCommand.HandleSpec outputSpec;
        StreamingCommand.HandleSpec inputSpec;
        this.processError("===== Task Information Footer =====");
        this.processError("\nEnd time: " + new Date(System.currentTimeMillis()));
        this.processError("\nExit code: " + this.exitCode);
        List<StreamingCommand.HandleSpec> inputSpecs = this.command.getHandleSpecs(StreamingCommand.Handle.INPUT);
        StreamingCommand.HandleSpec handleSpec = inputSpec = inputSpecs != null ? inputSpecs.get(0) : null;
        if (inputSpec == null || !inputSpec.getSpec().contains("BinaryStorage")) {
            this.processError("\nInput records: " + this.inputRecords);
        }
        this.processError("\nInput bytes: " + this.inputBytes + " bytes " + (inputSpec != null ? "(" + inputSpec.getName() + " using " + inputSpec.getSpec() + ")" : ""));
        List<StreamingCommand.HandleSpec> outputSpecs = this.command.getHandleSpecs(StreamingCommand.Handle.OUTPUT);
        StreamingCommand.HandleSpec handleSpec2 = outputSpec = outputSpecs != null ? outputSpecs.get(0) : null;
        if (outputSpec == null || !outputSpec.getSpec().contains("BinaryStorage")) {
            this.processError("\nOutput records: " + this.outputRecords);
        }
        this.processError("\nOutput bytes: " + this.outputBytes + " bytes " + (outputSpec != null ? "(" + outputSpec.getName() + " using " + outputSpec.getSpec() + ")" : ""));
        if (outputSpecs != null) {
            for (int i = 1; i < outputSpecs.size(); ++i) {
                StreamingCommand.HandleSpec spec = outputSpecs.get(i);
                this.processError("\n           " + new File(spec.getName()).length() + " bytes using " + spec.getSpec());
            }
        }
        this.processError("\n=====          * * *          =====\n");
    }

    static {
        NUMBER_FORMAT.setMinimumIntegerDigits(5);
        NUMBER_FORMAT.setGroupingUsed(false);
    }
}

