/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.ExpressionOperator;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;

public class LOConst
extends ExpressionOperator {
    private static final long serialVersionUID = 2L;
    private Object mValue;

    public LOConst(LogicalPlan plan, OperatorKey k, Object value) {
        super(plan, k);
        this.mValue = value;
    }

    public Object getValue() {
        return this.mValue;
    }

    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public Schema getSchema() {
        return this.mSchema;
    }

    public Schema.FieldSchema getFieldSchema() throws FrontendException {
        if (!this.mIsFieldSchemaComputed) {
            try {
                this.mFieldSchema = DataType.determineFieldSchema(this.mValue);
                this.mIsFieldSchemaComputed = true;
            }
            catch (Exception e) {
                this.mFieldSchema = null;
                this.mIsFieldSchemaComputed = false;
                int errCode = 1015;
                String msg = "Error determining fieldschema of constant: " + this;
                throw new FrontendException(msg, errCode, 2, false, null, e);
            }
        }
        return this.mFieldSchema;
    }

    public String name() {
        return "Const " + this.mKey.scope + "-" + this.mKey.id + "( " + this.mValue + " )";
    }

    public boolean supportsMultipleInputs() {
        return false;
    }

    public boolean supportsMultipleOutputs() {
        return true;
    }

    protected Object clone() throws CloneNotSupportedException {
        LOConst clone = (LOConst)super.clone();
        return clone;
    }
}

