/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.html.themes;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.pentaho.platform.api.ui.IThemeResolver;
import org.pentaho.platform.api.ui.ModuleThemeInfo;
import org.pentaho.platform.api.ui.Theme;
import org.pentaho.platform.api.ui.ThemeResource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;

public class ServletContextThemeResolver
implements IThemeResolver {
    private Map<String, ModuleThemeInfo> moduleThemes = new HashMap<String, ModuleThemeInfo>();
    private ServletContext context;
    private Log logger = LogFactory.getLog(ServletContextThemeResolver.class);

    public void resolveThemes() {
        this.moduleThemes.clear();
        this.context = (ServletContext)PentahoSystem.getApplicationContext().getContext();
        if (this.context == null) {
            this.logger.debug((Object)"No ServletContext found");
            return;
        }
        for (Object rootFolderObj : this.context.getResourcePaths("/")) {
            String rootFolder = (String)rootFolderObj;
            this.findPluginThemes(rootFolder);
        }
    }

    public Map<String, ModuleThemeInfo> getModuleThemes() {
        this.resolveThemes();
        return this.moduleThemes;
    }

    public Map<String, Theme> getSystemThemes() {
        this.resolveThemes();
        HashMap<String, Theme> systemThemes = new HashMap<String, Theme>();
        for (String module : this.moduleThemes.keySet()) {
            for (Theme theme : this.moduleThemes.get(module).getSystemThemes()) {
                systemThemes.put(theme.getId(), theme);
            }
        }
        return systemThemes;
    }

    private void findPluginThemes(String pluginId) {
        if (!pluginId.startsWith("/")) {
            pluginId = "/" + pluginId;
        }
        try {
            InputStream pluginManifestStream = this.context.getResourceAsStream(pluginId + "themes.xml");
            if (pluginManifestStream == null) {
                return;
            }
            ResourceBundle resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle("themes", LocaleHelper.getDefaultLocale());
            }
            catch (MissingResourceException ignored) {
                // empty catch block
            }
            pluginId = pluginId.replace("/", "");
            SAXReader rdr = new SAXReader();
            Document pluginManifest = rdr.read(pluginManifestStream);
            String rootThemeFolder = pluginManifest.getRootElement().attributeValue("root-folder");
            if (rootThemeFolder == null) {
                return;
            }
            ModuleThemeInfo moduleThemeInfo = new ModuleThemeInfo(pluginId);
            List pluginNodes = pluginManifest.getRootElement().elements();
            for (Element themeNode : pluginNodes) {
                String themeId = themeNode.getName();
                String themeName = StringUtils.defaultIfEmpty((String)themeNode.attributeValue("display-name"), (String)themeId);
                if (themeName.startsWith("${") && resourceBundle != null) {
                    themeName = resourceBundle.getString(themeName);
                }
                Theme theme = new Theme(themeId, themeName, pluginId + "/" + rootThemeFolder + "/" + themeId + "/");
                theme.setHidden("true".equals(themeNode.attributeValue("hidden")));
                if ("true".equals(themeNode.attributeValue("system"))) {
                    moduleThemeInfo.getSystemThemes().add(theme);
                } else {
                    moduleThemeInfo.getModuleThemes().add(theme);
                }
                List resourceList = themeNode.elements();
                for (Element res : resourceList) {
                    theme.addResource(new ThemeResource(theme, res.getText()));
                }
            }
            this.moduleThemes.put(pluginId, moduleThemeInfo);
        }
        catch (Exception e) {
            this.logger.debug((Object)"Error parsing plugin themes", (Throwable)e);
        }
    }
}

