/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.api.usersettings.pojo.IUserSetting;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.web.http.api.resources.JobScheduleRequest;

public class SchedulerOutputPathResolver {
    final String DEFAULT_SETTING_KEY = "default-scheduler-output-path";
    private static final Log logger = LogFactory.getLog(SchedulerOutputPathResolver.class);
    private IUnifiedRepository repository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
    private IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
    private IUserSettingService settingsService;
    private JobScheduleRequest scheduleRequest;

    private IUserSettingService getSettingsService() {
        if (this.settingsService == null) {
            this.settingsService = (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.pentahoSession);
        }
        return this.settingsService;
    }

    public SchedulerOutputPathResolver(JobScheduleRequest scheduleRequest) {
        this.scheduleRequest = scheduleRequest;
    }

    public String resolveOutputFilePath() {
        String[] fallBackPaths;
        String fileName = RepositoryFilenameUtils.getBaseName((String)this.scheduleRequest.getInputFile());
        if (!StringUtils.isEmpty((String)this.scheduleRequest.getJobName())) {
            fileName = this.scheduleRequest.getJobName();
        }
        String fileNamePattern = "/" + fileName + ".*";
        String outputFilePath = this.scheduleRequest.getOutputFile();
        if (StringUtils.isNotBlank((String)outputFilePath) && this.isValidOutputPath(outputFilePath)) {
            return outputFilePath + fileNamePattern;
        }
        for (String path : fallBackPaths = new String[]{this.getUserSettingOutputPath(), this.getSystemSettingOutputPath(), this.getUserHomeDirectoryPath()}) {
            if (!StringUtils.isNotBlank((String)path) || !this.isValidOutputPath(path)) continue;
            return path + fileNamePattern;
        }
        return null;
    }

    private boolean isValidOutputPath(String path) {
        try {
            RepositoryFile repoFile = this.repository.getFile(path);
            if (repoFile != null && repoFile.isFolder()) {
                return true;
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private String getUserSettingOutputPath() {
        try {
            IUserSetting userSetting = this.getSettingsService().getUserSetting("default-scheduler-output-path", null);
            if (userSetting != null && StringUtils.isNotBlank((String)userSetting.getSettingValue())) {
                return userSetting.getSettingValue();
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private String getSystemSettingOutputPath() {
        try {
            return PentahoSystem.getSystemSettings().getSystemSetting("default-scheduler-output-path", null);
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private String getUserHomeDirectoryPath() {
        try {
            return ClientRepositoryPaths.getUserHomeFolderPath((String)this.pentahoSession.getName());
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

