/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianServer;
import mondrian.server.DynamicContentFinder;
import mondrian.server.FileRepository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.XmlaException;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DynamicDatasourceXmlaServlet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.tree.DefaultElement;
import org.olap4j.OlapConnection;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.SecurityHelper;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.repository.solution.filebased.MondrianVfs;
import org.pentaho.platform.repository.solution.filebased.SolutionRepositoryVfsFileObject;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.xml.sax.EntityResolver;

public class PentahoXmlaServlet
extends DynamicDatasourceXmlaServlet {
    final ICacheManager cacheMgr = PentahoSystem.getCacheManager(null);
    final String CACHE_REGION = "org.pentaho.platform.web.servlet.PentahoXmlaServlet";
    private static final long serialVersionUID = 5801343357261568600L;
    private static final Log logger = LogFactory.getLog(PentahoXmlaServlet.class);
    private final IUnifiedRepository repo;
    private final MondrianCatalogHelper mondrianCatalogService;

    public PentahoXmlaServlet() {
        if (!this.cacheMgr.cacheEnabled("org.pentaho.platform.web.servlet.PentahoXmlaServlet")) {
            this.cacheMgr.addCacheRegion("org.pentaho.platform.web.servlet.PentahoXmlaServlet");
        }
        this.repo = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class);
        this.mondrianCatalogService = (MondrianCatalogHelper)PentahoSystem.get(IMondrianCatalogService.class);
        try {
            DefaultFileSystemManager dfsm = (DefaultFileSystemManager)VFS.getManager();
            if (!dfsm.hasProvider("mondrian")) {
                dfsm.addProvider("mondrian", (FileProvider)new MondrianVfs());
            }
        }
        catch (FileSystemException e) {
            logger.error((Object)e.getMessage());
        }
    }

    protected RepositoryContentFinder makeContentFinder(String dataSourcesUrl) {
        Set keys = this.cacheMgr.getAllKeysFromRegionCache("org.pentaho.platform.web.servlet.PentahoXmlaServlet");
        if (!keys.contains(dataSourcesUrl)) {
            this.cacheMgr.putInRegionCache("org.pentaho.platform.web.servlet.PentahoXmlaServlet", (Object)dataSourcesUrl, (Object)new DynamicContentFinder(dataSourcesUrl){

                public String getContent() {
                    try {
                        String original = PentahoXmlaServlet.this.generateInMemoryDatasourcesXml();
                        PentahoEntityResolver loader = new PentahoEntityResolver();
                        Document originalDocument = XmlDom4JHelper.getDocFromString((String)original, (EntityResolver)loader);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)Messages.getInstance().getString("PentahoXmlaServlet.DEBUG_ORIG_DOC", new Object[]{originalDocument.asXML()}));
                        }
                        Document modifiedDocument = (Document)originalDocument.clone();
                        List<Node> nodesToRemove = this.getNodesToRemove(modifiedDocument);
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)Messages.getInstance().getString("PentahoXmlaServlet.DEBUG_NODES_TO_REMOVE", new Object[]{String.valueOf(nodesToRemove.size())}));
                        }
                        for (Node node : nodesToRemove) {
                            node.detach();
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)Messages.getInstance().getString("PentahoXmlaServlet.DEBUG_MOD_DOC", new Object[]{modifiedDocument.asXML()}));
                        }
                        return modifiedDocument.asXML();
                    }
                    catch (XmlParseException e) {
                        logger.error((Object)Messages.getInstance().getString("PentahoXmlaServlet.ERROR_0004_UNABLE_TO_GET_DOCUMENT_FROM_STRING"), (Throwable)e);
                        return null;
                    }
                }

                private List<Node> getNodesToRemove(Document doc) {
                    List nodesToRemove = doc.selectNodes("/DataSources/DataSource/Catalogs/Catalog");
                    CollectionUtils.filter((Collection)nodesToRemove, (Predicate)new Predicate(){

                        public boolean evaluate(Object o) {
                            Element el = ((DefaultElement)o).element("DataSourceInfo");
                            if (el == null || el.getText() == null || el.getTextTrim().length() == 0) {
                                throw new XmlaException("Server", "00UE001", "Internal Error", (Throwable)new MondrianException("DataSourceInfo not defined for " + ((DefaultElement)o).attribute("name").getText()));
                            }
                            return el.getText().matches("(?i).*EnableXmla=['\"]?false['\"]?");
                        }
                    });
                    return nodesToRemove;
                }
            });
        }
        return (RepositoryContentFinder)this.cacheMgr.getFromRegionCache("org.pentaho.platform.web.servlet.PentahoXmlaServlet", (Object)dataSourcesUrl);
    }

    private String generateInMemoryDatasourcesXml() {
        try {
            return (String)SecurityHelper.getInstance().runAsSystem((Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return PentahoXmlaServlet.this.mondrianCatalogService.generateInMemoryDatasourcesXml(PentahoXmlaServlet.this.repo);
                }
            });
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        return new ServletContextCatalogLocator(servletConfig.getServletContext()){

            public String locate(String catalogPath) {
                if (catalogPath.startsWith("mondrian:")) {
                    try {
                        FileSystemManager fsManager = VFS.getManager();
                        SolutionRepositoryVfsFileObject catalog = (SolutionRepositoryVfsFileObject)fsManager.resolveFile(catalogPath);
                        catalogPath = "solution:" + catalog.getFileRef();
                    }
                    catch (FileSystemException e) {
                        logger.error((Object)e.getMessage());
                    }
                } else {
                    catalogPath = super.locate(catalogPath);
                }
                return catalogPath;
            }
        };
    }

    protected String makeDataSourcesUrl(ServletConfig config) {
        return "";
    }

    protected XmlaHandler.ConnectionFactory createConnectionFactory(final ServletConfig servletConfig) throws ServletException {
        final XmlaHandler.ConnectionFactory delegate = super.createConnectionFactory(servletConfig);
        return new XmlaHandler.ConnectionFactory(){

            public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
                return delegate.getPreConfiguredDiscoverDatasourcesResponse();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public OlapConnection getConnection(String databaseName, String catalogName, String roleName, Properties props) throws SQLException {
                IPentahoSession session = PentahoSessionHolder.getSession();
                IConnectionUserRoleMapper mondrianUserRoleMapper = (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)"Mondrian-UserRoleMapper", null);
                String[] effectiveRoles = new String[]{};
                if (mondrianUserRoleMapper != null && catalogName != null) {
                    try {
                        effectiveRoles = mondrianUserRoleMapper.mapConnectionRoles(session, catalogName);
                        if (effectiveRoles == null) {
                            effectiveRoles = new String[]{};
                        }
                    }
                    catch (PentahoAccessControlException e) {
                        throw new SQLException(e);
                    }
                }
                boolean addComma = false;
                roleName = "";
                for (String role : effectiveRoles) {
                    if (addComma) {
                        roleName = roleName.concat(",");
                    }
                    roleName = roleName.concat(role);
                    addComma = true;
                }
                if (catalogName == null) {
                    return delegate.getConnection(databaseName, catalogName, roleName.equals("") ? null : roleName, props);
                }
                IMondrianCatalogService mcs = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class);
                MondrianCatalog mc = mcs.getCatalog(catalogName, PentahoSessionHolder.getSession());
                if (mc == null) {
                    throw new XmlaException("Client", "00HSBB08", "XMLA SOAP too many Discover RestrictionList element", (Throwable)new MondrianException("No such catalog: " + catalogName));
                }
                Connection con = DriverManager.getConnection((String)(mc.getDataSourceInfo() + ";Catalog=" + mc.getDefinition()), (CatalogLocator)PentahoXmlaServlet.this.makeCatalogLocator(servletConfig));
                try {
                    MondrianServer server = MondrianServer.forConnection((Connection)con);
                    FileRepository fr = new FileRepository(PentahoXmlaServlet.this.makeContentFinder(PentahoXmlaServlet.this.makeDataSourcesUrl(servletConfig)), PentahoXmlaServlet.this.makeCatalogLocator(servletConfig));
                    OlapConnection olapConnection = fr.getConnection(server, databaseName, catalogName, roleName, props);
                    return olapConnection;
                }
                finally {
                    con.close();
                }
            }
        };
    }
}

