/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer.sasl;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.net.InetAddresses;
import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.net.Peer;
import org.apache.hadoop.hdfs.protocol.datatransfer.InvalidEncryptionKeyException;
import org.apache.hadoop.hdfs.protocol.datatransfer.sasl.SaslParticipant;
import org.apache.hadoop.hdfs.protocol.proto.DataTransferProtos;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.security.SaslPropertiesResolver;
import org.apache.hadoop.security.SaslRpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class DataTransferSaslUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DataTransferSaslUtil.class);
    public static final String NAME_DELIMITER = " ";
    public static final int SASL_TRANSFER_MAGIC_NUMBER = -559038737;

    public static void checkSaslComplete(SaslParticipant sasl, Map<String, String> saslProps) throws IOException {
        if (!sasl.isComplete()) {
            throw new IOException("Failed to complete SASL handshake");
        }
        ImmutableSet requestedQop = ImmutableSet.copyOf(Arrays.asList(saslProps.get("javax.security.sasl.qop").split(",")));
        String negotiatedQop = sasl.getNegotiatedQop();
        LOG.debug("Verifying QOP, requested QOP = {}, negotiated QOP = {}", (Object)requestedQop, (Object)negotiatedQop);
        if (!requestedQop.contains(negotiatedQop)) {
            throw new IOException(String.format("SASL handshake completed, but channel does not have acceptable quality of protection, requested = %s, negotiated = %s", requestedQop, negotiatedQop));
        }
    }

    public static Map<String, String> createSaslPropertiesForEncryption(String encryptionAlgorithm) {
        HashMap saslProps = Maps.newHashMapWithExpectedSize((int)3);
        saslProps.put("javax.security.sasl.qop", SaslRpcServer.QualityOfProtection.PRIVACY.getSaslQop());
        saslProps.put("javax.security.sasl.server.authentication", "true");
        saslProps.put("com.sun.security.sasl.digest.cipher", encryptionAlgorithm);
        return saslProps;
    }

    public static char[] encryptionKeyToPassword(byte[] encryptionKey) {
        return new String(Base64.encodeBase64((byte[])encryptionKey, (boolean)false), Charsets.UTF_8).toCharArray();
    }

    public static InetAddress getPeerAddress(Peer peer) {
        String remoteAddr = peer.getRemoteAddressString().split(":")[0];
        int slashIdx = remoteAddr.indexOf(47);
        return InetAddresses.forString((String)(slashIdx != -1 ? remoteAddr.substring(slashIdx + 1, remoteAddr.length()) : remoteAddr));
    }

    public static SaslPropertiesResolver getSaslPropertiesResolver(Configuration conf) {
        String qops = conf.get("dfs.data.transfer.protection");
        if (qops == null || qops.isEmpty()) {
            LOG.debug("DataTransferProtocol not using SaslPropertiesResolver, no QOP found in configuration for {}", (Object)"dfs.data.transfer.protection");
            return null;
        }
        Configuration saslPropsResolverConf = new Configuration(conf);
        saslPropsResolverConf.set("hadoop.rpc.protection", qops);
        Class resolverClass = conf.getClass("hadoop.security.saslproperties.resolver.class", SaslPropertiesResolver.class, SaslPropertiesResolver.class);
        resolverClass = conf.getClass("dfs.data.transfer.saslproperties.resolver.class", resolverClass, SaslPropertiesResolver.class);
        saslPropsResolverConf.setClass("hadoop.security.saslproperties.resolver.class", resolverClass, SaslPropertiesResolver.class);
        SaslPropertiesResolver resolver = SaslPropertiesResolver.getInstance((Configuration)saslPropsResolverConf);
        LOG.debug("DataTransferProtocol using SaslPropertiesResolver, configured QOP {} = {}, configured class {} = {}", new Object[]{"dfs.data.transfer.protection", qops, "dfs.data.transfer.saslproperties.resolver.class", resolverClass});
        return resolver;
    }

    public static void performSaslStep1(OutputStream out, InputStream in, SaslParticipant sasl) throws IOException {
        byte[] remoteResponse = DataTransferSaslUtil.readSaslMessage(in);
        byte[] localResponse = sasl.evaluateChallengeOrResponse(remoteResponse);
        DataTransferSaslUtil.sendSaslMessage(out, localResponse);
    }

    public static byte[] readSaslMessage(InputStream in) throws IOException {
        DataTransferProtos.DataTransferEncryptorMessageProto proto = DataTransferProtos.DataTransferEncryptorMessageProto.parseFrom(PBHelper.vintPrefixed(in));
        if (proto.getStatus() == DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.ERROR_UNKNOWN_KEY) {
            throw new InvalidEncryptionKeyException(proto.getMessage());
        }
        if (proto.getStatus() == DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.ERROR) {
            throw new IOException(proto.getMessage());
        }
        return proto.getPayload().toByteArray();
    }

    public static void sendGenericSaslErrorMessage(OutputStream out, String message) throws IOException {
        DataTransferSaslUtil.sendSaslMessage(out, DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.ERROR, null, message);
    }

    public static void sendSaslMessage(OutputStream out, byte[] payload) throws IOException {
        DataTransferSaslUtil.sendSaslMessage(out, DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus.SUCCESS, payload, null);
    }

    public static void sendSaslMessage(OutputStream out, DataTransferProtos.DataTransferEncryptorMessageProto.DataTransferEncryptorStatus status, byte[] payload, String message) throws IOException {
        DataTransferProtos.DataTransferEncryptorMessageProto.Builder builder = DataTransferProtos.DataTransferEncryptorMessageProto.newBuilder();
        builder.setStatus(status);
        if (payload != null) {
            builder.setPayload(ByteString.copyFrom((byte[])payload));
        }
        if (message != null) {
            builder.setMessage(message);
        }
        DataTransferProtos.DataTransferEncryptorMessageProto proto = builder.build();
        proto.writeDelimitedTo(out);
        out.flush();
    }

    private DataTransferSaslUtil() {
    }
}

