/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan.logical.rules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.OperatorSubPlan;
import org.apache.pig.newplan.ReverseDependencyOrderWalker;
import org.apache.pig.newplan.logical.expression.AllSameExpressionVisitor;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.rules.ConstExpEvaluator;
import org.apache.pig.newplan.logical.rules.DNFExpression;
import org.apache.pig.newplan.logical.rules.DNFPlanGenerator;
import org.apache.pig.newplan.logical.rules.LogicalExpressionProxy;
import org.apache.pig.newplan.logical.rules.NOTConversionVisitor;
import org.apache.pig.newplan.optimizer.Rule;
import org.apache.pig.newplan.optimizer.Transformer;

public class LogicalExpressionSimplifier
extends Rule {
    private List<LOFilter> processedFilters = new ArrayList<LOFilter>();

    public LogicalExpressionSimplifier(String n) {
        super(n, false);
    }

    public Transformer getNewTransformer() {
        return new LogicalExpressionSimplifierTransformer(this.processedFilters);
    }

    protected OperatorPlan buildPattern() {
        LogicalPlan plan = new LogicalPlan();
        LOFilter op = new LOFilter(plan);
        plan.add(op);
        return plan;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogicalExpressionSimplifierTransformer
    extends Transformer {
        private static final String dnfCountAnnotationKey = "dnfSplitCount";
        private OperatorPlan plan;
        private List<LOFilter> processedFilters;
        static final byte ImplyLeft = 1;
        static final byte ImplyRight = 2;
        static final byte Exclusive = 4;
        static final byte Equal = 8;
        static final byte Complementary = 16;
        static final byte Unknown = -32;

        public LogicalExpressionSimplifierTransformer(List<LOFilter> processedFilters) {
            this.processedFilters = processedFilters;
        }

        @Override
        public boolean check(OperatorPlan matched) throws FrontendException {
            LOFilter filter = (LOFilter)matched.getOperators().next();
            if (this.processedFilters.contains(filter)) {
                return false;
            }
            this.processedFilters.add(filter);
            return true;
        }

        @Override
        public void transform(OperatorPlan plan) throws FrontendException {
            Iterator<Operator> iter = plan.getOperators();
            while (iter.hasNext()) {
                Operator[] sucs;
                Operator op = iter.next();
                if (!(op instanceof LOFilter)) continue;
                LOFilter filter = (LOFilter)op;
                LogicalExpressionPlan filterPlan = filter.getFilterPlan();
                this.plan = ((OperatorSubPlan)plan).getBasePlan();
                try {
                    ConstExpEvaluator constExpEvaluator = new ConstExpEvaluator(filterPlan);
                    constExpEvaluator.visit();
                    NOTConversionVisitor notVisitor = new NOTConversionVisitor(filterPlan);
                    notVisitor.visit();
                    DNFPlanGenerator dnfVisitor = new DNFPlanGenerator(filterPlan);
                    dnfVisitor.visit();
                    OperatorPlan dnfPlan = dnfVisitor.getDNFPlan();
                    this.checkDNFLeaves(dnfPlan);
                    this.trimLogicalExpressionPlan(filterPlan);
                }
                catch (FrontendException e) {
                    return;
                }
                if (filterPlan.size() != 0) continue;
                List<Operator> predList = this.plan.getPredecessors(op);
                List<Operator> sucList = this.plan.getSuccessors(op);
                Operator[] operatorArray = sucs = sucList == null ? null : sucList.toArray(new Operator[0]);
                if (sucs != null) {
                    for (Operator suc : sucs) {
                        this.plan.disconnect(op, suc);
                    }
                }
                if (predList != null) {
                    Operator[] preds;
                    for (Operator pred : preds = predList.toArray(new Operator[0])) {
                        this.plan.disconnect(pred, op);
                        if (sucs == null) continue;
                        for (Operator suc : sucs) {
                            this.plan.connect(pred, suc);
                        }
                    }
                }
                this.plan.remove(filter);
            }
        }

        static void incrDNFSplitCount(LogicalExpression le) {
            Integer cnt = (Integer)le.getAnnotation(dnfCountAnnotationKey);
            if (cnt == null) {
                cnt = 1;
            }
            le.annotate(dnfCountAnnotationKey, cnt + 1);
        }

        static void decrDNFSplitCount(LogicalExpression le) {
            Integer cnt = (Integer)le.getAnnotation(dnfCountAnnotationKey);
            if (cnt == null) {
                le.annotate(dnfCountAnnotationKey, 0);
            } else {
                le.annotate(dnfCountAnnotationKey, cnt - 1);
            }
        }

        static boolean dnfTrimmed(LogicalExpression le) {
            Integer cnt = (Integer)le.getAnnotation(dnfCountAnnotationKey);
            if (cnt == null) {
                return false;
            }
            return cnt == 0;
        }

        static int getSplitCount(LogicalExpression le) {
            Integer cnt = (Integer)le.getAnnotation(dnfCountAnnotationKey);
            if (cnt == null) {
                return 1;
            }
            return cnt;
        }

        private void checkDNFLeaves(OperatorPlan dnfPlan) throws FrontendException {
            List<Operator> roots = dnfPlan.getSources();
            if (roots == null || roots.size() != 1) {
                throw new FrontendException("DNF root size is expected to be one");
            }
            Operator dnf = roots.get(0);
            if (dnf instanceof AndExpression || dnf instanceof DNFExpression && ((DNFExpression)dnf).type == DNFExpression.DNFExpressionType.AND) {
                this.handleDNFAnd(dnfPlan, dnf);
            } else if (dnf instanceof OrExpression || dnf instanceof DNFExpression && ((DNFExpression)dnf).type == DNFExpression.DNFExpressionType.OR) {
                this.handleDNFOr(dnfPlan, dnf);
            } else if (dnf instanceof ConstantExpression && ((Boolean)((ConstantExpression)dnf).getValue()).booleanValue()) {
                LogicalExpressionSimplifierTransformer.decrDNFSplitCount((ConstantExpression)dnf);
            }
        }

        private void handleDNFAnd(OperatorPlan plan, Operator and) throws FrontendException {
            int i;
            List<Operator> children = plan.getSuccessors(and);
            if (children == null) {
                return;
            }
            int size = children.size();
            for (i = 0; i < size; ++i) {
                if (!(children.get(i) instanceof ConstantExpression) || !((Boolean)((ConstantExpression)children.get(i)).getValue()).booleanValue()) continue;
                LogicalExpressionSimplifierTransformer.decrDNFSplitCount((LogicalExpression)children.get(i));
            }
            for (i = 0; i < size; ++i) {
                LogicalExpression child1 = (LogicalExpression)children.get(i);
                for (int j = i + 1; j < size; ++j) {
                    LogicalExpression child2;
                    byte relation = this.inferRelationship(child1 instanceof LogicalExpressionProxy ? ((LogicalExpressionProxy)child1).src : child1, (child2 = (LogicalExpression)children.get(j)) instanceof LogicalExpressionProxy ? ((LogicalExpressionProxy)child2).src : child2);
                    if ((relation & 0xFFFFFFE0) != 0) continue;
                    if ((relation & 8) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) < LogicalExpressionSimplifierTransformer.getSplitCount(child2) && LogicalExpressionSimplifierTransformer.getSplitCount(child1) > 0) {
                            if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) <= 0) continue;
                            LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child1);
                            continue;
                        }
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child2) <= 0) continue;
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child2);
                        continue;
                    }
                    if ((relation & 4) != 0) continue;
                    if ((relation & 1) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) <= 0) continue;
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child1);
                        continue;
                    }
                    if ((relation & 2) == 0 || LogicalExpressionSimplifierTransformer.getSplitCount(child2) <= 0) continue;
                    LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child2);
                }
            }
            this.cleanupDNFPlan(plan, and);
        }

        private void handleDNFOr(OperatorPlan plan, Operator or) throws FrontendException {
            Operator[] children = plan.getSuccessors(or).toArray(new Operator[0]);
            int size = children.length;
            for (int i = 0; i < size; ++i) {
                if (!(children[i] instanceof ConstantExpression) || ((Boolean)((ConstantExpression)children[i]).getValue()).booleanValue()) continue;
                LogicalExpressionSimplifierTransformer.decrDNFSplitCount((LogicalExpression)children[i]);
            }
            for (int ii = 0; ii < size; ++ii) {
                LogicalExpression child = (LogicalExpression)children[ii];
                if (!(child instanceof AndExpression) && (!(child instanceof DNFExpression) || ((DNFExpression)child).type != DNFExpression.DNFExpressionType.AND)) continue;
                this.handleDNFAnd(plan, child);
            }
            children = plan.getSuccessors(or).toArray(new Operator[0]);
            size = children.length;
            for (int i = 0; i < size; ++i) {
                LogicalExpression child1 = (LogicalExpression)children[i];
                boolean proxy1 = child1 instanceof LogicalExpressionProxy;
                for (int j = i + 1; j < size; ++j) {
                    LogicalExpression child2;
                    boolean proxy2;
                    byte relation = this.inferRelationship(proxy1 ? ((LogicalExpressionProxy)child1).src : child1, (proxy2 = (child2 = (LogicalExpression)children[j]) instanceof LogicalExpressionProxy) ? ((LogicalExpressionProxy)child2).src : child2);
                    if ((relation & 0xFFFFFFE0) != 0) continue;
                    if ((relation & 8) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) < LogicalExpressionSimplifierTransformer.getSplitCount(child2) && LogicalExpressionSimplifierTransformer.getSplitCount(child1) > 0) {
                            if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) <= 0) continue;
                            LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child1);
                            continue;
                        }
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child2) <= 0) continue;
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child2);
                        continue;
                    }
                    if ((relation & 1) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child2) <= 0) continue;
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child2);
                        continue;
                    }
                    if ((relation & 2) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) <= 0) continue;
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child1);
                        continue;
                    }
                    if ((relation & 0x10) != 0) {
                        if (LogicalExpressionSimplifierTransformer.getSplitCount(child1) > 0) {
                            LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child1);
                        }
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount(child2);
                        continue;
                    }
                    if ((relation & 4) == 0) continue;
                }
            }
            this.cleanupDNFPlan(plan, or);
        }

        private void removeDescendants(OperatorPlan plan, Operator op) throws FrontendException {
            if (plan.getSuccessors(op) == null) {
                return;
            }
            Object[] children = plan.getSuccessors(op).toArray();
            if (children != null) {
                for (Object c : children) {
                    Operator child = (Operator)c;
                    this.removeDescendants(plan, child);
                    plan.disconnect(op, child);
                    if (child instanceof LogicalExpressionProxy) {
                        ((LogicalExpressionProxy)child).decrSrcDNFSplitCounter();
                    } else {
                        LogicalExpressionSimplifierTransformer.decrDNFSplitCount((LogicalExpression)child);
                    }
                    plan.remove(child);
                }
            }
        }

        private void cleanupDNFPlan(OperatorPlan plan, Operator root) throws FrontendException {
            Object[] children;
            for (Object c : children = plan.getSuccessors(root).toArray()) {
                LogicalExpression child = (LogicalExpression)c;
                if (!LogicalExpressionSimplifierTransformer.dnfTrimmed(child)) continue;
                this.removeDescendants(plan, child);
                plan.disconnect(root, child);
                if (child instanceof LogicalExpressionProxy) {
                    ((LogicalExpressionProxy)child).decrSrcDNFSplitCounter();
                }
                plan.remove(child);
            }
            if (plan.getSuccessors(root) != null && plan.getSuccessors(root).size() == 1) {
                Operator child = plan.getSuccessors(root).get(0);
                plan.disconnect(root, child);
                if (plan.getPredecessors(root) != null) {
                    Operator[] preds;
                    for (Operator pred : preds = plan.getPredecessors(root).toArray(new Operator[0])) {
                        plan.disconnect(pred, root);
                        plan.connect(pred, child);
                    }
                }
                if (root instanceof LogicalExpressionProxy) {
                    ((LogicalExpressionProxy)root).decrSrcDNFSplitCounter();
                } else {
                    LogicalExpressionSimplifierTransformer.decrDNFSplitCount((LogicalExpression)root);
                }
                plan.remove(root);
            } else if (plan.getSuccessors(root) == null) {
                plan.remove(root);
            }
        }

        private byte inferRelationship(LogicalExpression e1, LogicalExpression e2) throws FrontendException {
            boolean and2;
            byte result = 0;
            if (e1.isEqual(e2)) {
                result = 11;
                return result;
            }
            boolean and1 = e1 instanceof AndExpression || e1 instanceof DNFExpression && ((DNFExpression)e1).type == DNFExpression.DNFExpressionType.AND;
            boolean bl = and2 = e2 instanceof AndExpression || e2 instanceof DNFExpression && ((DNFExpression)e2).type == DNFExpression.DNFExpressionType.AND;
            if (e1 instanceof NotExpression && e2 instanceof IsNullExpression) {
                return this.handleNot((NotExpression)e1, (IsNullExpression)e2);
            }
            if (e2 instanceof NotExpression && e1 instanceof IsNullExpression) {
                return this.switchImplicationSides(this.handleNot((NotExpression)e2, (IsNullExpression)e1));
            }
            if (and1 && !and2) {
                return this.handleAndSimple(e1, e2);
            }
            if (and2 && !and1) {
                return this.switchImplicationSides(this.handleAndSimple(e2, e1));
            }
            if (and1 && and2) {
                return this.handleAnd(e1, e2);
            }
            if (e1 instanceof BinaryExpression && e2 instanceof BinaryExpression) {
                return this.handleBinary(e1, e2);
            }
            return -32;
        }

        private byte switchImplicationSides(byte ori) {
            byte result = ori;
            result = (byte)(result & 0xFFFFFFFC);
            if ((ori & 1) != 0) {
                result = (byte)(result | 2);
            }
            if ((ori & 2) != 0) {
                result = (byte)(result | 1);
            }
            return result;
        }

        private byte handleAnd(LogicalExpression e1, LogicalExpression e2) throws FrontendException {
            int j;
            int i;
            int i2;
            boolean allUnknown;
            int j2;
            List<Operator> children1 = e1.getPlan().getSuccessors(e1);
            List<Operator> children2 = e2.getPlan().getSuccessors(e2);
            int result = 0;
            boolean[][] knownFlags = new boolean[children1.size()][children2.size()];
            boolean[][] equalFlags = new boolean[children1.size()][children2.size()];
            for (int i3 = 0; i3 < children1.size(); ++i3) {
                for (j2 = 0; j2 < children2.size(); ++j2) {
                    byte inferResult = this.handleBinary((LogicalExpression)children1.get(i3), (LogicalExpression)children2.get(j2));
                    if ((inferResult & 0xFFFFFFE0) != 0) {
                        knownFlags[i3][j2] = false;
                        equalFlags[i3][j2] = false;
                        continue;
                    }
                    knownFlags[i3][j2] = true;
                    result = (byte)(result | inferResult);
                    if ((inferResult & 8) == 0) continue;
                    equalFlags[i3][j2] = true;
                }
            }
            if ((result & 4) != 0) {
                return 4;
            }
            if ((result & 2) != 0 && (result & 1) == 0) {
                allUnknown = true;
                for (j2 = 0; j2 < children2.size(); ++j2) {
                    allUnknown = true;
                    for (i2 = 0; i2 < children1.size(); ++i2) {
                        if (!knownFlags[i2][j2]) continue;
                        allUnknown = false;
                        break;
                    }
                    if (allUnknown) break;
                }
                if (!allUnknown) {
                    result = (byte)(result | 2);
                }
            }
            if ((result & 1) != 0 && (result & 2) == 0) {
                allUnknown = true;
                for (i = 0; i < children1.size(); ++i) {
                    allUnknown = true;
                    for (j = 0; j < children2.size(); ++j) {
                        if (!knownFlags[i][j]) continue;
                        allUnknown = false;
                        break;
                    }
                    if (allUnknown) break;
                }
                if (!allUnknown) {
                    result = (byte)(result | 2);
                }
            }
            if ((result & 2) != 0 && (result & 1) != 0) {
                boolean allEqual = true;
                for (i = 0; i < children1.size(); ++i) {
                    allEqual = true;
                    for (j = 0; j < children2.size(); ++j) {
                        if (equalFlags[i][j]) continue;
                        allEqual = false;
                        break;
                    }
                    if (!allEqual) break;
                }
                if (allEqual) {
                    for (j2 = 0; j2 < children1.size(); ++j2) {
                        allEqual = true;
                        for (i2 = 0; i2 < children2.size(); ++i2) {
                            if (equalFlags[i2][j2]) continue;
                            allEqual = false;
                            break;
                        }
                        if (!allEqual) break;
                    }
                }
                result = allEqual ? (int)((byte)(result | 8)) : -32;
            }
            if (result == 0) {
                return -32;
            }
            return (byte)result;
        }

        private byte handleAndSimple(LogicalExpression e1, LogicalExpression e2) throws FrontendException {
            if (e2 instanceof ConstantExpression) {
                return -32;
            }
            List<Operator> andChildren = e1.getPlan().getSuccessors(e1);
            boolean hasUnknown = false;
            int result = 0;
            int size = andChildren.size();
            for (int i = 0; i < size; ++i) {
                byte inferResult = this.handleBinary((LogicalExpression)andChildren.get(i), e2);
                if (!hasUnknown && (inferResult & 0xFFFFFFE0) != 0) {
                    hasUnknown = true;
                    continue;
                }
                result = (byte)(result | inferResult);
            }
            if ((result & 4) != 0) {
                return 4;
            }
            if (hasUnknown) {
                if ((result & 2) != 0) {
                    return 2;
                }
                return -32;
            }
            if ((result & 2) != 0) {
                return 2;
            }
            if (result == 1) {
                return 1;
            }
            return -32;
        }

        private byte handleNot(NotExpression not, IsNullExpression isnull) throws FrontendException {
            if (not.getExpression().isEqual(isnull)) {
                return 20;
            }
            return -32;
        }

        private byte handleBinary(LogicalExpression e1, LogicalExpression e2) throws FrontendException {
            LogicalExpression le2;
            boolean proxy1 = e1 instanceof LogicalExpressionProxy;
            boolean proxy2 = e2 instanceof LogicalExpressionProxy;
            LogicalExpression le1 = proxy1 ? ((LogicalExpressionProxy)e1).src : e1;
            LogicalExpression logicalExpression = le2 = proxy2 ? ((LogicalExpressionProxy)e2).src : e2;
            if (le1 instanceof NotExpression || le1 instanceof IsNullExpression || le2 instanceof NotExpression || le2 instanceof IsNullExpression) {
                if (le1 instanceof NotExpression && ((NotExpression)le1).getExpression() instanceof IsNullExpression && le2 instanceof IsNullExpression || le2 instanceof NotExpression && ((NotExpression)le2).getExpression() instanceof IsNullExpression && le1 instanceof IsNullExpression) {
                    return 4;
                }
                return -32;
            }
            if (!(le1 instanceof BinaryExpression) || !(le2 instanceof BinaryExpression)) {
                return -32;
            }
            BinaryExpression b1 = !proxy1 ? (BinaryExpression)e1 : (BinaryExpression)((LogicalExpressionProxy)e1).src;
            BinaryExpression b2 = !proxy2 ? (BinaryExpression)e2 : (BinaryExpression)((LogicalExpressionProxy)e2).src;
            LogicalExpression l1 = b1.getLhs();
            LogicalExpression r1 = b1.getRhs();
            LogicalExpression l2 = b2.getLhs();
            LogicalExpression r2 = b2.getRhs();
            if (l1 instanceof ConstantExpression && l2 instanceof ConstantExpression && r1.isEqual(r2)) {
                return this.handleComparison(l1, r1, l2, r2, proxy1 ? ((LogicalExpressionProxy)e1).src : e1, proxy2 ? ((LogicalExpressionProxy)e2).src : e2);
            }
            if (r1 instanceof ConstantExpression && l2 instanceof ConstantExpression && l1.isEqual(r2)) {
                return this.handleComparison(r1, l1, l2, r2, proxy1 ? ((LogicalExpressionProxy)e1).src : e1, proxy2 ? ((LogicalExpressionProxy)e2).src : e2);
            }
            if (l1 instanceof ConstantExpression && r2 instanceof ConstantExpression && r1.isEqual(l2)) {
                return this.handleComparison(l1, r1, r2, l2, proxy1 ? ((LogicalExpressionProxy)e1).src : e1, proxy2 ? ((LogicalExpressionProxy)e2).src : e2);
            }
            if (r1 instanceof ConstantExpression && r2 instanceof ConstantExpression && l1.isEqual(l2)) {
                return this.handleComparison(r1, l1, r2, l2, proxy1 ? ((LogicalExpressionProxy)e1).src : e1, proxy2 ? ((LogicalExpressionProxy)e2).src : e2);
            }
            return -32;
        }

        private byte handleComparison(LogicalExpression val1, LogicalExpression k1, LogicalExpression val2, LogicalExpression k2, LogicalExpression e1, LogicalExpression e2) {
            Object v1 = ((ConstantExpression)val1).getValue();
            Object v2 = ((ConstantExpression)val2).getValue();
            boolean comparable1 = v1 instanceof Comparable;
            boolean comparable2 = v2 instanceof Comparable;
            boolean isEqual1 = e1 instanceof EqualExpression;
            boolean isEqual2 = e2 instanceof EqualExpression;
            boolean isNotEqual1 = e1 instanceof NotEqualExpression;
            boolean isNotEqual2 = e2 instanceof NotEqualExpression;
            boolean isGT1 = e1 instanceof GreaterThanExpression;
            boolean isGT2 = e2 instanceof GreaterThanExpression;
            boolean isGE1 = e1 instanceof GreaterThanEqualExpression;
            boolean isGE2 = e2 instanceof GreaterThanEqualExpression;
            boolean isLT1 = e1 instanceof LessThanExpression;
            boolean isLT2 = e2 instanceof LessThanExpression;
            boolean isLE1 = e1 instanceof LessThanEqualExpression;
            boolean isLE2 = e2 instanceof LessThanEqualExpression;
            if (isEqual1 && isEqual2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                return 4;
            }
            if (isEqual1 && isNotEqual2) {
                if (v1.equals(v2)) {
                    return 4;
                }
                return 2;
            }
            if (isNotEqual1 && isEqual2) {
                if (v1.equals(v2)) {
                    return 4;
                }
                return 1;
            }
            if (isNotEqual1 && isNotEqual2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                return -32;
            }
            if (isEqual1 && isGT2) {
                if (v1.equals(v2)) {
                    return 4;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                        return 2;
                    }
                    return 4;
                }
                return -32;
            }
            if (isEqual1 && isGE2) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                        return 2;
                    }
                    return 4;
                }
                return -32;
            }
            if (isEqual1 && isLT2) {
                if (v1.equals(v2)) {
                    return 4;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                        return 4;
                    }
                    return 2;
                }
                return -32;
            }
            if (isNotEqual1 && isGT2) {
                if (v1.equals(v2)) {
                    return 1;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                        return 1;
                    }
                    return -32;
                }
                return -32;
            }
            if (isNotEqual1 && isGE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                        return 1;
                    }
                    return -32;
                }
                return -32;
            }
            if (isNotEqual1 && isLT2) {
                if (v1.equals(v2)) {
                    return 1;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                        return -32;
                    }
                    return 1;
                }
                return -32;
            }
            if (isNotEqual1 && isLE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (comparable1) {
                    if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                        return -32;
                    }
                    return 1;
                }
                return -32;
            }
            if (isGT1 && isGT2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 1;
                }
                return 2;
            }
            if (isGT1 && isGE2) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 1;
                }
                return 2;
            }
            if (isGT1 && isLT2) {
                if (v1.equals(v2)) {
                    return -32;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return -32;
                }
                return 4;
            }
            if (isGT1 && isLE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return -32;
                }
                return 4;
            }
            if (isGE1 && isGT2) {
                if (v1.equals(v2)) {
                    return 1;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 2;
                }
                return 1;
            }
            if (isGE1 && isGE2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 2;
                }
                return 1;
            }
            if (isGE1 && isLT2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 4;
                }
                return -32;
            }
            if (isGE1 && isLE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT1 && isGT2) {
                if (v1.equals(v2)) {
                    return -32;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT1 && isGE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT1 && isLT2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 2;
                }
                return 1;
            }
            if (isLT1 && isLE2) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 2;
                }
                return 1;
            }
            if (isLE1 && isGT2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return -32;
                }
                return 4;
            }
            if (isLE1 && isGE2) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLE1 && isLT2) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 1;
                }
                return 2;
            }
            if (isLE1 && isLE2) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v1).compareTo((Comparable)v2) > 0) {
                    return 1;
                }
                return 2;
            }
            if (isNotEqual2 && isGT1) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (comparable2) {
                    if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                        return 2;
                    }
                    return -32;
                }
                return -32;
            }
            if (isNotEqual2 && isGE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (comparable2) {
                    if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                        return 2;
                    }
                    return -32;
                }
                return -32;
            }
            if (isNotEqual2 && isLT1) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (comparable2) {
                    if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                        return -32;
                    }
                    return 2;
                }
                return -32;
            }
            if (isNotEqual2 && isLE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (comparable2) {
                    if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                        return -32;
                    }
                    return 2;
                }
                return -32;
            }
            if (isGT2 && isGT1) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 2;
                }
                return -32;
            }
            if (isGT2 && isGE1) {
                if (v1.equals(v2)) {
                    return 1;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 2;
                }
                return 1;
            }
            if (isGT2 && isLT1) {
                if (v1.equals(v2)) {
                    return -32;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return -32;
                }
                return 4;
            }
            if (isGT2 && isLE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return -32;
                }
                return 4;
            }
            if (isGE2 && isGT1) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 1;
                }
                return 2;
            }
            if (isGE2 && isGE1) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 1;
                }
                return 2;
            }
            if (isGE2 && isLT1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 4;
                }
                return -32;
            }
            if (isGE2 && isLE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT2 && isGT1) {
                if (v1.equals(v2)) {
                    return -32;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT2 && isGE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLT2 && isLT1) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 1;
                }
                return 2;
            }
            if (isLT2 && isLE1) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 1;
                }
                return 2;
            }
            if (isLE2 && isGT1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return -32;
                }
                return 4;
            }
            if (isLE2 && isGE1) {
                if (v1.equals(v2)) {
                    return 20;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) < 0) {
                    return 4;
                }
                return -32;
            }
            if (isLE2 && isLT1) {
                if (v1.equals(v2)) {
                    return 2;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 2;
                }
                return 1;
            }
            if (isLE2 && isLE1) {
                if (v1.equals(v2)) {
                    return 11;
                }
                if (((Comparable)v2).compareTo((Comparable)v1) > 0) {
                    return 2;
                }
                return 1;
            }
            return -32;
        }

        private void trimLogicalExpressionPlan(OperatorPlan ori) throws FrontendException {
            class TrimVisitor
            extends AllSameExpressionVisitor {
                LogicalExpressionPlan plan;

                TrimVisitor(LogicalExpressionPlan plan) throws FrontendException {
                    super(plan, new ReverseDependencyOrderWalker(plan));
                    this.plan = plan;
                }

                public void execute(LogicalExpression e) throws FrontendException {
                    if (LogicalExpressionSimplifierTransformer.dnfTrimmed(e)) {
                        this.remove(e);
                    }
                }

                public void visit(NotExpression op) throws FrontendException {
                    if (op.getExpression() == null) {
                        this.remove(op);
                    } else {
                        this.execute(op);
                    }
                }

                private void remove(Operator op) throws FrontendException {
                    List<Operator> p = this.plan.getPredecessors(op);
                    if (p != null) {
                        Operator[] preds;
                        for (Operator pred : preds = p.toArray(new Operator[0])) {
                            this.plan.disconnect(pred, op);
                        }
                    }
                    this.removeDescendants(op);
                }

                private void removeDescendants(Operator op) throws FrontendException {
                    List<Operator> p = this.plan.getSuccessors(op);
                    if (p != null) {
                        Operator[] sucs;
                        for (Operator suc : sucs = p.toArray(new Operator[0])) {
                            this.plan.disconnect(op, suc);
                            this.remove(suc);
                        }
                    }
                    this.plan.remove(op);
                }

                public void visit(OrExpression orExpr) throws FrontendException {
                    Operator rhs;
                    List<Operator> children = this.plan.getSuccessors(orExpr);
                    Operator lhs = children != null && children.size() > 0 ? children.get(0) : null;
                    Operator operator = rhs = children != null && children.size() > 1 ? children.get(1) : null;
                    if (lhs == null && rhs == null || LogicalExpressionSimplifierTransformer.dnfTrimmed(orExpr)) {
                        this.remove(orExpr);
                    } else if (rhs == null) {
                        this.trimOneChild(orExpr, lhs);
                        this.plan.remove(orExpr);
                    }
                }

                public void visit(AndExpression andExpr) throws FrontendException {
                    Operator rhs;
                    List<Operator> children = this.plan.getSuccessors(andExpr);
                    Operator lhs = children != null && children.size() > 0 ? children.get(0) : null;
                    Operator operator = rhs = children != null && children.size() > 1 ? children.get(1) : null;
                    if (lhs == null && rhs == null || LogicalExpressionSimplifierTransformer.dnfTrimmed(andExpr)) {
                        this.remove(andExpr);
                    } else if (rhs == null) {
                        this.trimOneChild(andExpr, lhs);
                        this.plan.remove(andExpr);
                    }
                }

                private void trimOneChild(Operator parent, Operator survivingChild) throws FrontendException {
                    Operator[] preds;
                    this.plan.disconnect(parent, survivingChild);
                    if (this.plan.getPredecessors(parent) == null) {
                        return;
                    }
                    for (Operator pred : preds = this.plan.getPredecessors(parent).toArray(new Operator[0])) {
                        Pair<Integer, Integer> pos = this.plan.disconnect(pred, parent);
                        this.plan.connect(pred, (Integer)pos.first, survivingChild, (Integer)pos.second);
                    }
                }
            }
            TrimVisitor worker = new TrimVisitor((LogicalExpressionPlan)ori);
            worker.visit();
        }

        @Override
        public OperatorPlan reportChanges() {
            return this.plan;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DNFExpressionType {
        AND,
        OR;

    }
}

