/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.scripting.jruby;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.FuncSpec;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.scripting.ScriptEngine;
import org.apache.pig.scripting.jruby.JrubyAccumulatorEvalFunc;
import org.apache.pig.scripting.jruby.JrubyAlgebraicEvalFunc;
import org.apache.pig.scripting.jruby.JrubyEvalFunc;
import org.apache.pig.scripting.jruby.PigJrubyLibrary;
import org.apache.pig.scripting.jruby.RubySchema;
import org.apache.pig.tools.pigstats.PigStats;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.ScriptingContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JrubyScriptEngine
extends ScriptEngine {
    private static final Log LOG = LogFactory.getLog(JrubyScriptEngine.class);
    protected static final ScriptingContainer rubyEngine = new ScriptingContainer(LocalContextScope.SINGLETHREAD, LocalVariableBehavior.PERSISTENT);
    private boolean isInitialized = false;

    @Override
    public void registerFunctions(String path, String namespace, PigContext pigContext) throws IOException {
        String method;
        if (!this.isInitialized) {
            pigContext.addScriptJar(JrubyScriptEngine.getJarPath(Ruby.class));
            pigContext.addScriptFile("pigudf.rb", "pigudf.rb");
            this.isInitialized = true;
        }
        for (Map.Entry<String, Object> entry : RubyFunctions.getFunctions("evalfunc", path).entrySet()) {
            method = entry.getKey();
            FuncSpec funcspec = new FuncSpec(JrubyEvalFunc.class.getCanonicalName() + "('" + path + "','" + method + "')");
            pigContext.registerFunction(namespace + "." + method, funcspec);
        }
        for (Map.Entry<String, Object> entry : RubyFunctions.getFunctions("accumulator", path).entrySet()) {
            method = entry.getKey();
            if (((RubyBoolean)rubyEngine.callMethod(entry.getValue(), "check_if_necessary_methods_present", RubyBoolean.class)).isFalse()) {
                throw new RuntimeException("Method " + method + " does not have all of the required methods present!");
            }
            pigContext.registerFunction(namespace + "." + method, new FuncSpec(JrubyAccumulatorEvalFunc.class.getCanonicalName() + "('" + path + "','" + method + "')"));
        }
        for (Map.Entry<String, Object> entry : RubyFunctions.getFunctions("algebraic", path).entrySet()) {
            method = entry.getKey();
            if (((RubyBoolean)rubyEngine.callMethod(entry.getValue(), "check_if_necessary_methods_present", RubyBoolean.class)).isFalse()) {
                throw new RuntimeException("Method " + method + " does not have all of the required methods present!");
            }
            Schema schema = PigJrubyLibrary.rubyToPig((RubySchema)((Object)rubyEngine.callMethod(entry.getValue(), "get_output_schema", RubySchema.class)));
            String canonicalName = JrubyAlgebraicEvalFunc.class.getCanonicalName() + "$";
            switch (schema.getField((int)0).type) {
                case 120: {
                    canonicalName = canonicalName + "Bag";
                    break;
                }
                case 110: {
                    canonicalName = canonicalName + "Tuple";
                    break;
                }
                case 55: {
                    canonicalName = canonicalName + "Chararray";
                    break;
                }
                case 25: {
                    canonicalName = canonicalName + "Double";
                    break;
                }
                case 20: {
                    canonicalName = canonicalName + "Float";
                    break;
                }
                case 10: {
                    canonicalName = canonicalName + "Integer";
                    break;
                }
                case 15: {
                    canonicalName = canonicalName + "Long";
                    break;
                }
                case 30: {
                    canonicalName = canonicalName + "DateTime";
                    break;
                }
                case 100: {
                    canonicalName = canonicalName + "Map";
                    break;
                }
                case 50: {
                    canonicalName = canonicalName + "DataByteArray";
                    break;
                }
                default: {
                    throw new ExecException("Unable to instantiate Algebraic EvalFunc " + method + " as schema type is invalid");
                }
            }
            canonicalName = canonicalName + "JrubyAlgebraicEvalFunc";
            pigContext.registerFunction(namespace + "." + method, new FuncSpec(canonicalName + "('" + path + "','" + method + "')"));
        }
        HashSet<String> toShip = this.libsToShip();
        for (String lib : toShip) {
            File libFile = new File(lib);
            if (lib.endsWith(".rb")) {
                pigContext.addScriptFile(lib);
                continue;
            }
            if (libFile.isDirectory()) {
                List<File> files = JrubyScriptEngine.listRecursively(libFile);
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    if (file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) {
                        pigContext.addScriptJar(file.getPath());
                        continue;
                    }
                    String localPath = libFile.getName() + file.getPath().replaceFirst(libFile.getPath(), "");
                    pigContext.addScriptFile(localPath, file.getPath());
                }
                continue;
            }
            pigContext.addScriptJar(lib);
        }
    }

    private HashSet<String> libsToShip() {
        RubyArray loadedLibs = (RubyArray)rubyEngine.get("$\"");
        RubyArray loadPaths = (RubyArray)rubyEngine.get("$LOAD_PATH");
        loadPaths.add(0, (Object)"");
        HashSet<String> toShip = new HashSet<String>();
        HashSet shippedLib = new HashSet();
        for (Object loadPath : loadPaths) {
            for (Object lib : loadedLibs) {
                String possiblePath;
                if (lib.toString().equals("pigudf.rb") || shippedLib.contains(lib) || !new File(possiblePath = (loadPath.toString().isEmpty() ? "" : loadPath.toString() + File.separator) + lib.toString()).exists()) continue;
                toShip.add(possiblePath.startsWith("./") ? possiblePath.substring(2) : possiblePath);
                shippedLib.add(lib);
            }
        }
        return toShip;
    }

    private static List<File> listRecursively(File directory) {
        File[] entries = directory.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        for (File entry : entries) {
            files.add(entry);
            if (!entry.isDirectory()) continue;
            files.addAll(JrubyScriptEngine.listRecursively(entry));
        }
        return files;
    }

    @Override
    protected Map<String, List<PigStats>> main(PigContext pigContext, String scriptFile) throws IOException {
        throw new UnsupportedOperationException("Unimplemented");
    }

    @Override
    protected String getScriptingLang() {
        return "jruby";
    }

    @Override
    protected Map<String, Object> getParamsFromVariables() throws IOException {
        HashMap<String, Object> vars = Maps.newHashMap();
        return vars;
    }

    static {
        rubyEngine.setCompatVersion(CompatVersion.RUBY1_9);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RubyFunctions {
        private static Map<String, Map<String, Map<String, Object>>> functionsCache = Maps.newHashMap();
        private static Map<String, Boolean> alreadyRunCache = Maps.newHashMap();
        private static Map<String, String> cacheFunction = Maps.newHashMap();

        RubyFunctions() {
        }

        private static Map<String, Object> getFromCache(String path, Map<String, Map<String, Object>> cacheToUpdate, String regCommand) {
            Map funcMap;
            Boolean runCheck = alreadyRunCache.get(path);
            if (runCheck == null || !runCheck.booleanValue()) {
                for (Map.Entry<String, Map<String, Map<String, Object>>> entry : functionsCache.entrySet()) {
                    entry.getValue().remove(path);
                }
                rubyEngine.runScriptlet(ScriptEngine.getScriptAsStream(path), path);
                alreadyRunCache.put(path, true);
            }
            if ((funcMap = cacheToUpdate.get(path)) == null) {
                funcMap = (Map)rubyEngine.runScriptlet(regCommand);
                cacheToUpdate.put(path, funcMap);
            }
            return funcMap;
        }

        public static Map<String, Object> getFunctions(String cache, String path) {
            return RubyFunctions.getFromCache(path, functionsCache.get(cache), cacheFunction.get(cache));
        }

        static {
            cacheFunction.put("evalfunc", "PigUdf.get_functions_to_register");
            cacheFunction.put("accumulator", "AccumulatorPigUdf.classes_to_register");
            cacheFunction.put("algebraic", "AlgebraicPigUdf.classes_to_register");
            functionsCache.put("evalfunc", new HashMap());
            functionsCache.put("accumulator", new HashMap());
            functionsCache.put("algebraic", new HashMap());
        }
    }
}

