/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.handlers;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import javax.jmi.reflect.RefBaseObject;
import org.netbeans.mdr.handlers.AssociationLinkWrapper;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.handlers.CollectionUnwrapper;
import org.netbeans.mdr.storagemodel.AssociationLink;
import org.netbeans.mdr.storagemodel.MdrStorage;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.util.DebugException;

public class IndexSetWrapper
implements Collection {
    protected final Collection inner;
    protected final MdrStorage storage;

    public IndexSetWrapper(MdrStorage mdrStorage, Collection inner) {
        this.inner = inner;
        this.storage = mdrStorage;
    }

    protected void lock(boolean writeAccess) {
        this.storage.getRepository().beginTrans(writeAccess);
    }

    protected void unlock() {
        this.storage.getRepository().endTrans();
    }

    protected void unlock(boolean fail) {
        this.storage.getRepository().endTrans(fail);
    }

    protected static Object wrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof StorableBaseObject) {
            return ((StorableBaseObject)obj).getMdrStorage().getRepository().getHandler((StorableBaseObject)obj);
        }
        if (obj instanceof AssociationLink) {
            return AssociationLinkWrapper.wrapLink((AssociationLink)obj);
        }
        throw new DebugException("Invalid object in collection: " + obj.getClass().getName());
    }

    protected static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof RefBaseObject) {
            return ((BaseObjectHandler)obj)._getDelegate().getMofId();
        }
        if (obj instanceof AssociationLinkWrapper) {
            return ((AssociationLinkWrapper)obj).getInnerLink();
        }
        return obj;
    }

    protected static Object[] wrapArray(Object[] array) {
        int i = 0;
        while (i < array.length) {
            array[i] = IndexSetWrapper.wrap(array[i]);
            ++i;
        }
        return array;
    }

    public boolean contains(Object obj) {
        this.lock(false);
        try {
            boolean bl = this.inner.contains(IndexSetWrapper.unwrap(obj));
            Object var2_3 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Iterator iterator() {
        this.lock(false);
        try {
            IndexIteratorWrapper indexIteratorWrapper = new IndexIteratorWrapper(this.inner.iterator());
            Object var1_2 = null;
            this.unlock();
            return indexIteratorWrapper;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public int size() {
        try {
            this.lock(false);
            int n = this.inner.size();
            Object var1_2 = null;
            this.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean isEmpty() {
        this.lock(false);
        try {
            boolean bl = this.inner.isEmpty();
            Object var1_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var1_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean containsAll(Collection collection) {
        this.lock(false);
        try {
            boolean bl = this.inner.containsAll(new CollectionUnwrapper(collection));
            Object var2_3 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var2_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object[] toArray(Object[] obj) {
        Object[] objectArray;
        this.lock(false);
        try {
            Object[] value = IndexSetWrapper.wrapArray(this.inner.toArray());
            Object[] result = obj;
            if (value.length > result.length) {
                if (value.getClass() == result.getClass()) {
                    Object[] objectArray2 = value;
                    Object var4_6 = null;
                    this.unlock();
                    return objectArray2;
                }
                result = (Object[])Array.newInstance(obj.getClass().getComponentType(), value.length);
            } else if (value.length < result.length) {
                result[value.length] = null;
            }
            System.arraycopy(value, 0, result, 0, value.length);
            objectArray = result;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.unlock();
            throw throwable;
        }
        Object var4_7 = null;
        this.unlock();
        return objectArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof Collection)) {
            return false;
        }
        this.lock(false);
        try {
            Object o2;
            Object o1;
            Iterator it1 = this.iterator();
            Iterator it2 = ((Collection)object).iterator();
            do {
                block5: {
                    if (it1.hasNext() && it2.hasNext()) break block5;
                }
                o1 = it1.next();
                o2 = it2.next();
            } while (!(o1 == null ? o2 != null : !o1.equals(o2)));
            Object var6_6 = null;
            this.unlock();
            return false;
            bl = !it1.hasNext() && !it2.hasNext();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.unlock();
            throw throwable;
        }
        Object var6_7 = null;
        this.unlock();
        return bl;
    }

    public int hashCode() {
        this.lock(false);
        try {
            int hashCode = 1;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            int n = hashCode;
            Object var4_5 = null;
            this.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    protected class IndexIteratorWrapper
    implements Iterator {
        protected Iterator innerIterator;

        public IndexIteratorWrapper(Iterator innerIterator) {
            this.innerIterator = innerIterator;
        }

        public boolean hasNext() {
            IndexSetWrapper.this.lock(false);
            try {
                boolean bl = this.innerIterator.hasNext();
                Object var1_2 = null;
                IndexSetWrapper.this.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                IndexSetWrapper.this.unlock();
                throw throwable;
            }
        }

        public Object next() {
            IndexSetWrapper.this.lock(false);
            try {
                Object object = IndexSetWrapper.wrap(this.innerIterator.next());
                Object var1_2 = null;
                IndexSetWrapper.this.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var1_3 = null;
                IndexSetWrapper.this.unlock();
                throw throwable;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

