/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.BitSet;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StorageIOException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDatabase;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.MapPage;

class LogFile {
    private int pageSize;
    private int numFiles;
    private final String baseName;
    private String name;
    private BitSet[] pageBitmaps;
    private MapPage currentMap;
    private FileCache cache;
    long fileId;
    private int beforeWriteFailure = -1;
    private int afterCommitFailure = -1;
    private int recoveryFailure = -1;

    LogFile(FileCache fCache, String baseName, int pgSz, int files, long id) throws StorageException {
        this.cache = fCache;
        this.pageSize = pgSz;
        this.baseName = baseName;
        this.numFiles = files;
        this.fileId = id;
        this.pageBitmaps = new BitSet[files];
        int i = 0;
        while (i < files) {
            this.pageBitmaps[i] = new BitSet();
            ++i;
        }
        if (new File(BtreeDatabase.getFileName(baseName, 2)).exists()) {
            this.recover();
        }
    }

    private boolean isPageLogged(CachedPage page) {
        return this.pageBitmaps[page.key.fileIndex].get(page.key.offset / this.pageSize);
    }

    private RandomAccessFile createPhysicalLog() throws StorageException {
        String name = BtreeDatabase.getFileName(this.baseName, 2);
        RandomAccessFile file = null;
        try {
            file = FileCache.getFile(name);
            file.setLength(0L);
            this.writeMap(file);
            RandomAccessFile randomAccessFile = file;
            Object var4_4 = null;
            if (file != null) {
                this.name = name;
            }
            return randomAccessFile;
        }
        catch (IOException ex) {
            try {
                throw new StorageIOException(ex);
            }
            catch (Throwable throwable) {
                block5: {
                    Object var4_5 = null;
                    if (file == null) break block5;
                    this.name = name;
                }
                throw throwable;
            }
        }
    }

    void addPageToLog(CachedPage page) throws StorageException {
        RandomAccessFile file;
        if (page.key.offset >= this.currentMap.getEOF(page.key.fileIndex)) {
            return;
        }
        if (this.isPageLogged(page)) {
            return;
        }
        try {
            file = this.name == null ? this.createPhysicalLog() : FileCache.getFile(this.name);
            file.seek(this.currentMap.nextPageOffset());
            file.write(page.contents);
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.beforeWriteFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.beforeWriteFailure", this.beforeWriteFailure);
        this.pageBitmaps[page.key.fileIndex].set(page.key.offset / this.pageSize);
        this.currentMap.add(page);
        if (this.currentMap.isFull()) {
            this.writeMap(file);
        }
        this.cache.holdForLog(page);
    }

    private void writeMap(RandomAccessFile file) throws StorageException {
        this.flushFile(file);
        this.currentMap.write(file);
        this.flushFile(file);
        if (this.currentMap.isFull()) {
            this.currentMap = new MapPage(this.currentMap);
        }
    }

    private void flushFile(RandomAccessFile file) throws StorageException {
        try {
            file.getFD().sync();
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    void flush() throws StorageException {
        try {
            this.writeMap(FileCache.getFile(this.name));
            this.cache.logWasFlushed();
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
    }

    void begin(String[] fileNames, long timeStamp, long newTimeStamp) throws StorageException {
        RandomAccessFile[] files;
        this.name = null;
        this.currentMap = new MapPage(this.pageSize, this.numFiles, 0);
        try {
            files = FileCache.getFiles(fileNames);
        }
        catch (IOException e) {
            throw new StorageIOException(e);
        }
        this.currentMap.setEOFs(files);
        int i = 0;
        while (i < this.numFiles) {
            this.pageBitmaps[i].xor(this.pageBitmaps[i]);
            ++i;
        }
        this.currentMap.setTimeStamps(timeStamp, newTimeStamp);
        this.currentMap.setFileID(this.fileId);
    }

    void commit() throws StorageException {
        try {
            if (this.name != null) {
                FileCache.closeFile(this.name);
                new File(this.name).delete();
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
        this.name = null;
        this.afterCommitFailure = FileCache.checkForForcedFailure("org.netbeans.mdr.persistence.btreeimpl.btreestorage.LogFile.afterCommitFailure", this.afterCommitFailure);
    }

    void close() throws StorageException {
        try {
            if (this.name != null) {
                FileCache.closeFile(this.name);
            }
        }
        catch (IOException ex) {
            throw new StorageIOException(ex);
        }
    }

    int fileSize() {
        return this.currentMap.nextPageOffset();
    }

    /*
     * Exception decompiling
     */
    void recover() throws StorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 274->280)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

