/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.mondrian;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import javax.script.ScriptEngineFactory;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeUtil;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataFactoryEditorSupport;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.DataSetQuery;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ExceptionDialog;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.AbstractNamedMDXDataFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.CubeFileProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.DriverDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.JndiDataSourceProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.mondrian.MondrianUtil;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.SmartComboBox;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.background.DataPreviewDialog;
import org.pentaho.reporting.libraries.designtime.swing.background.PreviewWorker;
import org.pentaho.reporting.libraries.designtime.swing.event.DocumentChangeHandler;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.CommonFileChooser;
import org.pentaho.reporting.libraries.designtime.swing.filechooser.FileChooserService;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.ui.datasources.jdbc.connection.DriverConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JdbcConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.connection.JndiConnectionDefinition;
import org.pentaho.reporting.ui.datasources.jdbc.ui.DataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.JdbcConnectionPanel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.LimitRowsCheckBoxActionListener;
import org.pentaho.reporting.ui.datasources.jdbc.ui.NamedDataSourceDialogModel;
import org.pentaho.reporting.ui.datasources.jdbc.ui.QueryLanguageListCellRenderer;
import org.pentaho.reporting.ui.datasources.mondrian.Messages;
import org.pentaho.reporting.ui.datasources.mondrian.MondrianPreviewWorker;
import org.pentaho.reporting.ui.datasources.mondrian.MondrianSecurityDialog;

public abstract class MondrianDataSourceEditor
extends CommonDialog {
    protected static final Log logger = LogFactory.getLog(MondrianDataSourceEditor.class);
    private JList queryNameList;
    private JTextField queryNameTextField;
    private JTextField filenameField;
    private JTextField cubeConnectionNameField;
    private JTextArea queryTextArea;
    private NamedDataSourceDialogModel dialogModel;
    private JSpinner maxPreviewRowsSpinner;
    private DesignTimeContext context;
    private MondrianSecurityDialog securityDialog;
    private String jdbcUserText;
    private String jdbcUserField;
    private String jdbcPasswordText;
    private String jdbcPasswordField;
    private String roleText;
    private String roleField;
    private Properties mondrianProperties;
    private RSyntaxTextArea globalScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> globalLanguageField;
    private RSyntaxTextArea queryScriptTextArea;
    private SmartComboBox<ScriptEngineFactory> queryLanguageField;
    private QueryLanguageListCellRenderer queryLanguageListCellRenderer;
    private GlobalTemplateAction globalTemplateAction;
    private QueryTemplateAction queryTemplateAction;

    public MondrianDataSourceEditor(DesignTimeContext context) {
        this.init(context);
    }

    public MondrianDataSourceEditor(DesignTimeContext context, Dialog owner) {
        super(owner);
        this.init(context);
    }

    public MondrianDataSourceEditor(DesignTimeContext context, Frame owner) {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.securityDialog = new MondrianSecurityDialog((Dialog)((Object)this), context);
        this.setModal(true);
        this.context = context;
        this.globalTemplateAction = new GlobalTemplateAction();
        this.queryTemplateAction = new QueryTemplateAction();
        QueryNameTextFieldDocumentListener updateHandler = new QueryNameTextFieldDocumentListener();
        ConfirmEnableHandler confirmAction = new ConfirmEnableHandler();
        this.dialogModel = new NamedDataSourceDialogModel();
        this.dialogModel.getQueries().addListDataListener((ListDataListener)updateHandler);
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)confirmAction);
        this.maxPreviewRowsSpinner = new JSpinner(new SpinnerNumberModel(10000, 1, Integer.MAX_VALUE, 1));
        this.cubeConnectionNameField = new JTextField(null, 0);
        this.cubeConnectionNameField.setColumns(30);
        this.cubeConnectionNameField.getDocument().addDocumentListener(confirmAction);
        this.filenameField = new JTextField(null, 0);
        this.filenameField.setColumns(30);
        this.filenameField.getDocument().addDocumentListener(confirmAction);
        this.dialogModel.setSchemaFileNameField(this.filenameField);
        this.queryNameTextField = new JTextField(null, 0);
        this.queryNameTextField.setColumns(35);
        this.queryNameTextField.setEnabled(this.dialogModel.isQuerySelected());
        this.queryNameTextField.getDocument().addDocumentListener((DocumentListener)((Object)updateHandler));
        this.queryTextArea = new JTextArea((String)null);
        this.queryTextArea.setWrapStyleWord(true);
        this.queryTextArea.setLineWrap(true);
        this.queryTextArea.setRows(5);
        this.queryTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryDocumentListener()));
        this.queryNameList = new JList(this.getDialogModel().getQueries());
        this.queryNameList.setSelectionMode(0);
        this.queryNameList.setVisibleRowCount(5);
        this.queryNameList.addListSelectionListener(new QuerySelectedHandler());
        this.globalScriptTextArea = new RSyntaxTextArea();
        this.globalScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.globalLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.globalLanguageField.setRenderer((ListCellRenderer)new QueryLanguageListCellRenderer());
        this.globalLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        this.queryScriptTextArea = new RSyntaxTextArea();
        this.queryScriptTextArea.setSyntaxEditingStyle("text/plain");
        this.queryScriptTextArea.getDocument().addDocumentListener((DocumentListener)((Object)new QueryScriptDocumentListener()));
        this.queryLanguageListCellRenderer = new QueryLanguageListCellRenderer();
        this.queryLanguageField = new SmartComboBox(new DefaultComboBoxModel<ScriptEngineFactory>(DataFactoryEditorSupport.getScriptEngineLanguages()));
        this.queryLanguageField.setRenderer((ListCellRenderer)this.queryLanguageListCellRenderer);
        this.queryLanguageField.addActionListener((ActionListener)new UpdateScriptLanguageHandler());
        super.init();
    }

    private void updateComponents() {
        ScriptEngineFactory globalLanguage = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        this.globalScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)globalLanguage));
        this.queryLanguageListCellRenderer.setDefaultValue(globalLanguage);
        ScriptEngineFactory queryScriptLanguage = (ScriptEngineFactory)this.queryLanguageField.getSelectedItem();
        if (queryScriptLanguage == null) {
            this.queryScriptTextArea.setSyntaxEditingStyle(this.globalScriptTextArea.getSyntaxEditingStyle());
        } else {
            this.queryScriptTextArea.setSyntaxEditingStyle(DataFactoryEditorSupport.mapLanguageToSyntaxHighlighting((ScriptEngineFactory)queryScriptLanguage));
        }
        boolean querySelected = this.dialogModel.isQuerySelected();
        this.queryScriptTextArea.setEnabled(querySelected);
        this.queryLanguageField.setEnabled(querySelected);
        this.queryTemplateAction.update();
        if (!querySelected) {
            this.queryTemplateAction.setEnabled(false);
        }
        this.globalTemplateAction.update();
    }

    private JPanel createQueryScriptTab() {
        JPanel queryHeader2 = new JPanel(new BorderLayout());
        queryHeader2.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.QueryScript", new Object[0])), "Center");
        queryHeader2.add((Component)new JButton(this.queryTemplateAction), "East");
        JPanel queryScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        queryScriptHeader.add(new JLabel(Messages.getString("MondrianDataSourceEditor.QueryScriptLanguage", new Object[0])));
        queryScriptHeader.add((Component)this.queryLanguageField);
        queryScriptHeader.add(queryHeader2);
        JPanel queryScriptContentHolder = new JPanel(new BorderLayout());
        queryScriptContentHolder.add((Component)queryScriptHeader, "North");
        queryScriptContentHolder.add((Component)new RTextScrollPane(700, 300, (RTextArea)this.queryScriptTextArea, true), "Center");
        return queryScriptContentHolder;
    }

    private JPanel createGlobalScriptTab() {
        JPanel globalHeader2 = new JPanel(new BorderLayout());
        globalHeader2.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.GlobalScript", new Object[0])), "Center");
        globalHeader2.add((Component)new JButton(this.globalTemplateAction), "East");
        JPanel globalScriptHeader = new JPanel((LayoutManager)new VerticalLayout(5, 3, 1));
        globalScriptHeader.add(new JLabel(Messages.getString("MondrianDataSourceEditor.GlobalScriptLanguage", new Object[0])));
        globalScriptHeader.add((Component)this.globalLanguageField);
        globalScriptHeader.add(globalHeader2);
        JPanel globalScriptContentHolder = new JPanel(new BorderLayout());
        globalScriptContentHolder.add((Component)globalScriptHeader, "North");
        globalScriptContentHolder.add((Component)new RTextScrollPane(700, 600, (RTextArea)this.globalScriptTextArea, true), "Center");
        return globalScriptContentHolder;
    }

    protected Component createContentPane() {
        JPanel queryContentPanel = new JPanel(new BorderLayout());
        queryContentPanel.add("North", this.createQueryListPanel());
        queryContentPanel.add("Center", this.createQueryDetailsPanel());
        JdbcConnectionPanel connectionPanel = new JdbcConnectionPanel((DataSourceDialogModel)this.dialogModel, this.context);
        connectionPanel.setSecurityConfigurationAvailable(false);
        JPanel dialogContent = new JPanel(new BorderLayout());
        dialogContent.add("North", this.createConnectionTopPanel());
        dialogContent.add("West", (Component)connectionPanel);
        dialogContent.add("Center", queryContentPanel);
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab(Messages.getString("MondrianDataSourceEditor.DataSource", new Object[0]), dialogContent);
        tabbedPane.addTab(Messages.getString("MondrianDataSourceEditor.GlobalScripting", new Object[0]), this.createGlobalScriptTab());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add("South", this.createPreviewButtonsPanel());
        contentPane.add("Center", tabbedPane);
        contentPane.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        return contentPane;
    }

    private JPanel createConnectionTopPanel() {
        JPanel masterPanel = new JPanel();
        masterPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        masterPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.SchemaFileLabel", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        masterPanel.add((Component)this.filenameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add((Component)new JButton(new BrowseAction()), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add(Box.createHorizontalStrut(20), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        masterPanel.add((Component)new JButton(new EditSecurityAction()), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 4;
        gbc.anchor = 17;
        masterPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.CubeConnectionName", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 5.0;
        masterPanel.add((Component)this.cubeConnectionNameField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.gridwidth = 3;
        gbc.anchor = 17;
        gbc.fill = 2;
        masterPanel.add((Component)new JButton(new RefreshSchemaNameAction()), gbc);
        return masterPanel;
    }

    private JPanel createQueryListPanel() {
        RemoveQueryAction queryRemoveAction = new RemoveQueryAction();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)queryRemoveAction);
        JPanel theQueryButtonsPanel = new JPanel(new FlowLayout(2, 5, 5));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)new AddQueryAction()));
        theQueryButtonsPanel.add((Component)new BorderlessButton((Action)queryRemoveAction));
        JPanel theQueryControlsPanel = new JPanel(new BorderLayout());
        theQueryControlsPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.AvailableQueriesLabel", new Object[0])), "West");
        theQueryControlsPanel.add((Component)theQueryButtonsPanel, "East");
        JPanel queryListPanel = new JPanel(new BorderLayout());
        queryListPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 8));
        queryListPanel.add("North", theQueryControlsPanel);
        queryListPanel.add("Center", new JScrollPane(this.queryNameList));
        return queryListPanel;
    }

    private JPanel createQueryDetailsPanel() {
        JPanel queryNamePanel = new JPanel(new BorderLayout());
        queryNamePanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        queryNamePanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.QueryNameLabel", new Object[0])), "North");
        queryNamePanel.add((Component)this.queryNameTextField, "South");
        JPanel queryControlPanel = new JPanel(new BorderLayout());
        queryControlPanel.add((Component)new JLabel(Messages.getString("MondrianDataSourceEditor.QueryLabel", new Object[0])), "West");
        JPanel queryPanel = new JPanel(new BorderLayout());
        queryPanel.add((Component)queryControlPanel, "North");
        queryPanel.add((Component)new JScrollPane(this.queryTextArea), "Center");
        queryPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 0, 8));
        JTabbedPane queryScriptTabPane = new JTabbedPane();
        queryScriptTabPane.addTab(Messages.getString("MondrianDataSourceEditor.StaticQuery", new Object[0]), queryPanel);
        queryScriptTabPane.addTab(Messages.getString("MondrianDataSourceEditor.QueryScripting", new Object[0]), this.createQueryScriptTab());
        JPanel queryDetailsPanel = new JPanel(new BorderLayout());
        queryDetailsPanel.add("North", queryNamePanel);
        queryDetailsPanel.add("Center", queryScriptTabPane);
        return queryDetailsPanel;
    }

    private JPanel createPreviewButtonsPanel() {
        JPanel previewButtonsPanel = new JPanel(new FlowLayout(2));
        previewButtonsPanel.add(new JCheckBox((Action)new LimitRowsCheckBoxActionListener(this.maxPreviewRowsSpinner)));
        previewButtonsPanel.add(this.maxPreviewRowsSpinner);
        PreviewAction previewAction = new PreviewAction();
        this.dialogModel.addPropertyChangeListener((PropertyChangeListener)previewAction);
        previewButtonsPanel.add(new JButton(previewAction));
        return previewButtonsPanel;
    }

    protected abstract AbstractMDXDataFactory createDataFactory();

    public DataFactory performConfiguration(AbstractNamedMDXDataFactory dataFactory, String selectedQueryName) {
        this.getDialogModel().clear();
        this.roleText = null;
        this.roleField = null;
        this.jdbcUserText = null;
        this.jdbcUserField = null;
        this.jdbcPasswordText = null;
        this.jdbcPasswordField = null;
        this.mondrianProperties = null;
        if (dataFactory != null) {
            this.roleText = dataFactory.getRole();
            this.roleField = dataFactory.getRoleField();
            this.jdbcUserText = dataFactory.getJdbcUser();
            this.jdbcUserField = dataFactory.getJdbcUserField();
            this.jdbcPasswordText = dataFactory.getJdbcPassword();
            this.jdbcPasswordField = dataFactory.getJdbcPasswordField();
            this.mondrianProperties = dataFactory.getBaseConnectionProperties();
            this.setGlobalScriptingLanguage(dataFactory.getGlobalScriptLanguage());
            this.globalScriptTextArea.setText(dataFactory.getGlobalScript());
            CubeFileProvider fileProvider = dataFactory.getCubeFileProvider();
            if (fileProvider != null) {
                this.setSchemaFileName(fileProvider.getDesignTimeFile());
                this.cubeConnectionNameField.setText(fileProvider.getCubeConnectionName());
            } else {
                this.setSchemaFileName("");
                this.cubeConnectionNameField.setText("");
            }
            String[] queryNames = dataFactory.getQueryNames();
            for (int i = 0; i < queryNames.length; ++i) {
                String queryName = queryNames[i];
                String query = dataFactory.getQuery(queryName);
                String scriptLanguage = dataFactory.getScriptingLanguage(queryName);
                String script = dataFactory.getScript(queryName);
                this.dialogModel.addQuery(queryName, query, scriptLanguage, script);
            }
            this.dialogModel.setSelectedQuery(selectedQueryName);
            JdbcConnectionDefinition definition = this.createConnectionDefinition((AbstractMDXDataFactory)dataFactory);
            this.getDialogModel().addConnection(definition);
            this.getDialogModel().getConnections().setSelectedItem(definition);
        }
        if (!this.performEdit()) {
            return null;
        }
        return this.createDataFactory();
    }

    protected JdbcConnectionDefinition createConnectionDefinition(AbstractMDXDataFactory dataFactory) {
        DataSourceProvider provider;
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        String customName = dataFactory.getDesignTimeName();
        if (customName == null) {
            customName = Messages.getString("MondrianDataSourceEditor.CustomConnection", new Object[0]);
        }
        if ((provider = dataFactory.getDataSourceProvider()) instanceof DriverDataSourceProvider) {
            DriverDataSourceProvider dcp = (DriverDataSourceProvider)provider;
            DefaultComboBoxModel model = this.dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                DriverConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof DriverConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (DriverConnectionDefinition)definition).getDriverClass(), (Object)dcp.getDriver()) || !ObjectUtilities.equal((Object)dcd.getUsername(), (Object)dcp.getProperty("user")) || !ObjectUtilities.equal((Object)dcd.getPassword(), (Object)dcp.getProperty("password")) || !ObjectUtilities.equal((Object)dcd.getConnectionString(), (Object)dcp.getUrl()) || !ObjectUtilities.equal((Object)dcd.getName(), (Object)dcp.getProperty("::pentaho-reporting::name"))) continue;
                return definition;
            }
            String[] strings = dcp.getPropertyNames();
            Properties p = new Properties();
            for (int i = 0; i < strings.length; ++i) {
                String string = strings[i];
                p.put(string, dcp.getProperty(string));
            }
            return new DriverConnectionDefinition(customName, dcp.getDriver(), dcp.getUrl(), null, null, dcp.getProperty("::pentaho-reporting::hostname"), dcp.getProperty("::pentaho-reporting::database-name"), dcp.getProperty("::pentaho-reporting::database-type"), dcp.getProperty("::pentaho-reporting::port"), p);
        }
        if (provider instanceof JndiDataSourceProvider) {
            JndiDataSourceProvider jcp = (JndiDataSourceProvider)provider;
            DefaultComboBoxModel model = this.dialogModel.getConnections();
            for (int i = 0; i < model.getSize(); ++i) {
                JndiConnectionDefinition dcd;
                JdbcConnectionDefinition definition = (JdbcConnectionDefinition)model.getElementAt(i);
                if (!(definition instanceof JndiConnectionDefinition) || !ObjectUtilities.equal((Object)(dcd = (JndiConnectionDefinition)definition).getJndiName(), (Object)jcp.getConnectionPath())) continue;
                return dcd;
            }
            return new JndiConnectionDefinition(customName, jcp.getConnectionPath(), null, null, null);
        }
        return null;
    }

    protected String getFileName() {
        return this.filenameField.getText();
    }

    public void setFileName(String fileName) {
        this.filenameField.setText(fileName);
    }

    protected NamedDataSourceDialogModel getDialogModel() {
        return this.dialogModel;
    }

    protected void setSchemaFileName(String schema) {
        this.filenameField.setText(schema);
    }

    protected String getSchemaFileName() {
        return this.filenameField.getText();
    }

    protected void configureConnection(AbstractMDXDataFactory dataFactory) {
        CubeFileProvider cubeFileProvider = (CubeFileProvider)ClassicEngineBoot.getInstance().getObjectFactory().get(CubeFileProvider.class);
        cubeFileProvider.setDesignTimeFile(this.getSchemaFileName());
        cubeFileProvider.setCubeConnectionName(this.cubeConnectionNameField.getText());
        dataFactory.setCubeFileProvider(cubeFileProvider);
        dataFactory.setRole(this.roleText);
        dataFactory.setRoleField(this.roleField);
        dataFactory.setJdbcUser(this.jdbcUserText);
        dataFactory.setJdbcUserField(this.jdbcUserField);
        dataFactory.setJdbcPassword(this.jdbcPasswordText);
        dataFactory.setJdbcPasswordField(this.jdbcPasswordField);
        dataFactory.setBaseConnectionProperties(this.mondrianProperties);
        JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)this.getDialogModel().getConnections().getSelectedItem();
        dataFactory.setDesignTimeName(connectionDefinition.getName());
        if (connectionDefinition instanceof DriverConnectionDefinition) {
            DriverConnectionDefinition dcd = (DriverConnectionDefinition)connectionDefinition;
            DriverDataSourceProvider dataSourceProvider = new DriverDataSourceProvider();
            dataSourceProvider.setUrl(dcd.getConnectionString());
            dataSourceProvider.setDriver(dcd.getDriverClass());
            Properties properties = dcd.getProperties();
            Enumeration<Object> keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                dataSourceProvider.setProperty(key, properties.getProperty(key));
            }
            dataFactory.setDataSourceProvider((DataSourceProvider)dataSourceProvider);
        } else {
            JndiConnectionDefinition jcd = (JndiConnectionDefinition)connectionDefinition;
            dataFactory.setDataSourceProvider((DataSourceProvider)new JndiDataSourceProvider(jcd.getJndiName()));
        }
    }

    private void setGlobalScriptingLanguage(String lang) {
        this.setScriptingLanguage(lang, (JComboBox)this.globalLanguageField);
    }

    protected void setScriptingLanguage(String lang, JComboBox languageField) {
        if (lang == null) {
            languageField.setSelectedItem(null);
            return;
        }
        ComboBoxModel model = languageField.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ScriptEngineFactory elementAt = (ScriptEngineFactory)model.getElementAt(i);
            if (elementAt == null || !elementAt.getNames().contains(lang)) continue;
            languageField.setSelectedItem(elementAt);
            return;
        }
    }

    private String getGlobalScriptingLanguage() {
        ScriptEngineFactory selectedValue = (ScriptEngineFactory)this.globalLanguageField.getSelectedItem();
        if (selectedValue == null) {
            return null;
        }
        return selectedValue.getLanguageName();
    }

    protected void configureQueries(AbstractNamedMDXDataFactory dataFactory) {
        dataFactory.setGlobalScriptLanguage(this.getGlobalScriptingLanguage());
        if (!StringUtils.isEmpty((String)this.globalScriptTextArea.getText())) {
            dataFactory.setGlobalScript(this.globalScriptTextArea.getText());
        }
        DataSetComboBoxModel queries = this.dialogModel.getQueries();
        for (int i = 0; i < queries.getSize(); ++i) {
            DataSetQuery query = queries.getQuery(i);
            dataFactory.setQuery(query.getQueryName(), (String)query.getQuery(), query.getScriptLanguage(), query.getScript());
        }
    }

    protected String getQueryName() {
        return this.queryNameTextField.getText();
    }

    protected void setQueryName(String queryName) {
        this.queryNameTextField.setText(queryName);
    }

    protected boolean validateInputs(boolean onConfirm) {
        NamedDataSourceDialogModel dialogModel = this.getDialogModel();
        if (!dialogModel.isConnectionSelected()) {
            return false;
        }
        return !StringUtils.isEmpty((String)this.filenameField.getText(), (boolean)true);
    }

    protected void autoRefreshSchemaName() {
        if (!StringUtils.isEmpty((String)this.cubeConnectionNameField.getText())) {
            return;
        }
        this.cubeConnectionNameField.setText(this.lookupSchemaName());
    }

    private String lookupSchemaName() {
        AbstractReportDefinition report = this.context.getReport();
        MasterReport masterReport = DesignTimeUtil.getMasterReport((Element)report);
        ResourceManager resourceManager = masterReport.getResourceManager();
        ResourceKey contextKey = masterReport.getContentBase();
        String designTimeFile = this.filenameField.getText();
        return MondrianUtil.parseSchemaName((ResourceManager)resourceManager, (ResourceKey)contextKey, (String)designTimeFile);
    }

    protected void refreshSchemaName() {
        this.cubeConnectionNameField.setText("");
        this.autoRefreshSchemaName();
    }

    private class RefreshSchemaNameAction
    extends AbstractAction {
        private RefreshSchemaNameAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.UpdateSchema.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MondrianDataSourceEditor.this.refreshSchemaName();
        }
    }

    private class QueryScriptDocumentListener
    extends DocumentChangeHandler {
        private QueryScriptDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            DataSetQuery query = MondrianDataSourceEditor.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                query.setScript(MondrianDataSourceEditor.this.queryScriptTextArea.getText());
            }
        }
    }

    private class UpdateScriptLanguageHandler
    implements ActionListener,
    ListSelectionListener {
        private UpdateScriptLanguageHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DataSetQuery query = MondrianDataSourceEditor.this.dialogModel.getQueries().getSelectedQuery();
            if (query != null) {
                ScriptEngineFactory selectedItem = (ScriptEngineFactory)MondrianDataSourceEditor.this.queryLanguageField.getSelectedItem();
                if (selectedItem != null) {
                    query.setScriptLanguage(selectedItem.getLanguageName());
                } else {
                    query.setScriptLanguage(null);
                }
            }
            MondrianDataSourceEditor.this.updateComponents();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MondrianDataSourceEditor.this.updateComponents();
        }
    }

    private class QueryTemplateAction
    extends AbstractAction {
        private URL resource;

        private QueryTemplateAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)MondrianDataSourceEditor.this.queryScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)MondrianDataSourceEditor.this), Messages.getString("MondrianDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("MondrianDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try {
                InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");
                try {
                    StringWriter w = new StringWriter();
                    IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                    MondrianDataSourceEditor.this.queryScriptTextArea.insert(w.toString(), 0);
                }
                finally {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = MondrianDataSourceEditor.this.queryScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = MondrianDataSourceEditor.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/query-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class GlobalTemplateAction
    extends AbstractAction {
        private URL resource;

        private GlobalTemplateAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.InsertTemplate", new Object[0]));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.resource == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)MondrianDataSourceEditor.this.globalScriptTextArea.getText(), (boolean)true) && JOptionPane.showConfirmDialog((Component)((Object)MondrianDataSourceEditor.this), Messages.getString("MondrianDataSourceEditor.OverwriteScript", new Object[0]), Messages.getString("MondrianDataSourceEditor.OverwriteScriptTitle", new Object[0]), 0) != 0) {
                return;
            }
            try {
                InputStreamReader r = new InputStreamReader(this.resource.openStream(), "UTF-8");
                try {
                    StringWriter w = new StringWriter();
                    IOUtils.getInstance().copyWriter((Reader)r, (Writer)w);
                    MondrianDataSourceEditor.this.globalScriptTextArea.setText(w.toString());
                }
                finally {
                    r.close();
                }
            }
            catch (IOException ex) {
                logger.warn((Object)"Unable to read template.", (Throwable)ex);
            }
        }

        public void update() {
            String key = MondrianDataSourceEditor.this.globalScriptTextArea.getSyntaxEditingStyle();
            if (key.startsWith("text/")) {
                key = key.substring(5);
            }
            this.resource = MondrianDataSourceEditor.class.getResource("/org/pentaho/reporting/engine/classic/core/designtime/datafactory/scripts/global-template-" + key + ".txt");
            this.setEnabled(this.resource != null);
        }
    }

    private class EditSecurityAction
    extends AbstractAction {
        private EditSecurityAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.EditSecurityAction.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MondrianDataSourceEditor.this.securityDialog.setRoleField(MondrianDataSourceEditor.this.roleField);
            MondrianDataSourceEditor.this.securityDialog.setRole(MondrianDataSourceEditor.this.roleText);
            MondrianDataSourceEditor.this.securityDialog.setJdbcPassword(MondrianDataSourceEditor.this.jdbcPasswordText);
            MondrianDataSourceEditor.this.securityDialog.setJdbcPasswordField(MondrianDataSourceEditor.this.jdbcPasswordField);
            MondrianDataSourceEditor.this.securityDialog.setJdbcUser(MondrianDataSourceEditor.this.jdbcUserText);
            MondrianDataSourceEditor.this.securityDialog.setJdbcUserField(MondrianDataSourceEditor.this.jdbcUserField);
            MondrianDataSourceEditor.this.securityDialog.setMondrianProperties(MondrianDataSourceEditor.this.mondrianProperties);
            if (MondrianDataSourceEditor.this.securityDialog.performEdit()) {
                MondrianDataSourceEditor.this.roleText = MondrianDataSourceEditor.this.securityDialog.getRole();
                MondrianDataSourceEditor.this.roleField = MondrianDataSourceEditor.this.securityDialog.getRoleField();
                MondrianDataSourceEditor.this.jdbcUserText = MondrianDataSourceEditor.this.securityDialog.getJdbcUser();
                MondrianDataSourceEditor.this.jdbcUserField = MondrianDataSourceEditor.this.securityDialog.getJdbcUserField();
                MondrianDataSourceEditor.this.jdbcPasswordText = MondrianDataSourceEditor.this.securityDialog.getJdbcPassword();
                MondrianDataSourceEditor.this.jdbcPasswordField = MondrianDataSourceEditor.this.securityDialog.getJdbcPasswordField();
                MondrianDataSourceEditor.this.mondrianProperties = MondrianDataSourceEditor.this.securityDialog.getMondrianProperties();
            }
        }
    }

    private class QuerySelectedHandler
    implements ListSelectionListener {
        private QuerySelectedHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            MondrianDataSourceEditor.this.getDialogModel().getQueries().setSelectedItem(MondrianDataSourceEditor.this.queryNameList.getSelectedValue());
            boolean querySelected = MondrianDataSourceEditor.this.queryNameList.getSelectedIndex() != -1;
            MondrianDataSourceEditor.this.queryNameTextField.setEnabled(querySelected);
            MondrianDataSourceEditor.this.queryTextArea.setEnabled(MondrianDataSourceEditor.this.dialogModel.isQuerySelected());
            MondrianDataSourceEditor.this.queryScriptTextArea.setEnabled(MondrianDataSourceEditor.this.dialogModel.isQuerySelected());
            MondrianDataSourceEditor.this.queryLanguageField.setEnabled(MondrianDataSourceEditor.this.dialogModel.isQuerySelected());
            MondrianDataSourceEditor.this.queryTemplateAction.update();
            if (!MondrianDataSourceEditor.this.dialogModel.isQuerySelected()) {
                MondrianDataSourceEditor.this.queryTemplateAction.setEnabled(false);
            }
        }
    }

    private class QueryDocumentListener
    extends DocumentChangeHandler {
        private QueryDocumentListener() {
        }

        protected void handleChange(DocumentEvent e) {
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            DataSetQuery item = dialogModel.getQueries().getSelectedQuery();
            if (item == null) {
                return;
            }
            item.setQuery((Object)MondrianDataSourceEditor.this.queryTextArea.getText());
            dialogModel.getQueries().fireItemChanged((Object)item);
        }
    }

    private class PreviewAction
    extends AbstractAction
    implements PropertyChangeListener {
        private DataPreviewDialog previewDialog;

        private PreviewAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.Preview.Name", new Object[0]));
            this.setEnabled(MondrianDataSourceEditor.this.dialogModel.isConnectionSelected() && MondrianDataSourceEditor.this.dialogModel.isQuerySelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.setEnabled(MondrianDataSourceEditor.this.dialogModel.isConnectionSelected() && MondrianDataSourceEditor.this.dialogModel.isQuerySelected() && MondrianDataSourceEditor.this.dialogModel.getSchemaFileNameField().getText().length() != 0);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JdbcConnectionDefinition connectionDefinition = (JdbcConnectionDefinition)MondrianDataSourceEditor.this.dialogModel.getConnections().getSelectedItem();
            if (connectionDefinition == null) {
                return;
            }
            try {
                String query = MondrianDataSourceEditor.this.queryNameTextField.getText();
                Integer theMaxRows = 0;
                if (MondrianDataSourceEditor.this.maxPreviewRowsSpinner.isEnabled()) {
                    theMaxRows = (Integer)MondrianDataSourceEditor.this.maxPreviewRowsSpinner.getValue();
                }
                if (this.previewDialog == null) {
                    this.previewDialog = new DataPreviewDialog((Dialog)((Object)MondrianDataSourceEditor.this));
                }
                AbstractMDXDataFactory dataFactory = MondrianDataSourceEditor.this.createDataFactory();
                DataFactoryEditorSupport.configureDataFactoryForPreview((DataFactory)dataFactory, (DesignTimeContext)MondrianDataSourceEditor.this.context);
                MondrianPreviewWorker worker = new MondrianPreviewWorker(dataFactory, query, 0, theMaxRows);
                this.previewDialog.showData((PreviewWorker)worker);
                ReportDataFactoryException factoryException = worker.getException();
                if (factoryException != null) {
                    ExceptionDialog.showExceptionDialog((Component)((Object)MondrianDataSourceEditor.this), (String)Messages.getString("MondrianDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("MondrianDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)factoryException);
                }
            }
            catch (Exception e) {
                ExceptionDialog.showExceptionDialog((Component)((Object)MondrianDataSourceEditor.this), (String)Messages.getString("MondrianDataSourceEditor.PreviewError.Title", new Object[0]), (String)Messages.getString("MondrianDataSourceEditor.PreviewError.Message", new Object[0]), (Exception)e);
            }
        }
    }

    private class QueryNameTextFieldDocumentListener
    extends DocumentChangeHandler
    implements ListDataListener {
        private boolean inUpdate;

        private QueryNameTextFieldDocumentListener() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void contentsChanged(ListDataEvent e) {
            if (this.inUpdate) {
                return;
            }
            if (e.getIndex0() != -1) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            try {
                this.inUpdate = true;
                DataSetQuery selectedQuery = dialogModel.getQueries().getSelectedQuery();
                if (selectedQuery == null) {
                    MondrianDataSourceEditor.this.setQueryName(null);
                    MondrianDataSourceEditor.this.queryTextArea.setText(null);
                    MondrianDataSourceEditor.this.queryScriptTextArea.setText(null);
                    MondrianDataSourceEditor.this.queryLanguageField.setSelectedItem(null);
                    return;
                }
                MondrianDataSourceEditor.this.setQueryName(selectedQuery.getQueryName());
                MondrianDataSourceEditor.this.queryTextArea.setText((String)selectedQuery.getQuery());
                MondrianDataSourceEditor.this.queryScriptTextArea.setText(selectedQuery.getScript());
                MondrianDataSourceEditor.this.setScriptingLanguage(selectedQuery.getScriptLanguage(), (JComboBox)MondrianDataSourceEditor.this.queryLanguageField);
            }
            finally {
                this.inUpdate = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void handleChange(DocumentEvent e) {
            if (this.inUpdate) {
                return;
            }
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            DataSetQuery item = (DataSetQuery)dialogModel.getQueries().getSelectedItem();
            if (item == null) {
                return;
            }
            try {
                this.inUpdate = true;
                item.setQueryName(MondrianDataSourceEditor.this.getQueryName());
                dialogModel.getQueries().fireItemChanged((Object)item);
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    private class RemoveQueryAction
    extends AbstractAction
    implements PropertyChangeListener {
        protected RemoveQueryAction() {
            URL resource = MondrianDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/mondrian/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("MondrianDataSourceEditor.RemoveQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("MondrianDataSourceEditor.RemoveQuery.Description", new Object[0]));
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            this.setEnabled(dialogModel.isQuerySelected());
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            this.setEnabled(dialogModel.isQuerySelected());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            NamedDataSourceDialogModel dialogModel = MondrianDataSourceEditor.this.getDialogModel();
            DataSetComboBoxModel queries = dialogModel.getQueries();
            queries.removeElement(queries.getSelectedItem());
            queries.setSelectedItem(null);
            MondrianDataSourceEditor.this.queryNameList.clearSelection();
        }
    }

    private class AddQueryAction
    extends AbstractAction {
        protected AddQueryAction() {
            URL resource = MondrianDataSourceEditor.class.getResource("/org/pentaho/reporting/ui/datasources/mondrian/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("MondrianDataSourceEditor.AddQuery.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("MondrianDataSourceEditor.AddQuery.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String queryName = MondrianDataSourceEditor.this.dialogModel.generateQueryName();
            MondrianDataSourceEditor.this.dialogModel.addQuery(queryName, "", null, null);
            MondrianDataSourceEditor.this.queryNameList.setSelectedValue(queryName, true);
            MondrianDataSourceEditor.this.queryNameList.setSelectedIndex(MondrianDataSourceEditor.this.queryNameList.getLastVisibleIndex());
        }
    }

    private class ConfirmEnableHandler
    implements PropertyChangeListener,
    DocumentListener {
        private ConfirmEnableHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.revalidate();
        }

        private void revalidate() {
            MondrianDataSourceEditor.this.validateInputs(false);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (MondrianDataSourceEditor.this.dialogModel.isConnectionSelected() && MondrianDataSourceEditor.this.dialogModel.isQuerySelected() && !MondrianDataSourceEditor.this.dialogModel.isPreviewPossible()) {
                MondrianDataSourceEditor.this.dialogModel.setPreviewPossible(true);
            }
            this.revalidate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (MondrianDataSourceEditor.this.dialogModel.getSchemaFileNameField().getText().isEmpty() && MondrianDataSourceEditor.this.dialogModel.isPreviewPossible()) {
                MondrianDataSourceEditor.this.dialogModel.setPreviewPossible(false);
            }
            this.revalidate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.revalidate();
        }
    }

    private class BrowseAction
    extends AbstractAction {
        protected BrowseAction() {
            this.putValue("Name", Messages.getString("MondrianDataSourceEditor.Browse.Name", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            File reportContextFile = DesignTimeUtil.getContextAsFile((AbstractReportDefinition)MondrianDataSourceEditor.this.context.getReport());
            File initiallySelectedFile = !StringUtils.isEmpty((String)MondrianDataSourceEditor.this.getFileName(), (boolean)true) ? (reportContextFile == null ? new File(MondrianDataSourceEditor.this.getFileName()) : new File(reportContextFile.getParentFile(), MondrianDataSourceEditor.this.getFileName())) : null;
            FileFilter[] fileFilters = new FileFilter[]{new FilesystemFilter(new String[]{".xml"}, Messages.getString("MondrianDataSourceEditor.FileName", new Object[0]) + " (*.xml)", true)};
            CommonFileChooser fileChooser = FileChooserService.getInstance().getFileChooser("mondrian");
            fileChooser.setSelectedFile(initiallySelectedFile);
            fileChooser.setFilters(fileFilters);
            if (!fileChooser.showDialog((Component)((Object)MondrianDataSourceEditor.this), 0)) {
                return;
            }
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            String path = reportContextFile != null ? IOUtils.getInstance().createRelativePath(file.getPath(), reportContextFile.getAbsolutePath()) : file.getPath();
            MondrianDataSourceEditor.this.setFileName(path);
            MondrianDataSourceEditor.this.autoRefreshSchemaName();
        }
    }
}

