/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.impl.Log4JLogger;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.pentaho.di.core.logging.KettleLogChannelAppender;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;

public class JobEntryUtils {
    public static Logger findLogger(String logName) {
        Log log = LogFactory.getLog((String)logName);
        if (log instanceof Log4JLogger) {
            Logger logger = ((Log4JLogger)log).getLogger();
            if (logger == null) {
                throw new IllegalArgumentException("Logger does not exist for log: " + logName);
            }
            return logger;
        }
        if (log == null) {
            throw new IllegalArgumentException("Unknown log name: " + logName);
        }
        throw new IllegalArgumentException("Unsupported logging type: " + log.getClass());
    }

    public static void attachAppenderTo(Appender appender, LogLevel logLevel, Map<String, Level> logLevelCache, String ... logNames) {
        for (String logName : logNames) {
            Logger logger = JobEntryUtils.findLogger(logName);
            logger.addAppender(appender);
            Level level = (Level)KettleLogChannelAppender.LOG_LEVEL_MAP.get(logLevel);
            if (level == null) continue;
            logLevelCache.put(logger.getName(), logger.getLevel());
            logger.setLevel(level);
        }
    }

    public static void removeAppenderFrom(Appender appender, Map<String, Level> logLevelCache, String ... logNames) {
        for (String logName : logNames) {
            Logger logger = JobEntryUtils.findLogger(logName);
            logger.removeAppender(appender);
            if (!logLevelCache.containsKey(logger.getName())) continue;
            logger.setLevel(logLevelCache.get(logger.getName()));
            logLevelCache.remove(logger.getName());
        }
        appender.close();
    }

    public static boolean asBoolean(String s, VariableSpace variableSpace) {
        String value = variableSpace.environmentSubstitute(s);
        return Boolean.parseBoolean(value);
    }

    public static Long asLong(String s, VariableSpace variableSpace) {
        String value = variableSpace.environmentSubstitute(s);
        return value == null ? null : Long.valueOf(value, 10);
    }
}

