/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionRunningCountForRangeJPAExecutor
implements JPAExecutor<Long> {
    private String jobId = null;
    private String startAction;
    private String endAction;

    public CoordJobGetActionRunningCountForRangeJPAExecutor(String jobId, String startAction, String endAction) {
        ParamChecker.notNull(jobId, "jobId");
        this.jobId = jobId;
        this.startAction = startAction;
        this.endAction = endAction;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionIdsForDateRangeJPAExecutor";
    }

    @Override
    public Long execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTIONS_COUNT_RUNNING_FOR_RANGE");
            q.setParameter("jobId", (Object)this.jobId);
            q.setParameter("startAction", (Object)this.startAction);
            q.setParameter("endAction", (Object)this.endAction);
            Long count = (Long)q.getSingleResult();
            return count;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

