/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.validation.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.DBLiteWorkflowLib;

public class DBLiteWorkflowStoreService
extends LiteWorkflowStoreService
implements Instrumentable {
    private boolean selectForUpdate;
    private XLog log;
    private int statusWindow;
    public static final String CONF_PREFIX = "oozie.service.DBLiteWorkflowStoreService.";
    public static final String CONF_METRICS_INTERVAL_MINS = "oozie.service.DBLiteWorkflowStoreService.status.metrics.collection.interval";
    public static final String CONF_METRICS_INTERVAL_WINDOW = "oozie.service.DBLiteWorkflowStoreService.status.metrics.window";
    private static final String INSTRUMENTATION_GROUP = "jobstatus";
    private static final String INSTRUMENTATION_GROUP_WINDOW = "windowjobstatus";
    private Map<String, Integer> statusCounts = new HashMap<String, Integer>();
    private Map<String, Integer> statusWindowCounts = new HashMap<String, Integer>();

    @Override
    public void init(Services services) throws ServiceException {
        WorkflowJob.Status[] wfStatusArr;
        Configuration conf = services.getConf();
        this.statusWindow = conf.getInt(CONF_METRICS_INTERVAL_WINDOW, 3600);
        int statusMetricsCollectionInterval = conf.getInt(CONF_METRICS_INTERVAL_MINS, 5);
        this.log = XLog.getLog(this.getClass());
        this.selectForUpdate = false;
        for (WorkflowJob.Status aWfStatusArr : wfStatusArr = WorkflowJob.Status.values()) {
            this.statusCounts.put(aWfStatusArr.name(), 0);
            this.statusWindowCounts.put(aWfStatusArr.name(), 0);
        }
        JobStatusCountCallable jobStatusCountCallable = new JobStatusCountCallable();
        services.get(SchedulerService.class).schedule(jobStatusCountCallable, 1L, (long)statusMetricsCollectionInterval, SchedulerService.Unit.MIN);
    }

    @Override
    public void destroy() {
    }

    @Override
    public WorkflowLib getWorkflowLibWithNoDB() {
        return this.getWorkflowLib(null);
    }

    private WorkflowLib getWorkflowLib(Connection conn) {
        Schema schema = Services.get().get(SchemaService.class).getSchema(SchemaService.SchemaName.WORKFLOW);
        return new DBLiteWorkflowLib(schema, LiteWorkflowStoreService.LiteControlNodeHandler.class, LiteWorkflowStoreService.LiteDecisionHandler.class, LiteWorkflowStoreService.LiteActionHandler.class, conn);
    }

    @Override
    public WorkflowStore create() throws StoreException {
        try {
            return new WorkflowStore(this.selectForUpdate);
        }
        catch (Exception ex) {
            throw new StoreException(ErrorCode.E0600, ex.getMessage(), ex);
        }
    }

    @Override
    public <S extends Store> WorkflowStore create(S store) throws StoreException {
        try {
            return new WorkflowStore(store, this.selectForUpdate);
        }
        catch (Exception ex) {
            throw new StoreException(ErrorCode.E0600, ex.getMessage(), ex);
        }
    }

    @Override
    public void instrument(Instrumentation instr) {
        WorkflowJob.Status[] wfStatusArr;
        for (WorkflowJob.Status aWfStatusArr : wfStatusArr = WorkflowJob.Status.values()) {
            final String statusName = aWfStatusArr.name();
            instr.addVariable(INSTRUMENTATION_GROUP, statusName, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return ((Integer)DBLiteWorkflowStoreService.this.statusCounts.get(statusName)).longValue();
                }
            });
            instr.addVariable(INSTRUMENTATION_GROUP_WINDOW, statusName, new Instrumentation.Variable<Long>(){

                @Override
                public Long getValue() {
                    return ((Integer)DBLiteWorkflowStoreService.this.statusWindowCounts.get(statusName)).longValue();
                }
            });
        }
    }

    class JobStatusCountCallable
    implements Runnable {
        JobStatusCountCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkflowStore store = null;
            try {
                WorkflowJob.Status[] wfStatusArr;
                store = Services.get().get(WorkflowStoreService.class).create();
                store.beginTrx();
                for (WorkflowJob.Status aWfStatusArr : wfStatusArr = WorkflowJob.Status.values()) {
                    DBLiteWorkflowStoreService.this.statusCounts.put(aWfStatusArr.name(), store.getWorkflowCountWithStatus(aWfStatusArr.name()));
                    DBLiteWorkflowStoreService.this.statusWindowCounts.put(aWfStatusArr.name(), store.getWorkflowCountWithStatusInLastNSeconds(aWfStatusArr.name(), DBLiteWorkflowStoreService.this.statusWindow));
                }
                store.commitTrx();
            }
            catch (StoreException e) {
                if (store != null) {
                    store.rollbackTrx();
                }
                DBLiteWorkflowStoreService.this.log.warn((Object)"Exception while accessing the store", e);
            }
            catch (Exception ex) {
                DBLiteWorkflowStoreService.this.log.error("Exception, {0}", ex.getMessage(), ex);
                if (store != null && store.isActive()) {
                    try {
                        store.rollbackTrx();
                    }
                    catch (RuntimeException rex) {
                        DBLiteWorkflowStoreService.this.log.warn("openjpa error, {0}", rex.getMessage(), rex);
                    }
                }
            }
            finally {
                if (store != null) {
                    if (!store.isActive()) {
                        try {
                            store.closeTrx();
                        }
                        catch (RuntimeException rex) {
                            DBLiteWorkflowStoreService.this.log.warn((Object)"Exception while attempting to close store", rex);
                        }
                    } else {
                        DBLiteWorkflowStoreService.this.log.warn("transaction is not committed or rolled back before closing entitymanager.");
                    }
                }
            }
        }
    }
}

