/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimeZone;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Expression;
import net.hydromatic.linq4j.expressions.Expressions;
import net.hydromatic.linq4j.expressions.MethodCallExpression;
import net.hydromatic.linq4j.expressions.Types;
import net.hydromatic.optiq.BuiltinMethod;
import net.hydromatic.optiq.DataContext;
import net.hydromatic.optiq.Parameter;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.TableFunction;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.jdbc.ConnectionConfig;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.jdbc.OptiqPrepare;
import net.hydromatic.optiq.jdbc.OptiqRootSchema;
import net.hydromatic.optiq.jdbc.OptiqSchema;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.type.SqlTypeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Schemas {
    private Schemas() {
        throw new AssertionError((Object)"no instances!");
    }

    public static OptiqSchema.TableFunctionEntry resolve(RelDataTypeFactory typeFactory, String name, Collection<OptiqSchema.TableFunctionEntry> tableFunctions, List<RelDataType> argumentTypes) {
        ArrayList<OptiqSchema.TableFunctionEntry> matches = new ArrayList<OptiqSchema.TableFunctionEntry>();
        for (OptiqSchema.TableFunctionEntry member : tableFunctions) {
            if (!Schemas.matches(typeFactory, member.getTableFunction(), argumentTypes)) continue;
            matches.add(member);
        }
        switch (matches.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (OptiqSchema.TableFunctionEntry)matches.get(0);
            }
        }
        throw new RuntimeException("More than one match for " + name + " with arguments " + argumentTypes);
    }

    private static boolean matches(RelDataTypeFactory typeFactory, TableFunction member, List<RelDataType> argumentTypes) {
        List<Parameter> parameters = member.getParameters();
        if (parameters.size() != argumentTypes.size()) {
            return false;
        }
        for (int i = 0; i < argumentTypes.size(); ++i) {
            Parameter parameter;
            RelDataType argumentType = argumentTypes.get(i);
            if (Schemas.canConvert(argumentType, (parameter = parameters.get(i)).getType(typeFactory))) continue;
            return false;
        }
        return true;
    }

    private static boolean canConvert(RelDataType fromType, RelDataType toType) {
        return SqlTypeUtil.canAssignFrom(toType, fromType);
    }

    public static TableFunction methodMember(final Method method, final JavaTypeFactory typeFactory) {
        final ArrayList<1> parameters = new ArrayList<1>();
        for (final Class<?> parameterType : method.getParameterTypes()) {
            parameters.add(new Parameter(){
                final int ordinal;
                final RelDataType type;
                {
                    this.ordinal = parameters.size();
                    this.type = typeFactory.createType(parameterType);
                }

                public int getOrdinal() {
                    return this.ordinal;
                }

                public String getName() {
                    return "a" + this.ordinal;
                }

                public RelDataType getType(RelDataTypeFactory typeFactory2) {
                    return this.type;
                }
            });
        }
        return new TableFunction(){

            @Override
            public List<Parameter> getParameters() {
                return parameters;
            }

            @Override
            public Table apply(List<Object> arguments) {
                try {
                    return (Table)method.invoke(null, arguments.toArray());
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public RelDataType getRowType(RelDataTypeFactory typeFactory) {
                Class<?> returnType = method.getReturnType();
                return ((JavaTypeFactory)typeFactory).createType(returnType);
            }
        };
    }

    public static List<String> path(Schema schema, String name) {
        ArrayList<String> list = new ArrayList<String>();
        if (name != null) {
            list.add(name);
        }
        for (Schema s = schema; s != null; s = s.getParentSchema()) {
            if (s.getParentSchema() == null && s.getName().equals("")) continue;
            list.add(s.getName());
        }
        return ImmutableList.copyOf((Collection)Lists.reverse(list));
    }

    public static Schema root(Schema schema) {
        Schema previous;
        Schema s = schema;
        do {
            previous = s;
        } while ((s = s.getParentSchema()) != null);
        return previous;
    }

    public static Expression subSchemaExpression(Schema schema, String name, Class type) {
        MethodCallExpression call = Expressions.call((Expression)schema.getExpression(), (Method)BuiltinMethod.SCHEMA_GET_SUB_SCHEMA.method, (Expression[])new Expression[]{Expressions.constant((Object)name)});
        return call;
    }

    public static Expression unwrap(Expression call, Class type) {
        return Expressions.convert_((Expression)Expressions.call((Expression)call, (Method)BuiltinMethod.SCHEMA_PLUS_UNWRAP.method, (Expression[])new Expression[]{Expressions.constant((Object)type)}), (Type)type);
    }

    public static Expression tableExpression(Schema schema, Type elementType, String tableName, Class clazz) {
        MethodCallExpression expression = Table.class.isAssignableFrom(clazz) ? Expressions.call((Expression)schema.getExpression(), (Method)BuiltinMethod.SCHEMA_GET_TABLE.method, (Expression[])new Expression[]{Expressions.constant((Object)tableName)}) : Expressions.call((Method)BuiltinMethod.SCHEMAS_QUERYABLE.method, (Expression[])new Expression[]{DataContext.ROOT, schema.getExpression(), Expressions.constant((Object)elementType), Expressions.constant((Object)tableName)});
        return Types.castIfNecessary((Type)clazz, (Expression)expression);
    }

    public static DataContext createDataContext(Connection connection) {
        return new DummyDataContext((OptiqConnection)connection);
    }

    public static <E> Queryable<E> queryable(DataContext root, Class<E> clazz, String ... names) {
        SchemaPlus schema = root.getRootSchema();
        for (int i = 0; i < names.length - 1; ++i) {
            String name = names[i];
            schema = schema.getSubSchema(name);
        }
        String tableName = names[names.length - 1];
        return Schemas.queryable(root, schema, clazz, tableName);
    }

    public static <E> Queryable<E> queryable(DataContext root, SchemaPlus schema, Class<E> clazz, String tableName) {
        QueryableTable table = (QueryableTable)schema.getTable(tableName);
        return table.asQueryable(root.getQueryProvider(), schema, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OptiqPrepare.ParseResult parse(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        OptiqPrepare.Context context = Schemas.makeContext(connection, schema, schemaPath);
        OptiqPrepare.Dummy.push(context);
        try {
            OptiqPrepare.ParseResult parseResult = prepare.parse(context, sql);
            return parseResult;
        }
        finally {
            OptiqPrepare.Dummy.pop(context);
        }
    }

    public static OptiqPrepare.PrepareResult<Object> prepare(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath, String sql) {
        OptiqPrepare prepare = (OptiqPrepare)OptiqPrepare.DEFAULT_FACTORY.apply();
        return prepare.prepareSql(Schemas.makeContext(connection, schema, schemaPath), sql, null, (Type)((Object)Object[].class), -1);
    }

    private static OptiqPrepare.Context makeContext(OptiqConnection connection, OptiqSchema schema, List<String> schemaPath) {
        if (connection == null) {
            OptiqPrepare.Context context0 = OptiqPrepare.Dummy.peek();
            return Schemas.makeContext(context0.config(), context0.getTypeFactory(), context0.getDataContext(), schema, schemaPath);
        }
        return Schemas.makeContext(connection.config(), connection.getTypeFactory(), Schemas.createDataContext(connection), schema, schemaPath);
    }

    private static OptiqPrepare.Context makeContext(final ConnectionConfig connectionConfig, final JavaTypeFactory typeFactory, final DataContext dataContext, final OptiqSchema schema, final List<String> schemaPath) {
        return new OptiqPrepare.Context(){

            @Override
            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            @Override
            public OptiqRootSchema getRootSchema() {
                return schema.root();
            }

            @Override
            public List<String> getDefaultSchemaPath() {
                if (schemaPath == null) {
                    return Schemas.path(schema.schema, null);
                }
                return schemaPath;
            }

            @Override
            public ConnectionConfig config() {
                return connectionConfig;
            }

            @Override
            public DataContext getDataContext() {
                return dataContext;
            }

            @Override
            public OptiqPrepare.SparkHandler spark() {
                boolean enable = this.config().spark();
                return OptiqPrepare.Dummy.getSparkHandler(enable);
            }
        };
    }

    public static RelProtoDataType proto(final Table table) {
        return new RelProtoDataType(){

            public RelDataType apply(RelDataTypeFactory typeFactory) {
                return table.getRowType(typeFactory);
            }
        };
    }

    private static class DummyDataContext
    implements DataContext {
        private final OptiqConnection connection;
        private final ImmutableMap<String, Object> map;

        public DummyDataContext(OptiqConnection connection) {
            this.connection = connection;
            this.map = ImmutableMap.of((Object)"timeZone", (Object)TimeZone.getDefault());
        }

        public SchemaPlus getRootSchema() {
            return this.connection.getRootSchema();
        }

        public JavaTypeFactory getTypeFactory() {
            return this.connection.getTypeFactory();
        }

        public QueryProvider getQueryProvider() {
            return this.connection;
        }

        public Object get(String name) {
            return this.map.get((Object)name);
        }
    }
}

