/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.clone;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.optiq.QueryableTable;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaFactory;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.Schemas;
import net.hydromatic.optiq.Table;
import net.hydromatic.optiq.impl.AbstractSchema;
import net.hydromatic.optiq.impl.MaterializedViewTable;
import net.hydromatic.optiq.impl.clone.ArrayTable;
import net.hydromatic.optiq.impl.clone.ColumnLoader;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import org.eigenbase.reltype.RelProtoDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneSchema
extends AbstractSchema {
    private final SchemaPlus sourceSchema;

    public CloneSchema(SchemaPlus parentSchema, String name, SchemaPlus sourceSchema) {
        super(parentSchema, name);
        this.sourceSchema = sourceSchema;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        LinkedHashMap<String, Table> map = new LinkedHashMap<String, Table>();
        for (String name : this.sourceSchema.getTableNames()) {
            QueryableTable sourceTable = (QueryableTable)this.sourceSchema.getTable(name);
            map.put(name, this.createCloneTable(MaterializedViewTable.MATERIALIZATION_CONNECTION, sourceTable, name));
        }
        return map;
    }

    private Table createCloneTable(QueryProvider queryProvider, QueryableTable sourceTable, String name) {
        Queryable queryable = sourceTable.asQueryable(queryProvider, this.sourceSchema, name);
        JavaTypeFactory typeFactory = ((OptiqConnection)queryProvider).getTypeFactory();
        return CloneSchema.createCloneTable(typeFactory, Schemas.proto(sourceTable), null, queryable);
    }

    public static <T> Table createCloneTable(final JavaTypeFactory typeFactory, final RelProtoDataType protoRowType, final List<ColumnMetaData.Rep> repList, final Enumerable<T> source) {
        Class<Object[]> elementType = source instanceof QueryableTable ? ((QueryableTable)source).getElementType() : Object[].class;
        return new ArrayTable((Type)((Object)elementType), protoRowType, (Supplier<ArrayTable.Content>)Suppliers.memoize((Supplier)new Supplier<ArrayTable.Content>(){

            public ArrayTable.Content get() {
                ColumnLoader loader = new ColumnLoader(typeFactory, source, protoRowType, repList);
                return new ArrayTable.Content(loader.representationValues, loader.size(), loader.sortField);
            }
        }));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            SchemaPlus schema = parentSchema.add(JdbcSchema.create(parentSchema, name + "$source", operand));
            return new CloneSchema(parentSchema, name, schema);
        }
    }
}

