/*
 * Decompiled with CFR 0.152.
 */
package net.hydromatic.optiq.impl.jdbc;

import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.hydromatic.linq4j.Enumerable;
import net.hydromatic.linq4j.Enumerator;
import net.hydromatic.linq4j.QueryProvider;
import net.hydromatic.linq4j.Queryable;
import net.hydromatic.linq4j.expressions.Primitive;
import net.hydromatic.linq4j.function.Function1;
import net.hydromatic.linq4j.function.Functions;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.SchemaPlus;
import net.hydromatic.optiq.TranslatableTable;
import net.hydromatic.optiq.impl.AbstractTableQueryable;
import net.hydromatic.optiq.impl.java.AbstractQueryableTable;
import net.hydromatic.optiq.impl.java.JavaTypeFactory;
import net.hydromatic.optiq.impl.jdbc.JdbcSchema;
import net.hydromatic.optiq.impl.jdbc.JdbcTableScan;
import net.hydromatic.optiq.impl.jdbc.JdbcUtils;
import net.hydromatic.optiq.jdbc.OptiqConnection;
import net.hydromatic.optiq.runtime.ResultSetEnumerable;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptTable;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelProtoDataType;
import org.eigenbase.sql.SqlIdentifier;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlSelect;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.sql.pretty.SqlPrettyWriter;
import org.eigenbase.sql.util.SqlString;
import org.eigenbase.util.Pair;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JdbcTable
extends AbstractQueryableTable
implements TranslatableTable {
    private RelProtoDataType protoRowType;
    private final JdbcSchema jdbcSchema;
    private final String jdbcCatalogName;
    private final String jdbcSchemaName;
    private final String jdbcTableName;
    private final Schema.TableType jdbcTableType;

    public JdbcTable(JdbcSchema jdbcSchema, String jdbcCatalogName, String jdbcSchemaName, String tableName, Schema.TableType jdbcTableType) {
        super((Type)((Object)Object[].class));
        this.jdbcSchema = jdbcSchema;
        this.jdbcCatalogName = jdbcCatalogName;
        this.jdbcSchemaName = jdbcSchemaName;
        this.jdbcTableName = tableName;
        this.jdbcTableType = jdbcTableType;
    }

    public String toString() {
        return "JdbcTable {" + this.jdbcTableName + "}";
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return this.jdbcTableType;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        if (this.protoRowType == null) {
            try {
                this.protoRowType = this.jdbcSchema.getRelDataType(this.jdbcCatalogName, this.jdbcSchemaName, this.jdbcTableName);
            }
            catch (SQLException e) {
                throw new RuntimeException("Exception while reading definition of table '" + this.jdbcTableName + "'", e);
            }
        }
        return (RelDataType)this.protoRowType.apply(typeFactory);
    }

    private List<Pair<Primitive, Integer>> fieldClasses(final JavaTypeFactory typeFactory) {
        RelDataType rowType = (RelDataType)this.protoRowType.apply(typeFactory);
        return Functions.adapt(rowType.getFieldList(), (Function1)new Function1<RelDataTypeField, Pair<Primitive, Integer>>(){

            public Pair<Primitive, Integer> apply(RelDataTypeField field) {
                RelDataType type = field.getType();
                Class clazz = (Class)typeFactory.getJavaClass(type);
                return Pair.of(Util.first(Primitive.of((Type)clazz), Primitive.OTHER), type.getSqlTypeName().getJdbcOrdinal());
            }
        });
    }

    SqlString generateSql() {
        SqlNodeList selectList = new SqlNodeList(Collections.singletonList(new SqlIdentifier("*", SqlParserPos.ZERO)), SqlParserPos.ZERO);
        SqlSelect node = new SqlSelect(SqlParserPos.ZERO, SqlNodeList.EMPTY, selectList, this.tableName(), null, null, null, null, null, null, null);
        SqlPrettyWriter writer = new SqlPrettyWriter(this.jdbcSchema.dialect);
        node.unparse(writer, 0, 0);
        return writer.toSqlString();
    }

    SqlIdentifier tableName() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.jdbcSchema.catalog != null) {
            strings.add(this.jdbcSchema.catalog);
        }
        if (this.jdbcSchema.schema != null) {
            strings.add(this.jdbcSchema.schema);
        }
        strings.add(this.jdbcTableName);
        return new SqlIdentifier(strings, SqlParserPos.ZERO);
    }

    @Override
    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        return new JdbcTableScan(context.getCluster(), relOptTable, this, this.jdbcSchema.convention);
    }

    @Override
    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

            public Enumerator<T> enumerator() {
                JavaTypeFactory typeFactory = ((OptiqConnection)this.queryProvider).getTypeFactory();
                SqlString sql = JdbcTable.this.generateSql();
                Enumerable<Object[]> enumerable = ResultSetEnumerable.of(JdbcTable.this.jdbcSchema.getDataSource(), sql.getSql(), JdbcUtils.ObjectArrayRowBuilder.factory(JdbcTable.this.fieldClasses(typeFactory)));
                return enumerable.enumerator();
            }
        };
    }
}

